/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.jms.JMSUtils;
import java.net.InetAddress;
import java.util.Locale;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.JMSConnectionCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JMSConnectionMBean;
import oracle.oc4j.admin.management.shared.statistic.JMSConnectionStatsImpl;

public class JMSConnection
extends J2EEServerDependentObjectBase
implements JMSConnectionMBean {
    private JMSConnectionCallBackIf m_callback;
    private String m_clientID;
    private String m_user;
    private String m_domain;
    private boolean m_isXA;
    private boolean m_isLocal = true;
    private InetAddress m_addr;
    private int m_port;
    private long m_startTime;

    public JMSConnection(JMSConnectionCallBackIf callback, String id, String user, String domain, boolean isXA, long startTime) {
        this(callback, id, user, domain, isXA, true, null, 0, startTime);
    }

    public JMSConnection(JMSConnectionCallBackIf callback, String id, String user, String domain, boolean isXA, InetAddress addr, int port, long startTime) {
        this(callback, id, user, domain, isXA, false, addr, port, startTime);
    }

    private JMSConnection(JMSConnectionCallBackIf callback, String id, String user, String domain, boolean isXA, boolean isLocal, InetAddress addr, int port, long startTime) {
        this.m_callback = callback;
        this.m_user = user;
        this.m_domain = domain;
        this.m_isXA = isXA;
        this.m_isLocal = isLocal;
        this.m_addr = addr;
        this.m_port = port;
        this.m_startTime = startTime;
        this.setBaseObjectName(":j2eeType=JMSConnectionResource,name=" + ObjectNameUtil.quote((String)id) + ",JMSResource=" + ObjectNameUtil.quote((String)"JMS") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JMSConnection(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("jms_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("user", "java.lang.String", this.getLocalizedMessage("jmsconnection_user"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("domain", "java.lang.String", this.getLocalizedMessage("jmsconnection_domain"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("isLocal", "boolean", this.getLocalizedMessage("jmsconnection_islocal"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("isXA", "boolean", this.getLocalizedMessage("jmsconnection_isxa"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("startTime", "long", this.getLocalizedMessage("jmsconnection_starttime"), true, false, false));
        if (!this.m_isLocal) {
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("address", "java.net.InetAddress", this.getLocalizedMessage("jmsconnection_address"), true, false, false));
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("host", "java.net.InetAddress", this.getLocalizedMessage("jmsconnection_host"), true, false, false));
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("port", "int", this.getLocalizedMessage("jmsconnection_port"), true, false, false));
        }
    }

    public final boolean getstatisticsProvider() {
        return true;
    }

    public Stats getstats() {
        return new JMSConnectionStatsImpl(J2EEManagedObjectBase.getLocaleForCall(), this.m_callback.getMetricPath(), (JMSConnectionStatsImpl)this.m_callback.getJSR77Stats());
    }

    public String getuser() {
        return this.m_user;
    }

    public String getdomain() {
        return this.m_domain;
    }

    public boolean getisLocal() {
        return this.m_isLocal;
    }

    public boolean getisXA() {
        return this.m_isXA;
    }

    public InetAddress getaddress() {
        return this.m_addr;
    }

    public InetAddress gethost() {
        return JMSUtils.normalize(this.m_addr);
    }

    public int getport() {
        return this.m_port;
    }

    public void setclientID(String id) {
        this.m_clientID = id;
    }

    public String getclientID() {
        return this.m_clientID;
    }

    public String getexceptionListener() {
        return this.m_callback.getExceptionListenerName();
    }

    public long getstartTime() {
        return this.m_startTime;
    }
}

