/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectInstanceGatekeeperCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JCAAdminObjectMBean;

public class JCAAdminObject
extends J2EEServerDependentObjectBase
implements JCAAdminObjectMBean {
    JCAAdminObjectCallBackIf callBackIf_ = null;
    JCAAdminObjectInstanceGatekeeperCallBackIf gatekeeperCallBackIf_ = null;

    public JCAAdminObject(String connectorName, String moduleName, String j2eeAppName, String j2eeServerName, String domain, JCAAdminObjectCallBackIf callBackIf, JCAAdminObjectInstanceGatekeeperCallBackIf gatekeeperCallBackIf) {
        super(domain, j2eeServerName);
        this.callBackIf_ = callBackIf;
        this.gatekeeperCallBackIf_ = gatekeeperCallBackIf;
        this.setBaseObjectName(":j2eeType=JCAAdminObject,name=" + this.callBackIf_.getAdminObjectClass() + ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName);
        this.init();
    }

    public JCAAdminObject(String connectorName, String moduleName, String j2eeAppName, JCAAdminObjectCallBackIf callBackIf, JCAAdminObjectInstanceGatekeeperCallBackIf gatekeeperCallBackIf) {
        this.callBackIf_ = callBackIf;
        this.gatekeeperCallBackIf_ = gatekeeperCallBackIf;
        this.setBaseObjectName(":j2eeType=JCAAdminObject,name=" + this.callBackIf_.getAdminObjectClass() + ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public JCAAdminObject(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("interface", "java.lang.String", this.getLocalizedMessage("adminobject_interface"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("class", "java.lang.String", this.getLocalizedMessage("adminobject_class"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("configProperties", "java.util.HashSet", this.getLocalizedMessage("adminobject_configProperties"), true, false, false));
        MBeanParameterInfo[] addAdminObjParams = null;
        addAdminObjParams = new MBeanParameterInfo[]{new MBeanParameterInfo("jndiLocation", "java.lang.String", this.getLocalizedMessage("adminobject_jndiLocation")), new MBeanParameterInfo("properties", "java.util.Map", this.getLocalizedMessage("adminobjectinstance_configurationProperties"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addAdminObjectInstance", this.getLocalizedMessage("adminobject_addAdminObjectInstance"), addAdminObjParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] removeAdminObjParams = new MBeanParameterInfo[]{new MBeanParameterInfo("jndiLocation", "java.lang.String", this.getLocalizedMessage("adminobject_jndiLocation"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeAdminObjectInstance", this.getLocalizedMessage("adminobject_removeAdminObjectInstance"), removeAdminObjParams, "void", 1), persistenceDescriptorProperties);
    }

    public String getinterface() throws JMXException {
        return this.callBackIf_.getAdminObjectInterface();
    }

    public String getclass() throws JMXException {
        return this.callBackIf_.getAdminObjectClass();
    }

    public HashSet getconfigProperties() throws JMXException {
        return new HashSet(this.callBackIf_.getConfigurationProperties());
    }

    public void addAdminObjectInstance(String jndiLocation, Map properties) throws JMXException {
        try {
            this.gatekeeperCallBackIf_.generateAdminObjectInstance(jndiLocation, this.getclass(), properties);
        }
        catch (InstantiationException e) {
            throw new JMXException((Throwable)e, "Unable to add admin object instance via JMX MBean");
        }
    }

    public void removeAdminObjectInstance(String jndiLocation) throws JMXException {
        try {
            this.gatekeeperCallBackIf_.removeAdminObjectInstance(jndiLocation);
        }
        catch (InstantiationException e) {
            throw new JMXException((Throwable)e, "Unable to remove admin object instance via JMX MBean");
        }
        catch (InstanceNotFoundException e) {
            throw new JMXException((Throwable)e, "Unable to remove admin object instance via JMX MBean");
        }
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.gatekeeperCallBackIf_.persistUpdates();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }
}

