/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.ws.server.deployment;

import com.evermind.server.deployment.InjectableReference;
import com.evermind.server.deployment.InjectionTarget;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import oracle.j2ee.util.TraceLogger;
import oracle.j2ee.ws.server.deployment.ServiceRefInjectionHelper;
import oracle.j2ee.ws.server.deployment.ServiceRefPortInfo;
import oracle.j2ee.ws.server.deployment.WebServiceDeploymentHelper;
import oracle.j2ee.ws.server.deployment.WebServiceHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceReferenceDescriptor
extends InjectableReference
implements XMLizable,
Comparable {
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_SERVICE_REF_NAME = "service-ref-name";
    public static final String TAG_SERVICE_INTERFACE = "service-interface";
    public static final String TAG_WSDL_FILE = "wsdl-file";
    public static final String TAG_JAXRPC_MAPPING_FILE = "jaxrpc-mapping-file";
    public static final String TAG_SERVICE_QNAME = "service-qname";
    public static final String TAG_PORT_COMPONENT = "port-component-ref";
    public static final String TAG_HANDLER = "handler";
    public static final String TAG_INJECTION_TARGET = "injection-target";
    public static final String TAG_SERVICE_REF_TYPE = "service-ref-type";
    public static final String TAG_MAPPED_NAME = "mapped-name";
    public static final String DEFAULT_SERVICE_INTERFACE = "javax.xml.rpc.Service";
    private static final Logger s_logger = TraceLogger.getLogger(ServiceReferenceDescriptor.class);
    private LinkedList handlerChain = new LinkedList();
    private Map xmlNamespace;
    private Object m_runtimeData;
    private Object m_typeMappings;
    private QName serviceName;
    private Set callProperties = new HashSet();
    private Set portsInfo = new HashSet();
    private Set stubProperties = new HashSet();
    private String mappingFileUri;
    private String serviceImplClassName;
    private String serviceInterface;
    private String wsdlFileUri;
    private String mappedName;
    private URL wsdlFileUrl;
    private URL wsdlOverride;
    private long wsdlOverrideLastModified = 0L;
    static /* synthetic */ Class class$javax$xml$rpc$Service;

    public ServiceReferenceDescriptor() {
    }

    public ServiceReferenceDescriptor(Node parent) throws InstantiationException {
        this.parseXML(parent);
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            this.parseNode(name, node);
        }
        this.postInit();
    }

    protected void postInit() throws InstantiationException {
        try {
            if (this.getName() == null) {
                throw new InstantiationException("service-ref-name tag is missing ");
            }
            if (this.serviceInterface == null) {
                throw new InstantiationException("service-interface tag is missing ");
            }
            Iterator pIter = this.portsInfo.iterator();
            while (pIter.hasNext()) {
                ((ServiceRefPortInfo)pIter.next()).postInit();
            }
            Iterator iter = this.handlerChain.iterator();
            while (iter.hasNext()) {
                ((WebServiceHandler)iter.next()).postInit();
            }
        }
        catch (InstantiationException ie) {
            throw new InstantiationException(ie.getMessage() + " inside <service-ref> group ");
        }
    }

    public Object getTypeMappings() {
        return this.m_typeMappings;
    }

    protected void parseNode(String name, Node node) throws InstantiationException {
        if (name.equals(TAG_DESCRIPTION)) {
            super.setDescription(XMLUtils.getStringValue(node));
        } else if (name.equals(TAG_SERVICE_REF_NAME)) {
            super.setName(XMLUtils.getStringValue(node));
        } else if (name.equals(TAG_SERVICE_INTERFACE)) {
            this.serviceInterface = XMLUtils.getStringValue(node);
        } else if (name.equals(TAG_SERVICE_REF_TYPE)) {
            super.setReferenceClass(XMLUtils.getStringValue(node));
        } else if (name.equals(TAG_WSDL_FILE)) {
            this.wsdlFileUri = XMLUtils.getStringValue(node);
        } else if (name.equals(TAG_JAXRPC_MAPPING_FILE)) {
            this.mappingFileUri = XMLUtils.getStringValue(node);
        } else if (name.equals(TAG_SERVICE_QNAME)) {
            this.setServiceName(this.getQname(node));
        } else if (name.equals(TAG_PORT_COMPONENT)) {
            if (this.portsInfo == null) {
                this.portsInfo = new HashSet();
            }
            this.addPortInfo(new ServiceRefPortInfo(node));
        } else if (name.equals(TAG_HANDLER)) {
            this.handlerChain.addLast(new WebServiceHandler(node));
        } else if (name.equals(TAG_MAPPED_NAME)) {
            this.mappedName = XMLUtils.getStringValue(node);
        } else if (name.equals(TAG_INJECTION_TARGET)) {
            super.parseInjectionTarget(node);
        }
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("service-impl-class")) {
                this.setServiceImplClassName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals(TAG_WSDL_FILE)) {
                try {
                    this.setWsdlFileUrl(new URL(XMLUtils.getNodeAttribute(node, "final-location")));
                    continue;
                }
                catch (MalformedURLException me) {
                    throw new InstantiationException("<wsdl-file><final-location>: " + me.getMessage());
                }
            }
            if (name.equals("wsdl-location")) {
                try {
                    this.wsdlOverride = new URL(XMLUtils.getStringValue(node));
                    this.setWsdlOverrideLastModified(XMLUtils.getNodeAttribute(node, "wsdl-override-last-modified"));
                    continue;
                }
                catch (MalformedURLException me) {
                    throw new InstantiationException("<wsdl-location>: " + me.getMessage());
                }
            }
            if (name.equals(TAG_SERVICE_QNAME)) {
                this.setServiceName(new QName(XMLUtils.getNodeAttribute(node, "namespaceURI"), XMLUtils.getNodeAttribute(node, "localpart")));
                continue;
            }
            if (name.equals("stub-property")) {
                this.parseProperty("stub-property", node);
                continue;
            }
            if (name.equals("call-property")) {
                this.parseProperty("call-property", node);
                continue;
            }
            if (name.equals("port-info")) {
                ServiceRefPortInfo srPortInfo = new ServiceRefPortInfo();
                srPortInfo.parseProprietaryNode(node);
                this.addRuntimePortInfo(srPortInfo);
                this.addDefaultProperties(srPortInfo);
                continue;
            }
            if (!name.equals("type-mappings")) continue;
            this.m_typeMappings = ServiceReferenceDescriptor.getDeploymentHelper().loadTypeMappings(node);
        }
    }

    private static WebServiceDeploymentHelper getDeploymentHelper() {
        try {
            return (WebServiceDeploymentHelper)Class.forName("oracle.j2ee.ws.server.deployment.WebServiceDeploymentHelperImpl").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get deployment helper: " + e);
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        if (this.hasServiceImplClassName() || !this.callProperties.isEmpty() || !this.stubProperties.isEmpty() || this.hasTypeMappings()) {
            Map.Entry entry;
            out.print(indention + "<service-ref-mapping");
            if (this.getName() != null) {
                out.println(" name=\"" + XMLUtils.encode(this.getName()) + "\">");
            }
            if (this.hasServiceImplClassName()) {
                out.println(indention + "\t<service-impl-class>" + XMLUtils.encode(this.getServiceImplClassName()) + "</service-impl-class>");
            }
            if (this.hasWsdlFile() && !this.hasWsdlOverride()) {
                out.println(indention + "\t<wsdl-file final-location=\"" + XMLUtils.encode(this.getWsdlFileUrl().toString()) + "\"/>");
            }
            if (this.hasWsdlOverride()) {
                out.println(indention + "\t<wsdl-location " + (this.isWsdlOverrideAFile() ? "wsdl-override-last-modified=\"" + this.getWsdlOverrideLastModifide() + "\"" : "") + ">" + XMLUtils.encode(this.getWsdlOverride().toString()) + "</wsdl-location>");
            }
            if (this.hasServiceName()) {
                out.println(indention + "\t<service-qname namespaceURI=\"" + XMLUtils.encode(this.serviceName.getNamespaceURI()) + "\" localpart=\"" + XMLUtils.encode(this.serviceName.getLocalPart()) + "\"/>");
            }
            if (this.hasTypeMappings()) {
                ServiceReferenceDescriptor.getDeploymentHelper().writeTypeMapping(out, this.getTypeMappings());
            }
            Iterator it = this.stubProperties.iterator();
            while (it.hasNext()) {
                out.println(indention + "\t<stub-property>");
                entry = (Map.Entry)it.next();
                out.println(indention + "\t\t<name>" + XMLUtils.encode((String)entry.getKey()) + "</name>");
                out.println(indention + "\t\t<value>" + XMLUtils.encode((String)entry.getValue()) + "</value>");
                out.println(indention + "\t</stub-property>");
            }
            it = this.callProperties.iterator();
            while (it.hasNext()) {
                out.println(indention + "\t<call-property>");
                entry = (Map.Entry)it.next();
                out.println(indention + "\t\t<name>" + XMLUtils.encode((String)entry.getKey()) + "</name>");
                out.println(indention + "\t\t<value>" + XMLUtils.encode((String)entry.getValue()) + "</value>");
                out.println(indention + "\t</call-property>");
            }
            this.writePortsInfo(out, indention + indention);
            out.println(indention + "</service-ref-mapping>");
        }
        s_logger.fine(this.toString());
    }

    private boolean hasTypeMappings() {
        return this.getTypeMappings() != null;
    }

    private void parseProperty(String type, Node parent) {
        NodeList nodes = parent.getChildNodes();
        String paramName = null;
        String paramValue = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("name")) {
                paramName = XMLUtils.getStringValue(node);
                continue;
            }
            if (!name.equals("value")) continue;
            paramValue = XMLUtils.getStringValue(node);
            HashMap<String, String> nvPair = new HashMap<String, String>();
            nvPair.put(paramName, paramValue);
            if (type.equals("call-property")) {
                this.addCallProperty(nvPair.entrySet().iterator().next());
                continue;
            }
            if (!type.equals("stub-property")) continue;
            this.addStubProperty(nvPair.entrySet().iterator().next());
        }
    }

    private void writePortsInfo(PrintWriter out, String indention) throws IOException {
        XMLUtils.writeAll(this.portsInfo, out, indention + "\t");
    }

    public void writeXML(PrintWriter out, String indention) {
    }

    public Object getRuntimeData() {
        return this.m_runtimeData;
    }

    public void setRuntimeData(Object runtimeData) {
        this.m_runtimeData = runtimeData;
    }

    public boolean hasGenericServiceInterface() {
        return this.serviceInterface.equals(DEFAULT_SERVICE_INTERFACE);
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mn) {
        this.mappedName = mn;
    }

    public boolean hasGeneratedServiceInterface() {
        return !this.hasGenericServiceInterface();
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String intf) {
        this.serviceInterface = intf;
    }

    public boolean hasWsdlFile() {
        return this.wsdlFileUri != null;
    }

    public void setWsdlFileUrl(URL url) {
        this.wsdlFileUrl = url;
    }

    public URL getWsdlFileUrl() {
        return this.wsdlFileUrl;
    }

    public boolean hasWsdlFileUrl() {
        return this.wsdlFileUrl != null;
    }

    public String getWsdlFileUri() {
        return this.wsdlFileUri;
    }

    public void setWsdlFileUri(String uri) {
        this.wsdlFileUri = uri;
    }

    public boolean hasMappingFile() {
        return this.mappingFileUri != null;
    }

    public String getMappingFileUri() {
        return this.mappingFileUri;
    }

    public void setMappingFileUri(String uri) {
        this.mappingFileUri = uri;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public boolean hasServiceName() {
        return this.serviceName != null;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public Set getPortsInfo() {
        return this.portsInfo;
    }

    private void addPortInfo(ServiceRefPortInfo portInfo) {
        this.portsInfo.add(portInfo);
    }

    public void removePortInfo(ServiceRefPortInfo portInfo) {
        this.portsInfo.remove(portInfo);
    }

    public void addRuntimePortInfo(ServiceRefPortInfo runtimePortInfo) {
        if (!runtimePortInfo.hasServiceEndpointInterface() && !runtimePortInfo.hasWsdlPort()) {
            return;
        }
        ServiceRefPortInfo existing = this.getMatchingPortInfo(runtimePortInfo);
        if (existing == null) {
            this.addPortInfo(runtimePortInfo);
        } else {
            if (!existing.hasServiceEndpointInterface()) {
                existing.setServiceEndpointInterface(runtimePortInfo.getServiceEndpointInterface());
            }
            if (!existing.hasWsdlPort()) {
                existing.setWsdlPort(runtimePortInfo.getWsdlPort());
            }
            if (!existing.hasWsmConfig() && runtimePortInfo.hasWsmConfig()) {
                existing.setWsmConfig(runtimePortInfo.getWsmConfig());
            }
            this.addProperties(existing, runtimePortInfo);
        }
    }

    private ServiceRefPortInfo getMatchingPortInfo(ServiceRefPortInfo runtimePortInfo) {
        ServiceRefPortInfo existing = null;
        if (runtimePortInfo.hasServiceEndpointInterface()) {
            existing = this.getPortInfoBySEI(runtimePortInfo.getServiceEndpointInterface());
        }
        if (existing == null && runtimePortInfo.hasWsdlPort()) {
            existing = this.getPortInfoByPort(runtimePortInfo.getWsdlPort());
        }
        return existing;
    }

    private void addDefaultProperties(ServiceRefPortInfo runtimePortInfo) {
        if (!runtimePortInfo.hasServiceEndpointInterface() && !runtimePortInfo.hasWsdlPort()) {
            Iterator pIter = this.portsInfo.iterator();
            while (pIter.hasNext()) {
                ServiceRefPortInfo existing = (ServiceRefPortInfo)pIter.next();
                this.addProperties(existing, runtimePortInfo);
            }
        }
    }

    private void addProperties(ServiceRefPortInfo existing, ServiceRefPortInfo runtimePortInfo) {
        Map.Entry next;
        Iterator iter = runtimePortInfo.getStubProperties().iterator();
        while (iter.hasNext()) {
            next = (Map.Entry)iter.next();
            existing.addStubProperty(next);
        }
        iter = runtimePortInfo.getCallProperties().iterator();
        while (iter.hasNext()) {
            next = (Map.Entry)iter.next();
            existing.addCallProperty(next);
        }
    }

    public ServiceRefPortInfo getPortInfo(String serviceEndpointInterface) {
        return this.getPortInfoBySEI(serviceEndpointInterface);
    }

    public ServiceRefPortInfo getPortInfoBySEI(String serviceEndpointInterface) {
        Iterator iter = this.portsInfo.iterator();
        while (iter.hasNext()) {
            ServiceRefPortInfo next = (ServiceRefPortInfo)iter.next();
            if (!serviceEndpointInterface.equals(next.getServiceEndpointInterface())) continue;
            return next;
        }
        return null;
    }

    public ServiceRefPortInfo getPortInfoByPort(QName wsdlPort) {
        Iterator iter = this.portsInfo.iterator();
        while (iter.hasNext()) {
            ServiceRefPortInfo next = (ServiceRefPortInfo)iter.next();
            if (!next.hasWsdlPort() || !wsdlPort.equals(next.getWsdlPort())) continue;
            return next;
        }
        return null;
    }

    public void removeHandlerByName(String handlerName) {
        Iterator iter = this.handlerChain.iterator();
        while (iter.hasNext()) {
            WebServiceHandler next = (WebServiceHandler)iter.next();
            if (!next.getHandlerName().equals(handlerName)) continue;
            iter.remove();
            break;
        }
    }

    public boolean hasHandlers() {
        if (this.handlerChain != null) {
            return this.handlerChain.size() > 0;
        }
        return false;
    }

    public LinkedList getHandlerChain() {
        return this.handlerChain;
    }

    public Set getCallProperties() {
        return this.callProperties;
    }

    private Map.Entry getCallPropertyByName(String name) {
        Map.Entry prop = null;
        Iterator iter = this.callProperties.iterator();
        while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            if (!next.getKey().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    private void addCallProperty(Map.Entry property) {
        Map.Entry prop = this.getCallPropertyByName((String)property.getKey());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.callProperties.add(property);
        }
    }

    public Set getStubProperties() {
        return this.stubProperties;
    }

    private Map.Entry getStubPropertyByName(String name) {
        Map.Entry prop = null;
        Iterator iter = this.stubProperties.iterator();
        while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            if (!next.getKey().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    private void addStubProperty(Map.Entry property) {
        Map.Entry prop = this.getStubPropertyByName((String)property.getKey());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.stubProperties.add(property);
        }
    }

    public boolean hasServiceImplClassName() {
        return this.serviceImplClassName != null;
    }

    public void setServiceImplClassName(String className) {
        this.serviceImplClassName = className;
    }

    public String getServiceImplClassName() {
        return this.serviceImplClassName;
    }

    public void setWsdlOverrideLastModified(String time) {
        if (time != null) {
            this.wsdlOverrideLastModified = Long.parseLong(time);
        }
    }

    public String getWsdlOverrideLastModifide() {
        return new Long(this.wsdlOverrideLastModified).toString();
    }

    public boolean hasWsdlOverride() {
        return this.wsdlOverride != null;
    }

    public URL getWsdlOverride() {
        return this.wsdlOverride;
    }

    public boolean isWsdlOverrideAFile() {
        return this.wsdlOverride.getProtocol().equals("file");
    }

    public int compareTo(Object object) {
        if (object instanceof ServiceReferenceDescriptor) {
            ServiceReferenceDescriptor thatReference = (ServiceReferenceDescriptor)object;
            return thatReference.getName().equals(this.getName()) ? 1 : -1;
        }
        return -1;
    }

    private QName getQname(Node node) {
        QName ret = null;
        String value = XMLUtils.getStringValue(node);
        if (value.length() != 0) {
            String ns;
            String localPart = value;
            if (value.indexOf(":") != -1) {
                ns = value.substring(0, value.indexOf(":"));
                localPart = value.substring(value.indexOf(":") + 1);
            } else {
                ns = "";
            }
            if (node instanceof XMLNode) {
                ret = new QName(((XMLElement)node).resolveNamespacePrefix(ns), localPart);
            } else {
                this.parseNodeAttributes(node);
                ret = new QName(this.getXmlNamespace(ns), localPart);
            }
        }
        return ret;
    }

    private void parseNodeAttributes(Node node) {
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String value = item.getNodeValue();
                if (name.startsWith("xmlns:")) {
                    name = name.substring(name.indexOf(":") + 1);
                    this.setXmlNamespace(name, value);
                    continue;
                }
                if (!name.startsWith("xmlns")) continue;
                name = "";
                this.setXmlNamespace(name, value);
            }
        }
    }

    public void addInjectionTarget(InjectionTarget injectionTarget) {
        WSInjectionAdapter injectionAdapter = new WSInjectionAdapter(injectionTarget);
        super.addInjectionTarget(injectionAdapter);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n[debug]Service Reference");
        sb.append("\n[debug]  Name                     : " + this.getName());
        sb.append("\n[debug]  Service Interface        : " + this.serviceInterface);
        sb.append("\n[debug]  Generated implementation : " + this.serviceImplClassName);
        Iterator itr = this.stubProperties.iterator();
        while (itr.hasNext()) {
            Map.Entry stubs = (Map.Entry)itr.next();
            sb.append("\n[debug]  Stub Property : Name = " + stubs.getKey() + " : Value = " + stubs.getValue());
        }
        itr = this.callProperties.iterator();
        while (itr.hasNext()) {
            Map.Entry calls = (Map.Entry)itr.next();
            sb.append("\n[debug]  Call Property : Name = " + calls.getKey() + " : Value = " + calls.getValue());
        }
        itr = this.portsInfo.iterator();
        while (itr.hasNext()) {
            ServiceRefPortInfo aPortInfo = (ServiceRefPortInfo)itr.next();
            sb.append("\n[debug]------");
            sb.append("\n[debug]  Port Info : " + aPortInfo.toString());
        }
        if (this.hasHandlers()) {
            Iterator handlers = this.getHandlerChain().iterator();
            sb.append("\n[debug]   Handlers :");
            while (handlers.hasNext()) {
                sb.append(handlers.next().toString());
                sb.append("\n[debug]\t----- \n");
            }
        }
        return sb.toString();
    }

    private void setXmlNamespace(String name, String value) {
        if (this.xmlNamespace == null) {
            this.xmlNamespace = new HashMap();
        }
        this.xmlNamespace.put(name, value);
    }

    private String getXmlNamespace(String name) {
        if (this.xmlNamespace == null) {
            return "";
        }
        return (String)this.xmlNamespace.get(name);
    }

    public boolean mappingFileExists(String mfName, ClassLoader cl) {
        return cl.getResource(mfName) != null;
    }

    static {
        String wsDebug = System.getProperty("ws.debug", "false");
        if (Boolean.valueOf(wsDebug).booleanValue()) {
            s_logger.setLevel(Level.FINE);
        }
    }

    public class WSInjectionAdapter
    extends InjectionTarget {
        private InjectionTarget adaptee;

        public WSInjectionAdapter(InjectionTarget target) {
            super(target.getTargetClass(), target.getTargetName(), target.getResourceType());
            this.adaptee = target;
        }

        public void initialize(Class baseClass) throws InstantiationException {
            this.adaptee.initialize(baseClass);
        }

        public void inject(Object target, Object value) throws Exception {
            if (this.adaptee.getResourceType().equals((class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceReferenceDescriptor.class$(ServiceReferenceDescriptor.DEFAULT_SERVICE_INTERFACE)) : class$javax$xml$rpc$Service).getName())) {
                this.adaptee.inject(target, value);
            } else {
                ServiceRefInjectionHelper ih = (ServiceRefInjectionHelper)value;
                this.adaptee.inject(target, ih.getServicePort());
            }
        }
    }
}

