/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.security;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.j2ee.security.PolicyInfo;
import oracle.j2ee.security.PolicyParser;

public class PolicyFile {
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};

    private static void addPermissions(PermissionCollection pc, PolicyParser.GrantEntry ge) throws InstantiationException {
        Enumeration enum5 = ge.permissionElements();
        while (enum5.hasMoreElements()) {
            PolicyParser.PermissionEntry pe = (PolicyParser.PermissionEntry)enum5.nextElement();
            try {
                Permission p = PolicyFile.getInstance(pe.permission, pe.name, pe.action);
                pc.add(p);
            }
            catch (Exception e) {
                if (PolicyParser.DEBUG) {
                    e.printStackTrace();
                }
                throw new InstantiationException("Got " + e.getClass().getName() + " while creating an Permission object for permission: " + pe.permission + ", target name: " + pe.name + ", action: " + pe.action + ". Error message is " + e.getMessage());
            }
        }
    }

    public static PermissionCollection parseGrantEntries(String grantString) throws InstantiationException {
        if (PolicyParser.DEBUG) {
            System.out.println("PolicyFile.parseGrantEntries input grantString is " + grantString);
        }
        PolicyParser pp = new PolicyParser(true);
        StringReader srdr = new StringReader(grantString);
        try {
            pp.read(srdr);
        }
        catch (Exception e) {
            if (PolicyParser.DEBUG) {
                e.printStackTrace();
            }
            throw new InstantiationException("Got " + e.getClass().getName() + " while parsing permission string: '" + grantString + "'. Error message is " + e.getMessage());
        }
        finally {
            srdr.close();
        }
        Permissions pc = new Permissions();
        Enumeration e = pp.grantElements();
        while (e.hasMoreElements()) {
            PolicyParser.GrantEntry ge = (PolicyParser.GrantEntry)e.nextElement();
            PolicyFile.addPermissions(pc, ge);
        }
        if (PolicyParser.DEBUG) {
            System.out.println("PolicyFile.parseGrantEntries output PermissionCollection is " + pc);
        }
        return pc;
    }

    private static final Permission getInstance(String type, String name, String actions) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> pc = Class.forName(type);
        if (name == null && actions == null) {
            try {
                Constructor<?> c = pc.getConstructor(PARAMS0);
                return (Permission)c.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException ne) {
                try {
                    Constructor<?> c = pc.getConstructor(PARAMS1);
                    return (Permission)c.newInstance(name);
                }
                catch (NoSuchMethodException ne1) {
                    Constructor<?> c = pc.getConstructor(PARAMS2);
                    return (Permission)c.newInstance(name, actions);
                }
            }
        }
        if (name != null && actions == null) {
            try {
                Constructor<?> c = pc.getConstructor(PARAMS1);
                return (Permission)c.newInstance(name);
            }
            catch (NoSuchMethodException ne) {
                Constructor<?> c = pc.getConstructor(PARAMS2);
                return (Permission)c.newInstance(name, actions);
            }
        }
        Constructor<?> c = pc.getConstructor(PARAMS2);
        return (Permission)c.newInstance(name, actions);
    }

    Certificate[] getCertificates(KeyStore keyStore, String aliases, PolicyInfo newInfo) {
        Vector<Certificate> vcerts = null;
        StringTokenizer st = new StringTokenizer(aliases, ",");
        int n = 0;
        while (st.hasMoreTokens()) {
            String alias = st.nextToken().trim();
            ++n;
            Certificate cert = null;
            cert = (Certificate)newInfo.aliasMapping.get(alias);
            if (cert == null && keyStore != null) {
                try {
                    cert = keyStore.getCertificate(alias);
                }
                catch (KeyStoreException kse) {
                    // empty catch block
                }
                if (cert != null) {
                    newInfo.aliasMapping.put(alias, cert);
                    newInfo.aliasMapping.put(cert, alias);
                }
            }
            if (cert == null) continue;
            if (vcerts == null) {
                vcerts = new Vector<Certificate>();
            }
            vcerts.addElement(cert);
        }
        if (vcerts != null && n == vcerts.size()) {
            Object[] certs = new Certificate[vcerts.size()];
            vcerts.copyInto(certs);
            return certs;
        }
        return null;
    }
}

