/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.jndi.client.java;

import com.evermind.server.ApplicationClientInitialContextFactory;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import oracle.j2ee.rmi.RMIInitialContextFactory;

public class javaURLContextFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        String initialContextFactory = (String)environment.get("java.naming.factory.initial");
        if (initialContextFactory == null || !javaURLContextFactory.isSupportedContextFactoryType(initialContextFactory)) {
            return null;
        }
        if (obj == null) {
            if (javaURLContextFactory.isApplicationClientInitialContextFactory(initialContextFactory)) {
                return oracle.j2ee.naming.ApplicationClientInitialContextFactory.getThreadLocalContext();
            }
            if (javaURLContextFactory.isRmiClientInitialContextFactory(initialContextFactory)) {
                return RMIInitialContextFactory.getThreadLocalContext();
            }
        } else {
            Context clientContext = null;
            if (javaURLContextFactory.isApplicationClientInitialContextFactory(initialContextFactory)) {
                clientContext = oracle.j2ee.naming.ApplicationClientInitialContextFactory.getThreadLocalContext();
            } else if (javaURLContextFactory.isRmiClientInitialContextFactory(initialContextFactory)) {
                clientContext = RMIInitialContextFactory.getThreadLocalContext();
            }
            if (clientContext != null) {
                return javaURLContextFactory.lookupBinding(clientContext, obj);
            }
        }
        return null;
    }

    private static Object lookupBinding(Context context, Object obj) throws NamingException {
        if (obj instanceof String) {
            String lookupName = (String)obj;
            if (context == null) {
                throw new NamingException("Client context not set on current thread");
            }
            return context.lookup(lookupName);
        }
        return null;
    }

    private static boolean isSupportedContextFactoryType(String initialContextFactory) {
        return javaURLContextFactory.isApplicationClientInitialContextFactory(initialContextFactory) || javaURLContextFactory.isRmiClientInitialContextFactory(initialContextFactory);
    }

    private static boolean isApplicationClientInitialContextFactory(String initialContextFactory) {
        return initialContextFactory.equals(oracle.j2ee.naming.ApplicationClientInitialContextFactory.class.getName()) || initialContextFactory.equals(ApplicationClientInitialContextFactory.class.getName());
    }

    private static boolean isRmiClientInitialContextFactory(String initialContextFactory) {
        return initialContextFactory.equals(RMIInitialContextFactory.class.getName()) || initialContextFactory.equals(com.evermind.server.rmi.RMIInitialContextFactory.class.getName());
    }
}

