/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.corba.iiop;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.corba.iiop.IIOPMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class IIOPMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.corba.iiop", IIOPMessageBundle.class.getName());

    public static void severeUnableToGetOrb(Throwable t) {
        m_logger.log(Level.SEVERE, "J2EE IIOP-00001", t);
    }

    public static void severeUnableToActivatePOA(Throwable t) {
        m_logger.log(Level.SEVERE, "J2EE IIOP-00002", t);
    }

    public static void severeUnableToGetRootPOA(Throwable t) {
        m_logger.log(Level.SEVERE, "J2EE IIOP-00003", t);
    }

    public static void finerThrowableNoMsg(Throwable t) {
        if (IIOPMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE IIOP-09002", t);
        }
    }

    public static void warningMsg(String message) {
        if (IIOPMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE IIOP-09003", new Object[]{message});
        }
    }

    static Logger getLogger() {
        return m_logger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void finestMsg(String s) {
        if (IIOPMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE IIOP-09004", new Object[]{s});
        }
    }

    public static void finerThrowableMsg(String msg, Throwable t) {
        if (IIOPMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE IIOP-09001", new Object[]{msg, t});
        }
    }

    public static void warningOracleSecurityProviderMissing(String oracleSecurityProvider, Throwable t) {
        if (IIOPMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE IIOP-08001", new Object[]{oracleSecurityProvider, t});
        }
    }
}

