/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ThreadState;
import com.evermind.server.WorkManagerThreadPoolConfig;
import com.evermind.server.connector.ApplicationConnectionManager;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import oracle.as.j2ee.transaction.SubordinateTransactionManager;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.logging.JCAWorkMessages;
import oracle.j2ee.connector.work.ExecutionContextManager;
import oracle.j2ee.connector.work.TimerWrapper;
import oracle.j2ee.connector.work.WorkListenerWrapper;
import oracle.j2ee.connector.work.WorkPooledExecutor;
import oracle.j2ee.connector.work.WorkRunner;
import oracle.j2ee.connector.work.WorkWrapper;
import oracle.oc4j.admin.config.ApplicationServerConfig;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.ThreadPoolCallBackIf;
import oracle.oc4j.admin.management.mbeans.JCAThreadPool;

public class WorkManagerImpl
implements WorkManager,
ThreadPoolCallBackIf {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    public static final int DEFAULT_MIN_THREADS = 1;
    public static final int DEFAULT_MAX_THREADS = 1024;
    public static final int DEFAULT_QUEUE = 0;
    public static final long DEFAULT_KEEP_ALIVE = 600000L;
    private WorkPooledExecutor m_executor;
    private WorkListener m_emptyListener;
    private WorkRunner m_workRunner = null;
    private static boolean m_debug = false;
    private static NounIntf c_noun = null;
    private static EventIntf c_workRejectedEvent;
    private static PhaseEventIntf c_workStartDurationEvent;
    private static int m_poolId;
    private String m_poolThreadName = null;
    private ApplicationServerConfig m_config = null;
    private WorkManagerThreadPoolConfig m_threadPoolConfig = null;

    public WorkManagerImpl(ApplicationServerConfig config, SubordinateTransactionManager tm, XATerminator xaTerminator) {
        this.m_config = config;
        if (this.m_config != null) {
            this.m_threadPoolConfig = this.m_config.getWorkManagerThreadPoolConfig();
        }
        this.m_poolThreadName = "jca";
        if (this.m_threadPoolConfig.getMaxPoolSize() < this.m_threadPoolConfig.getMinPoolSize() || this.m_threadPoolConfig.getMaxPoolSize() <= 0) {
            JCAWorkMessages.warningInvalidParmWMPoolEntries();
            this.m_threadPoolConfig.setMaxPoolSize(1024);
            this.persistConfigChange();
        }
        if (this.m_threadPoolConfig.getQueueSize() < 0) {
            JCAWorkMessages.warningInvalidParmWMPoolEntries();
            this.m_threadPoolConfig.setQueueSize(0);
            this.persistConfigChange();
        }
        if (this.m_threadPoolConfig.getCount() > 1) {
            JCAWorkMessages.warningMultipleWMPoolEntries();
            this.persistConfigChange();
        }
        this.m_executor = this.m_threadPoolConfig.getQueueSize() == 0 ? new WorkPooledExecutor(this.m_threadPoolConfig.getMinPoolSize(), this.m_threadPoolConfig.getMaxPoolSize(), this.m_threadPoolConfig.getKeepAliveTime()) : new WorkPooledExecutor(this.m_threadPoolConfig.getMinPoolSize(), this.m_threadPoolConfig.getMaxPoolSize(), this.m_threadPoolConfig.getQueueSize(), this.m_threadPoolConfig.getKeepAliveTime());
        ExecutionContextManager.initialize(tm, xaTerminator);
        this.m_emptyListener = new WorkAdapter();
        this.createWorkRunner();
        this.setDebug(this.m_threadPoolConfig.isPoolDebug());
        this.registerMBean();
    }

    public void doWork(Work work) throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:doWork()");
        }
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:doWork() work = " + work + " startTimeout = " + startTimeout + " context = " + context + " listener = " + listener);
        }
        if (this.isApplicationServerThread()) {
            this.doWorkFromServerThread(work, context, listener, startTimeout);
        } else {
            this.doWorkFromNonServerThread(work, context, listener, startTimeout);
        }
    }

    public long startWork(Work work) throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:startWork work = " + work);
        }
        return this.startWork(work, Long.MAX_VALUE, null, this.m_emptyListener);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:startWork() work = " + work + " startTimeout = " + startTimeout + " context = " + context + " listener = " + listener);
        }
        WorkWrapper workWrapper = this.createWorkWrapper(listener, work, startTimeout, context);
        this.m_executor.submitWork(workWrapper, this.validStartTimeout(startTimeout));
        return workWrapper.blockUntilWorkStarted();
    }

    public void scheduleWork(Work work) throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:scheduleWork()");
        }
        this.scheduleWork(work, Long.MAX_VALUE, null, this.m_emptyListener);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:scheduleWork() work = " + work + " startTimeout = " + startTimeout + " context = " + context + " listener = " + listener);
        }
        WorkWrapper workWrapper = this.createWorkWrapper(listener, work, startTimeout, context);
        this.m_executor.submitWork(workWrapper, this.validStartTimeout(startTimeout));
    }

    public Timer getTimer() throws UnavailableException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:getTimer");
        }
        this.m_executor.reserveThread();
        return new TimerWrapper(this);
    }

    private void doWorkFromNonServerThread(Work work, ExecutionContext context, WorkListener listener, long timeout) throws WorkException {
        WorkWrapper workWrapper = this.createWorkWrapper(listener, work, timeout, context);
        this.m_executor.submitWork(workWrapper, this.validStartTimeout(timeout));
        workWrapper.blockUntilWorkCompleted();
    }

    private void doWorkFromServerThread(Work work, ExecutionContext context, WorkListener listener, long timeout) throws WorkException {
        if (listener == null && context == null) {
            this.doWorkInline(work);
        } else {
            WorkWrapper workWrapper = this.createWorkWrapper(listener, work, timeout, context);
            workWrapper.fireWorkAccepted();
            workWrapper.doWork();
        }
    }

    private WorkWrapper createWorkWrapper(WorkListener listener, Work work, long timeout, ExecutionContext context) throws WorkException {
        if (listener == null) {
            listener = this.m_emptyListener;
        }
        WorkListenerWrapper listenerWrapper = new WorkListenerWrapper(listener);
        WorkWrapper workWrapper = new WorkWrapper(work, System.currentTimeMillis(), timeout, listenerWrapper, context, ThreadState.getCurrentState().contextContainer, this.m_workRunner);
        this.failIfTxCurrentlyExecuting(workWrapper);
        return workWrapper;
    }

    private void doWorkInline(Work work) throws WorkCompletedException {
        try {
            work.run();
        }
        catch (Exception t) {
            throw new WorkCompletedException((Throwable)t);
        }
    }

    private boolean isApplicationServerThread() {
        return Thread.currentThread() instanceof ApplicationServerThread;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nWorkManagerImpl: ");
        sb.append("\n\tminPoolSize is " + this.m_executor.getMinimumPoolSize());
        sb.append("\n\tmaxPoolSize is " + this.m_executor.getMaximumPoolSize());
        sb.append("\n\tkeepAliveTime is " + this.m_executor.getKeepAliveTime());
        return sb.toString();
    }

    public void setDebug(boolean enable) {
        boolean persist = this.m_threadPoolConfig != null && this.m_threadPoolConfig.isPoolDebug() != enable;
        this.setDebugFromMBean(enable);
        if (persist) {
            this.persistConfigChange();
        }
    }

    public void setDebugFromMBean(boolean enable) {
        m_debug = enable;
        if (this.m_threadPoolConfig != null && this.m_threadPoolConfig.isPoolDebug() != enable) {
            this.m_threadPoolConfig.setPoolDebug(enable);
        }
    }

    public static void log(String message) {
        if (m_debug) {
            System.out.println(message);
        }
    }

    public void destroy() {
        this.m_executor.shutdownNow();
        this.unregisterMBean();
    }

    void releaseThread() {
        this.m_executor.releaseThread();
    }

    int getReservedThreadCount() {
        return this.m_executor.getReservedThreadCount();
    }

    public int getPoolSize() {
        return this.m_executor.getPoolSize();
    }

    public int getQueueSize() {
        return this.m_executor.getQueueSize();
    }

    int getWorkerThreadsWaitingForTask() {
        return this.m_executor.getWorkerThreadsWaitingForTask();
    }

    private synchronized void failIfTxCurrentlyExecuting(WorkWrapper workWrapper) throws WorkCompletedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:failIfTxCurrentlyExecuting begin");
        }
        if (workWrapper.getExContext() == null) {
            return;
        }
        if (workWrapper.getExContext().isActive()) {
            WorkCompletedException ex = new WorkCompletedException();
            ex.setErrorCode("2");
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.fine("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkManagerImpl:failIfTxCurrentlyExecuting rejecting work");
            }
            workWrapper.fireWorkRejected((WorkException)ex);
            throw ex;
        }
    }

    private long validStartTimeout(long timeout) {
        if (timeout < 0L) {
            JCAWorkMessages.warningInvalidWMStartTimeout();
        }
        return timeout > 0L ? timeout : 0L;
    }

    private void createWorkRunner() {
        this.m_workRunner = new WorkRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean runWork(WorkWrapper workWrapper) {
                WorkPooledExecutor workPooledExecutor = WorkManagerImpl.this.m_executor;
                synchronized (workPooledExecutor) {
                    return WorkManagerImpl.this.m_executor.runWorkIfPoolNotFull(workWrapper);
                }
            }
        };
    }

    static NounIntf getNoun() {
        NounFactoryIntf nounFactory;
        if (c_noun == null && ApplicationServer.DMS_GATE && (nounFactory = ApplicationServer.nounFactory()) != null) {
            c_noun = nounFactory.create(Application.getJ2eeNoun(), "Work Management Pool", "oc4j_workManagementPool");
        }
        return c_noun;
    }

    static EventIntf getWorkRejectedEvent() {
        NounIntf wmNoun;
        if (c_workRejectedEvent == null && ApplicationServer.DMS_GATE && (wmNoun = WorkManagerImpl.getNoun()) != null) {
            c_workRejectedEvent = ApplicationServer.eventFactory().create(wmNoun, "workRejected", "number of rejected work submissions");
        }
        return c_workRejectedEvent;
    }

    static PhaseEventIntf getWorkStartDurationEvent() {
        NounIntf wmNoun;
        if (c_workStartDurationEvent == null && ApplicationServer.DMS_GATE && (wmNoun = WorkManagerImpl.getNoun()) != null) {
            c_workStartDurationEvent = ApplicationServer.phaseEventFactory().create(wmNoun, "workStartDuration", "Duration between work accepted and work started events");
            c_workStartDurationEvent.deriveMetric(46);
        }
        return c_workStartDurationEvent;
    }

    private void registerMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        JCAThreadPool mbean = new JCAThreadPool(this, this.m_poolThreadName);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void unregisterMBean() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            JCAThreadPool mbean = new JCAThreadPool(this, this.m_poolThreadName);
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void persistConfigChange() {
        if (this.m_config != null) {
            try {
                this.m_config.store();
            }
            catch (ClassCastException e) {
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e);
            }
        }
    }

    public String[] getExecutingThreadNames() {
        return this.m_executor.getExecutingThreadNames();
    }

    public int getMinPoolSize() {
        return this.m_executor.getMinimumPoolSize();
    }

    public int getMaxPoolSize() {
        return this.m_executor.getMaximumPoolSize();
    }

    public long getKeepAliveTime() {
        return this.m_executor.getKeepAliveTime();
    }

    public boolean isDebug() {
        return m_debug;
    }

    public String getName() {
        return this.m_poolThreadName;
    }

    public int getQueueCapacity() {
        return this.m_executor.getQueueCapacity();
    }

    public void setQueueCapacityFromMBean(int queueCapacity) {
    }

    public void setMinPoolSize(int size) {
        this.setMinPoolSizeFromMBean(size);
        this.persistConfigChange();
    }

    public void setMinPoolSizeFromMBean(int size) {
        this.m_executor.setMinimumPoolSize(size);
        if (this.m_threadPoolConfig != null) {
            this.m_threadPoolConfig.setMinPoolSize(size);
        }
    }

    public void setMaxPoolSize(int size) {
        this.setMaxPoolSizeFromMBean(size);
        this.persistConfigChange();
    }

    public void setMaxPoolSizeFromMBean(int size) {
        this.m_executor.setMaximumPoolSize(size);
        if (this.m_threadPoolConfig != null) {
            this.m_threadPoolConfig.setMaxPoolSize(size);
        }
    }

    public void setKeepAliveTime(long timeInMs) {
        this.setKeepAliveTimeFromMBean(timeInMs);
        this.persistConfigChange();
    }

    public void setKeepAliveTimeFromMBean(long timeInMs) {
        this.m_executor.setKeepAliveTime(timeInMs);
        if (this.m_threadPoolConfig != null) {
            this.m_threadPoolConfig.setKeepAliveTime(timeInMs);
        }
    }

    public Set getConnectedUsers() {
        return this.m_executor.getConnectedUsers();
    }

    public Map getApplicationsInUse() {
        return this.m_executor.getApplicationsInUse();
    }

    public String getThreadPoolName() {
        return this.m_poolThreadName;
    }

    static {
        m_poolId = 0;
    }
}

