/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.deployment.PrincipalHolder;
import com.evermind.server.connector.deployment.PrincipalMappingEntries;
import java.security.Principal;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import oracle.j2ee.connector.AbstractPrincipalMapping;
import oracle.j2ee.connector.logging.JCATraceLogger;

public class PrincipalMappingImpl
extends AbstractPrincipalMapping {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    PrincipalMappingEntries m_mapping;

    public void init(Properties prop) {
        if (prop != null) {
            String config = prop.getProperty("xmlconfig");
            try {
                this.m_mapping = new PrincipalMappingEntries(config);
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    public Subject mapping(Subject initiatingSubject) {
        String user = null;
        String resUser = null;
        String resPassword = null;
        PrincipalHolder entry = null;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "PrincipalMappingImpl:mapping() begin. initiatingSubject = " + initiatingSubject);
        }
        if (!this.isBasicPasswordSupported()) {
            return null;
        }
        Principal principal = this.getPrincipal(initiatingSubject);
        if (principal != null) {
            user = principal.getName();
        }
        if (this.m_mapping != null) {
            entry = this.m_mapping.getResourceEntry(user, principal);
        }
        if (entry == null) {
            return null;
        }
        resUser = entry.getUser();
        resPassword = entry.getPassword();
        char[] resPasswordArray = null;
        resPasswordArray = resPassword != null ? resPassword.toCharArray() : new char[]{};
        PasswordCredential cred = new PasswordCredential(resUser, resPasswordArray);
        cred.setManagedConnectionFactory(this.getManagedConnectionFactory());
        initiatingSubject.getPrivateCredentials().add(cred);
        return initiatingSubject;
    }
}

