/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.connector.ConnectionPool;
import oracle.j2ee.connector.ConnectionPoolConnFactory;
import oracle.j2ee.connector.ConnectionPoolConnFactoryContext;
import oracle.j2ee.connector.ConnectorMessages;
import oracle.j2ee.connector.logging.JCACommonMessages;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolMetricCallBackIf;

public class ConnectionPoolImpl
implements ConnectionPool,
JCAConnectionPoolMetricCallBackIf {
    public static int DEFAULT_INACTIVITY_TIMEOUT = 0;
    public static int DEFAULT_WAIT_TIMEOUT = 0;
    public static int DEFAULT_MAX_CONNECTIONS = Integer.MAX_VALUE;
    public static int DEFAULT_MIN_CONNECTIONS = 0;
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    private ConnectionPoolConnFactory m_preCreateCf;
    private ConnectionPoolConnFactoryContext m_preCreateCfContext;
    private Set m_connFactories = new HashSet();
    private PrintWriter m_logWriter;
    private String m_poolName;
    private static List c_schemes = new ArrayList(4);
    private static List c_timeoutChecks;
    private PoolingScheme m_scheme = null;
    private int m_minConnections = DEFAULT_MIN_CONNECTIONS;
    private int m_maxConnections = DEFAULT_MAX_CONNECTIONS;
    private int m_waitTimeout = DEFAULT_WAIT_TIMEOUT;
    private int m_inactivityTimeout = DEFAULT_INACTIVITY_TIMEOUT;
    private int m_initialCapacity = 0;
    private String m_inactivityTimeoutCheck = "never";
    private Set m_inUseSet;
    private FreePool m_freePool;
    private long m_lastInactivePruneTime = System.currentTimeMillis();
    private NounIntf m_noun;
    private EventIntf m_closeCountEvent;
    private EventIntf m_createCountEvent;
    private StateIntf m_freePoolSizeState;
    private StateIntf m_poolSizeState;
    private PhaseEventIntf m_waitingThreadCountEvent;
    private EventIntf m_expiredCountEvent;
    private EventIntf m_invalidCountEvent;
    private EventIntf m_requestTimeoutCountEvent;
    private EventIntf m_errorCountEvent;
    private PhaseEventIntf m_waitTimeEvent;
    private PhaseEventIntf m_useTimeEvent;
    private StateIntf m_minPoolSizeState;
    private StateIntf m_maxPoolSizeState;
    private StateIntf m_schemeState;
    private StateIntf m_waitTimeoutState;
    private StateIntf m_inactivityTimeoutState;
    private StateIntf m_inactivityTimeoutCheckState;
    private StateIntf m_initialCapacityState;
    private Object[] m_poolLock = new Object[0];
    private Object[] m_removeInvalidConnectionsLock = new Object[0];

    public void init(ConnectionPoolConnFactory preCreateCf, ConnectionPoolConnFactoryContext preCreateCfContext, Properties prop, boolean reAuthSupported, PrintWriter logWriter, String poolName, NounIntf parentNoun) throws ApplicationServerInternalException {
        this.m_logWriter = logWriter;
        this.m_poolName = poolName;
        this.m_preCreateCf = preCreateCf;
        this.m_preCreateCfContext = preCreateCfContext;
        if (this.m_preCreateCf != null) {
            this.m_connFactories.add(this.m_preCreateCf);
        }
        if (prop == null) {
            this.m_scheme = new NonePoolingScheme();
            this.initDMS(parentNoun);
        } else {
            this.initProperties(prop);
            this.initDMS(parentNoun);
            this.createConnections(this.m_initialCapacity, this.m_preCreateCf, this.m_preCreateCfContext);
        }
    }

    public void registerConnectionFactory(ConnectionPoolConnFactory factory) {
        this.m_connFactories.add(factory);
    }

    public boolean unregisterConnectionFactory(ConnectionPoolConnFactory factory) {
        return this.m_connFactories.remove(factory);
    }

    private void initProperties(Properties prop) throws ApplicationServerInternalException {
        this.setMinConnections(this.getIntPropertyValue(prop, "minConnections", 0, false));
        this.setMaxConnections(this.getIntPropertyValue(prop, "maxConnections", Integer.MAX_VALUE, false));
        this.setInitialCapacity(this.getIntPropertyValue(prop, "initial-capacity", 0, false));
        this.setWaitTimeout(this.getIntPropertyValue(prop, "waitTimeout", 0, false));
        this.setInactivityTimeout(this.getIntPropertyValue(prop, "inactivity-timeout", 0, false));
        String temp = prop.getProperty("inactivity-timeout-check");
        if (temp == null || temp.trim().length() == 0) {
            if (this.m_inactivityTimeout != 0) {
                JCACommonMessages.infoMessage("Missing \"inactivity-timeout-check\" value. Default value \"periodic\" is assumed.");
                this.m_inactivityTimeoutCheck = "periodic";
            }
        } else {
            this.setInactivityTimeoutCheck(temp);
        }
        if ((temp = prop.getProperty("scheme")) == null || temp.trim().length() == 0) {
            temp = "dynamic";
            JCACommonMessages.infoMessage("value for \"scheme\" property is not specified \"dynamic\" scheme is assumed.");
        }
        this.setScheme(temp);
    }

    private int getIntPropertyValue(Properties prop, String propertyName, int defaultValue, boolean exceptionForNegNums) {
        int propertyValue = defaultValue;
        String temp = prop.getProperty(propertyName);
        if (temp != null) {
            try {
                propertyValue = this.parseIntValue(propertyName, temp, exceptionForNegNums);
            }
            catch (ApplicationServerInternalException e) {
                propertyValue = defaultValue;
                JCACommonMessages.infoMessage(e.getMessage() + "Default value " + defaultValue + " is used");
            }
        }
        return propertyValue;
    }

    private int parseIntValue(String propertyName, String propertyValue, boolean exceptionForNegNums) throws ApplicationServerInternalException {
        int intValue = 0;
        boolean gotException = false;
        try {
            intValue = Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            gotException = true;
        }
        if (gotException || exceptionForNegNums && intValue < 0) {
            throw new ApplicationServerInternalException("value for \"" + propertyName + "\" property: '" + propertyValue + "' is not a valid integer.");
        }
        return intValue;
    }

    private ManagedConnection createManagedConnectionFromFactory(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
        ManagedConnection mc = factory.createManagedConnection(context);
        if (ApplicationServer.DMS_GATE && this.m_createCountEvent != null) {
            this.m_createCountEvent.occurred();
        }
        return mc;
    }

    private void destroyManagedConnection(ConnectionPoolConnFactory factory, ManagedConnection mc) {
        if (ApplicationServer.DMS_GATE && this.m_closeCountEvent != null) {
            this.m_closeCountEvent.occurred();
        }
        try {
            if (factory != null) {
                factory.destroyManagedConnection(mc);
            }
        }
        catch (ResourceException e) {
            this.logResourceException(e, "Error while trying to destroy a connection");
        }
    }

    public void createInitialCapacity(ConnectionPoolConnFactory connectionFactory, ConnectionPoolConnFactoryContext connectionFactoryContext) {
        this.createConnections(this.m_initialCapacity, connectionFactory, connectionFactoryContext);
    }

    private void createConnections(int numConnections, ConnectionPoolConnFactory connectionFactory, ConnectionPoolConnFactoryContext connectionFactoryContext) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",numConnections=" + numConnections);
        }
        if (numConnections <= 0 || this.m_maxConnections == 0) {
            return;
        }
        if (connectionFactory == null || connectionFactoryContext == null) {
            return;
        }
        if (numConnections > this.m_maxConnections && this.m_maxConnections > 0) {
            numConnections = this.m_maxConnections;
        }
        for (int i = 0; i < numConnections; ++i) {
            try {
                ManagedConnection mc = this.createManagedConnectionFromFactory(connectionFactory, connectionFactoryContext);
                this.m_freePool.add(connectionFactory, mc);
                continue;
            }
            catch (ResourceException e) {
                this.logResourceException(e, "Unable to precreate a connection. Please note that OC4J is unable to precreate connections that requires JNDI lookup in the process. ");
            }
        }
        this.updatePoolSizeDMSMetrics();
    }

    public void setProperty(String propertyName, String newValue) throws ApplicationServerInternalException {
        throw new ApplicationServerInternalException("setProperty is not supported. Use the proper setter method instead.");
    }

    public PhaseEventIntf getWaitTimeEvent() {
        return this.m_waitTimeEvent;
    }

    public PhaseEventIntf getUseTimeEvent() {
        return this.m_useTimeEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheme(String newValue) throws ApplicationServerInternalException {
        if (newValue == null || newValue != null && !c_schemes.contains(newValue)) {
            throw new ApplicationServerInternalException("Inavlid scheme name \"" + newValue + "\".");
        }
        if (this.m_scheme != null && newValue.equalsIgnoreCase(this.m_scheme.getName())) {
            return;
        }
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            PoolingScheme oldScheme = this.m_scheme;
            if (newValue.equalsIgnoreCase("fixed_wait")) {
                this.m_scheme = new FixedWaitPoolingScheme();
            } else if (newValue.equalsIgnoreCase("fixed")) {
                this.m_scheme = new FixedPoolingScheme();
            } else if (newValue.equalsIgnoreCase("dynamic")) {
                this.m_scheme = new DynamicPoolingScheme();
            } else if (newValue.equalsIgnoreCase("none")) {
                this.m_scheme = new NonePoolingScheme();
            }
            if (oldScheme != null) {
                oldScheme.switchScheme();
            }
            if (ApplicationServer.DMS_GATE && this.m_schemeState != null) {
                this.m_schemeState.update((Object)(this.m_scheme == null ? "none" : this.m_scheme.getName()));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isDisabled() {
        return "none".equals(this.m_scheme.getName());
    }

    public void setInitialCapacity(int initialCapacity) throws ApplicationServerInternalException {
        if (this.m_maxConnections >= 0 && initialCapacity > this.m_maxConnections) {
            throw new ApplicationServerInternalException("The initial capacity value (" + initialCapacity + ") cannot be larger than the max connections value (" + this.m_maxConnections + ").");
        }
        this.m_initialCapacity = initialCapacity;
        if (ApplicationServer.DMS_GATE && this.m_initialCapacityState != null) {
            this.m_initialCapacityState.update(this.m_initialCapacity);
        }
    }

    public void setMinConnections(int minConnections) throws ApplicationServerInternalException {
        this.m_minConnections = ConnectionPoolImpl.getValidatedMinConnectionValue(minConnections, this.m_maxConnections);
        if (ApplicationServer.DMS_GATE && this.m_minPoolSizeState != null) {
            this.m_minPoolSizeState.update(this.m_minConnections);
        }
    }

    public static int getValidatedMinConnectionValue(int minConnections, int maxConnections) throws ApplicationServerInternalException {
        if (minConnections < 0) {
            throw new ApplicationServerInternalException("The min connections value (" + minConnections + ") must be >= 0.");
        }
        if (maxConnections >= 0 && minConnections > maxConnections) {
            throw new ApplicationServerInternalException("The min connections value (" + minConnections + ") cannot be larger than the max connections value (" + maxConnections + ").");
        }
        return minConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaxConnections(int maxConnections) throws ApplicationServerInternalException {
        this.m_maxConnections = ConnectionPoolImpl.getValidatedMaxConnectionValue(maxConnections, this.m_minConnections);
        if (ApplicationServer.DMS_GATE && this.m_maxPoolSizeState != null) {
            this.m_maxPoolSizeState.update(this.m_maxConnections);
        }
        if (this.m_scheme == null) return;
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            this.getFreePool().makeRoom(0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static int getValidatedMaxConnectionValue(int maxConnections, int minConnections) throws ApplicationServerInternalException {
        int maxConnectionsTemp;
        int n = maxConnectionsTemp = maxConnections < 0 ? Integer.MAX_VALUE : maxConnections;
        if (maxConnectionsTemp < minConnections) {
            throw new ApplicationServerInternalException("The max connections value (" + maxConnections + ") cannot be smaller than the min connections value (" + minConnections + ").");
        }
        return maxConnections;
    }

    public void setWaitTimeout(int waitTimeout) throws ApplicationServerInternalException {
        if (waitTimeout < 0) {
            throw new ApplicationServerInternalException(" The wait timeout value (" + waitTimeout + ") must be non-negative.");
        }
        this.m_waitTimeout = waitTimeout;
        if (ApplicationServer.DMS_GATE && this.m_waitTimeoutState != null) {
            this.m_waitTimeoutState.update(waitTimeout);
        }
    }

    public void setInactivityTimeout(int inactivityTimeout) throws ApplicationServerInternalException {
        if (inactivityTimeout < 0) {
            throw new ApplicationServerInternalException("The inactivity timeout value (" + inactivityTimeout + ") must be non-negative.");
        }
        if (inactivityTimeout > 0 && this.m_inactivityTimeout == 0 && this.m_inactivityTimeoutCheck == "never") {
            this.m_inactivityTimeoutCheck = "periodic";
            if (ApplicationServer.DMS_GATE && this.m_inactivityTimeoutCheckState != null) {
                this.m_inactivityTimeoutCheckState.update((Object)this.m_inactivityTimeoutCheck);
            }
        }
        this.m_inactivityTimeout = inactivityTimeout;
        if (ApplicationServer.DMS_GATE && this.m_inactivityTimeoutState != null) {
            this.m_inactivityTimeoutState.update(inactivityTimeout);
        }
    }

    public void setInactivityTimeoutCheck(String inactivityTimeoutCheck) throws ApplicationServerInternalException {
        if (inactivityTimeoutCheck == null || !c_timeoutChecks.contains(inactivityTimeoutCheck)) {
            throw new ApplicationServerInternalException("Invalid \"inactivity-timeout-check\" value: " + inactivityTimeoutCheck + ".");
        }
        this.m_inactivityTimeoutCheck = inactivityTimeoutCheck;
        if (ApplicationServer.DMS_GATE && this.m_inactivityTimeoutCheckState != null) {
            this.m_inactivityTimeoutCheckState.update((Object)inactivityTimeoutCheck);
        }
    }

    private void initDMS(NounIntf parentNoun) {
        if (parentNoun == null || !ApplicationServer.DMS_GATE) {
            return;
        }
        this.m_noun = ApplicationServer.nounFactory().create(parentNoun, this.m_poolName, "jca_connection_pool_stats");
        this.m_closeCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "closeCount", "number of ManagedConnections closed");
        this.m_createCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "createCount", "number of ManagedConnections created");
        this.m_freePoolSizeState = ApplicationServer.stateFactory().create(this.m_noun, "freePoolSize", "connections", "number of free connections in the pool", 0);
        this.m_freePoolSizeState.deriveMetric(12);
        this.m_poolSizeState = ApplicationServer.stateFactory().create(this.m_noun, "poolSize", "connections", "Size of connection pool", 0);
        this.m_poolSizeState.deriveMetric(12);
        this.m_waitingThreadCountEvent = ApplicationServer.phaseEventFactory().create(this.m_noun, "waitingThreadCount", "number of threads waiting for connection");
        this.m_waitingThreadCountEvent.deriveMetric(238);
        this.m_expiredCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "expiredCount", "number of expired connections removed from pool");
        this.m_invalidCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "invalidCount", "number of invalid connections removed from pool");
        this.m_requestTimeoutCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "requestTimeoutCount", "number of failed connection requests due to timeout");
        this.m_errorCountEvent = ApplicationServer.eventFactory().create(this.m_noun, "errorCount", "number of connection error events");
        this.m_useTimeEvent = ApplicationServer.phaseEventFactory().create(this.m_noun, "useTime", "Time spent using a connection");
        this.m_useTimeEvent.deriveMetric(46);
        this.m_waitTimeEvent = ApplicationServer.phaseEventFactory().create(this.m_noun, "waitTime", "Time spent waiting for a connection to be available");
        this.m_waitTimeEvent.deriveMetric(46);
        this.m_minPoolSizeState = ApplicationServer.stateFactory().create(this.m_noun, "minPoolSize", "connections", "configuration parameter: minimum number of connections", this.m_minConnections);
        this.m_maxPoolSizeState = ApplicationServer.stateFactory().create(this.m_noun, "maxPoolSize", "connections", "configuration parameter: maximum number of connections", this.m_maxConnections);
        this.m_schemeState = ApplicationServer.stateFactory().create(this.m_noun, "scheme", "scheme", "configuration parameter: connection pooling scheme", (Object)(this.m_scheme != null ? this.m_scheme.getName() : "none"));
        this.m_waitTimeoutState = ApplicationServer.stateFactory().create(this.m_noun, "waitTimeout", "seconds", "configuration parameter: timeout waiting for a connection in fixed_wait scheme", this.m_waitTimeout);
        this.m_inactivityTimeoutState = ApplicationServer.stateFactory().create(this.m_noun, "inactivityTimeout", "seconds", "configuration parameter: timeout for unused connections", this.m_inactivityTimeout);
        this.m_inactivityTimeoutCheckState = ApplicationServer.stateFactory().create(this.m_noun, "inactivityTimeoutCheck", "", "configuration parameter: when to check for unused connections timeout", (Object)this.m_inactivityTimeoutCheck);
        this.m_initialCapacityState = ApplicationServer.stateFactory().create(this.m_noun, "initial-capacity", "connections", "configuration parameter: number of connections to be pre-created by the pool", this.m_initialCapacity);
    }

    Set getCandidateSet() {
        if (this.m_freePool == null) {
            return Collections.EMPTY_SET;
        }
        return this.m_freePool.getCandidateSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ManagedConnection getManagedConnection(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this);
        }
        if (!this.m_inactivityTimeoutCheck.equals("piggyback") && !this.m_inactivityTimeoutCheck.equals("all") || this.m_freePool == null) return this.m_scheme.getManagedConnection(factory, context);
        boolean updatePoolMetrics = false;
        updatePoolMetrics = this.m_freePool.removeInvalidConnections(this.getConnectionPoolConnectionFactories());
        if (this.m_freePool.timeout(true)) {
            updatePoolMetrics = true;
        }
        if (!updatePoolMetrics) return this.m_scheme.getManagedConnection(factory, context);
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            this.updatePoolSizeDMSMetrics();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.m_scheme.getManagedConnection(factory, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionErrorOccurred(ManagedConnection mc) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",MC=" + mc);
        }
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            this.m_inUseSet.remove(mc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (ApplicationServer.DMS_GATE && this.m_errorCountEvent != null) {
                this.m_errorCountEvent.occurred();
            }
            return;
        }
    }

    public void connectionClosed(ConnectionPoolConnFactory factory, ManagedConnection mc, boolean discard) {
        this.m_scheme.connectionClosed(factory, mc, discard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void purgeCandidateSet() {
        if (this.m_freePool == null) return;
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            this.m_freePool.clear();
            if (this.getNumOpenConnections() < this.m_minConnections) {
                this.createConnections(this.m_minConnections - this.getNumOpenConnections(), this.m_preCreateCf, this.m_preCreateCfContext);
            }
            this.updatePoolSizeDMSMetrics();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(ManagedConnection mc) {
        if (this.m_freePool == null) return;
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            this.m_freePool.remove(mc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            if (this.m_freePool != null) {
                this.m_freePool.clear();
            }
            if (this.m_inUseSet != null) {
                this.m_inUseSet.clear();
            }
            if (this.m_noun != null) {
                this.m_noun.destroy();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (!this.m_inactivityTimeoutCheck.equals("periodic") && !this.m_inactivityTimeoutCheck.equals("all") || this.m_freePool == null) return;
        boolean updatePoolMetrics = false;
        updatePoolMetrics = this.m_freePool.timeout(true);
        long curTime = System.currentTimeMillis();
        if (this.shouldCheckForExpirations(curTime)) {
            if (this.m_freePool.removeInvalidConnections(this.getConnectionPoolConnectionFactories())) {
                updatePoolMetrics = true;
            }
            this.m_lastInactivePruneTime = curTime;
        }
        if (!updatePoolMetrics) return;
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            this.updatePoolSizeDMSMetrics();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    boolean shouldCheckForExpirations(long curTime) {
        return curTime - this.m_lastInactivePruneTime >= (long)(this.m_inactivityTimeout * 1000);
    }

    long getPurgeCutoffTime() {
        return System.currentTimeMillis() - (long)(this.m_inactivityTimeout * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPoolConnFactory[] getConnectionPoolConnectionFactories() {
        if (this.m_connFactories == null) {
            return new ConnectionPoolConnFactory[0];
        }
        ConnectionPoolConnFactory[] connFactories = null;
        Object[] objectArray = this.m_poolLock;
        synchronized (this.m_poolLock) {
            connFactories = new ConnectionPoolConnFactory[this.m_connFactories.size()];
            this.m_connFactories.toArray(connFactories);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return connFactories;
        }
    }

    public int getFreePoolSize() {
        return this.m_freePool == null ? 0 : this.m_freePool.size();
    }

    private int getNumOpenConnections() {
        return this.getFreePoolSize() + this.getInUsePoolSize();
    }

    public int getInUsePoolSize() {
        return this.m_inUseSet == null ? 0 : this.m_inUseSet.size();
    }

    FreePool getFreePool() {
        return this.m_freePool;
    }

    public String getScheme() {
        if (this.m_scheme == null) {
            return "";
        }
        return this.m_scheme.getName();
    }

    public int getInitialCapacity() {
        return this.m_initialCapacity;
    }

    public int getMinConnections() {
        return this.m_minConnections;
    }

    public int getMaxConnections() {
        return this.m_maxConnections;
    }

    public int getWaitTimeout() {
        return this.m_waitTimeout;
    }

    public int getInactivityTimeout() {
        return this.m_inactivityTimeout;
    }

    public String getInactivityTimeoutCheck() {
        return this.m_inactivityTimeoutCheck;
    }

    private void updatePoolSizeDMSMetrics() {
        if (ApplicationServer.DMS_GATE && this.m_freePoolSizeState != null) {
            this.m_freePoolSizeState.update(this.getFreePoolSize());
        }
        if (ApplicationServer.DMS_GATE && this.m_poolSizeState != null) {
            this.m_poolSizeState.update(this.getNumOpenConnections());
        }
    }

    private void logResourceException(ResourceException e, String message) {
        JCACommonMessages.severeThrowableWithMessage(message, e);
    }

    public String getPoolName() {
        return this.m_poolName;
    }

    public String getManagedConnectionFactoryClass() {
        if (this.m_preCreateCfContext != null && this.m_preCreateCfContext.getManagedConnectionFactory() != null) {
            return this.m_preCreateCfContext.getManagedConnectionFactory().getClass().getName();
        }
        return null;
    }

    public EventIntf getCloseCount() {
        return this.m_closeCountEvent;
    }

    public EventIntf getErrorCount() {
        return this.m_errorCountEvent;
    }

    public EventIntf getCreateCount() {
        return this.m_createCountEvent;
    }

    public StateIntf getFreePoolSizeState() {
        return this.m_freePoolSizeState;
    }

    public StateIntf getPoolSizeState() {
        return this.m_poolSizeState;
    }

    public PhaseEventIntf getWaitingThreadCountEvent() {
        return this.m_waitingThreadCountEvent;
    }

    static {
        c_schemes.add("dynamic");
        c_schemes.add("fixed");
        c_schemes.add("fixed_wait");
        c_schemes.add("none");
        c_timeoutChecks = new ArrayList(4);
        c_timeoutChecks.add("never");
        c_timeoutChecks.add("periodic");
        c_timeoutChecks.add("piggyback");
        c_timeoutChecks.add("all");
    }

    private class InactiveListElement {
        private long m_returnToPoolTime;
        private ManagedConnection m_mc;
        private ConnectionPoolConnFactory m_factory;

        public InactiveListElement(long returnToPoolTime, ManagedConnection mc, ConnectionPoolConnFactory factory) {
            this.m_returnToPoolTime = returnToPoolTime;
            this.m_mc = mc;
            this.m_factory = factory;
        }

        public long getReturnToPoolTime() {
            return this.m_returnToPoolTime;
        }

        public ManagedConnection getManagedConnection() {
            return this.m_mc;
        }

        public ConnectionPoolConnFactory getConnectionPoolConnFactory() {
            return this.m_factory;
        }
    }

    class FreePool {
        private Set m_candidateSet;
        private LinkedList m_inactiveList;
        private long m_nextInactivityListElementTime;
        private boolean m_isEmpty = true;

        FreePool() {
            this.init();
        }

        private void init() {
            this.m_candidateSet = new HashSet();
            this.m_inactiveList = new LinkedList();
            this.m_nextInactivityListElementTime = 0L;
            this.m_isEmpty = true;
        }

        public int size() {
            return this.m_candidateSet.size();
        }

        public boolean isEmpty() {
            return this.m_isEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ConnectionPoolConnFactory factory, ManagedConnection mc) {
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                this.m_candidateSet.add(mc);
                long currentTime = System.currentTimeMillis();
                this.m_inactiveList.add(new InactiveListElement(currentTime, mc, factory));
                if (this.m_nextInactivityListElementTime == 0L) {
                    this.m_nextInactivityListElementTime = currentTime;
                }
                this.m_isEmpty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                Iterator iter = this.m_inactiveList.iterator();
                while (iter.hasNext()) {
                    InactiveListElement element = (InactiveListElement)iter.next();
                    ConnectionPoolImpl.this.destroyManagedConnection(element.getConnectionPoolConnFactory(), element.getManagedConnection());
                }
                this.init();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ManagedConnection mc) {
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                this.m_candidateSet.remove(mc);
                ListIterator iter = this.m_inactiveList.listIterator();
                boolean found = false;
                while (iter.hasNext() && !found) {
                    InactiveListElement element = (InactiveListElement)iter.next();
                    if (element.getManagedConnection() != mc) continue;
                    iter.remove();
                    found = true;
                }
                if (ApplicationServer.DMS_GATE && ConnectionPoolImpl.this.m_freePoolSizeState != null) {
                    ConnectionPoolImpl.this.m_freePoolSizeState.update(this.m_candidateSet.size());
                }
                if (found) {
                    this.m_isEmpty = this.m_inactiveList.isEmpty();
                }
            }
        }

        public Set getCandidateSet() {
            return this.m_candidateSet;
        }

        public void makeRoom(int numSlots) {
            if (ConnectionPoolImpl.this.m_maxConnections <= 0) {
                return;
            }
            int purgeCount = ConnectionPoolImpl.this.getNumOpenConnections() - ConnectionPoolImpl.this.m_maxConnections + numSlots;
            boolean done = false;
            while (purgeCount-- > 0 && !done) {
                if (this.removeFirst() != null) continue;
                done = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeInvalidConnections(ConnectionPoolConnFactory[] connFactories) {
            boolean removed = false;
            Object[] objectArray = ConnectionPoolImpl.this.m_removeInvalidConnectionsLock;
            synchronized (objectArray) {
                Iterator iter = ConnectionPoolImpl.this.m_connFactories.iterator();
                while (iter.hasNext()) {
                    ConnectionPoolConnFactory factory = (ConnectionPoolConnFactory)iter.next();
                    if (factory == null || !this.removeInvalidConnections(factory)) continue;
                    removed = true;
                }
            }
            return removed;
        }

        private boolean removeInvalidConnections(ConnectionPoolConnFactory factory) {
            boolean removed = false;
            try {
                Set invalidManagedConnections = factory.getInvalidConnections(this.m_candidateSet);
                if (invalidManagedConnections == null) {
                    return false;
                }
                Iterator iter = invalidManagedConnections.iterator();
                while (iter.hasNext()) {
                    ManagedConnection mc = (ManagedConnection)iter.next();
                    this.remove(mc);
                    removed = true;
                    ConnectionPoolImpl.this.destroyManagedConnection(factory, mc);
                    if (!ApplicationServer.DMS_GATE || ConnectionPoolImpl.this.m_invalidCountEvent == null) continue;
                    ConnectionPoolImpl.this.m_invalidCountEvent.occurred();
                }
            }
            catch (ResourceException e) {
                ConnectionPoolImpl.this.logResourceException(e, "Exception occurred during call to getInvalidConnections");
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean timeout(boolean keepMin) {
            if ((long)ConnectionPoolImpl.this.m_inactivityTimeout == 0L) {
                return false;
            }
            boolean removed = false;
            long purgeCutoffTime = ConnectionPoolImpl.this.getPurgeCutoffTime();
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                if (this.m_inactiveList.isEmpty()) {
                    return false;
                }
                if (this.m_nextInactivityListElementTime > 0L && this.m_nextInactivityListElementTime < purgeCutoffTime) {
                    if (keepMin && ConnectionPoolImpl.this.getNumOpenConnections() <= ConnectionPoolImpl.this.m_minConnections) {
                        return false;
                    }
                    this.m_nextInactivityListElementTime = 0L;
                    boolean done = false;
                    InactiveListElement element = (InactiveListElement)this.m_inactiveList.getFirst();
                    while (element != null && !done) {
                        this.m_nextInactivityListElementTime = element.getReturnToPoolTime();
                        if (element.getReturnToPoolTime() < purgeCutoffTime) {
                            element = this.removeFirst();
                            removed = true;
                            if (ApplicationServer.DMS_GATE && ConnectionPoolImpl.this.m_expiredCountEvent != null) {
                                ConnectionPoolImpl.this.m_expiredCountEvent.occurred();
                            }
                            if (!keepMin || ConnectionPoolImpl.this.getNumOpenConnections() > ConnectionPoolImpl.this.m_minConnections) continue;
                            done = true;
                            continue;
                        }
                        done = true;
                    }
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InactiveListElement removeFirst() {
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                if (this.m_inactiveList.size() == 0) {
                    return null;
                }
                InactiveListElement element = (InactiveListElement)this.m_inactiveList.getFirst();
                if (element == null) {
                    return null;
                }
                ManagedConnection mc = element.getManagedConnection();
                if (mc != null) {
                    this.m_candidateSet.remove(mc);
                    ConnectionPoolImpl.this.destroyManagedConnection(element.getConnectionPoolConnFactory(), mc);
                }
                this.m_inactiveList.removeFirst();
                if (this.m_inactiveList.size() > 0) {
                    element = (InactiveListElement)this.m_inactiveList.getFirst();
                } else {
                    element = null;
                    this.m_isEmpty = true;
                }
                return element;
            }
        }
    }

    class FixedWaitPoolingScheme
    extends PoolingScheme {
        private boolean m_schemeSwitched;

        public FixedWaitPoolingScheme() {
            this.m_schemeSwitched = false;
        }

        public String getName() {
            return "fixed_wait";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public ManagedConnection getManagedConnection(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
            ManagedConnection mc = null;
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            // MONITORENTER : objectArray
            if (!ConnectionPoolImpl.this.m_freePool.isEmpty()) {
                mc = factory.matchManagedConnections(context, ConnectionPoolImpl.this.m_freePool.getCandidateSet());
            }
            if (mc == null) {
                ConnectionPoolImpl.this.m_freePool.makeRoom(1);
                long waitEndTime = 0L;
                if (ConnectionPoolImpl.this.m_waitTimeout > 0) {
                    waitEndTime = System.currentTimeMillis() + (long)(ConnectionPoolImpl.this.m_waitTimeout * 1000);
                }
                while (ConnectionPoolImpl.this.m_maxConnections > 0 && mc == null && ConnectionPoolImpl.this.getNumOpenConnections() >= ConnectionPoolImpl.this.m_maxConnections && !this.m_schemeSwitched) {
                    Object var12_9;
                    long dmsToken = 0L;
                    try {
                        block24: {
                            try {
                                if (ApplicationServer.DMS_GATE && ConnectionPoolImpl.this.m_waitingThreadCountEvent != null) {
                                    dmsToken = ConnectionPoolImpl.this.m_waitingThreadCountEvent.start();
                                }
                                if (ConnectionPoolImpl.this.m_waitTimeout <= 0) break block24;
                                long waitTime = waitEndTime - System.currentTimeMillis();
                                if (ConnectorMessages.LOG_LEVEL_FINER_OR_HIGHER) {
                                    ConnectorMessages.debugWaitingForConnection(Thread.currentThread().toString(), waitTime);
                                }
                                ConnectionPoolImpl.this.m_poolLock.wait(waitTime);
                            }
                            catch (InterruptedException e) {
                                var12_9 = null;
                                if (ApplicationServer.DMS_GATE && ConnectionPoolImpl.this.m_waitingThreadCountEvent != null) {
                                    ConnectionPoolImpl.this.m_waitingThreadCountEvent.stop(dmsToken);
                                }
                            }
                        }
                        var12_9 = null;
                        if (ApplicationServer.DMS_GATE && ConnectionPoolImpl.this.m_waitingThreadCountEvent != null) {
                            ConnectionPoolImpl.this.m_waitingThreadCountEvent.stop(dmsToken);
                        }
                    }
                    catch (Throwable throwable) {
                        var12_9 = null;
                        if (!ApplicationServer.DMS_GATE) throw throwable;
                        if (ConnectionPoolImpl.this.m_waitingThreadCountEvent == null) throw throwable;
                        ConnectionPoolImpl.this.m_waitingThreadCountEvent.stop(dmsToken);
                        throw throwable;
                    }
                    if (System.currentTimeMillis() >= waitEndTime) {
                        waitEndTime = 0L;
                        if (ConnectionPoolImpl.this.m_requestTimeoutCountEvent != null) {
                            ConnectionPoolImpl.this.m_requestTimeoutCountEvent.occurred();
                        }
                        if (!ConnectorMessages.LOG_LEVEL_FINER_OR_HIGHER) throw new ResourceAllocationException("Unable to allocate new connection - pool is full and timed out waiting for a connection to be freed up.");
                        ConnectorMessages.debugUnableToGetConnection(Thread.currentThread().toString());
                        throw new ResourceAllocationException("Unable to allocate new connection - pool is full and timed out waiting for a connection to be freed up.");
                    }
                    if (ConnectionPoolImpl.this.m_freePool.isEmpty() || (mc = factory.matchManagedConnections(context, ConnectionPoolImpl.this.m_freePool.getCandidateSet())) != null) continue;
                    ConnectionPoolImpl.this.m_freePool.makeRoom(1);
                }
            }
            if (mc != null) {
                this.useConnection(mc);
            }
            // MONITOREXIT : objectArray
            if (mc == null) {
                if (this.m_schemeSwitched) {
                    return ConnectionPoolImpl.this.m_scheme.getManagedConnection(factory, context);
                }
                mc = ConnectionPoolImpl.this.createManagedConnectionFromFactory(factory, context);
                if (mc != null) {
                    objectArray = ConnectionPoolImpl.this.m_poolLock;
                    // MONITORENTER : objectArray
                    this.useConnection(mc);
                    // MONITOREXIT : objectArray
                }
            }
            if (ConnectorMessages.LOG_LEVEL_FINER_OR_HIGHER) {
                ConnectorMessages.debugGotConnection(Thread.currentThread().toString());
            }
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_freePool.size=" + ConnectionPoolImpl.this.m_freePool.size() + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
            if (!m_logger.isLoggable(Level.FINEST)) return mc;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(baos));
            m_logger.finest(baos.toString());
            return mc;
        }

        public void connectionClosed(ConnectionPoolConnFactory factory, ManagedConnection mc, boolean discard) {
            super.connectionClosed(factory, mc, discard);
        }

        public void notifyConnectionAvailable() {
            ConnectionPoolImpl.this.m_poolLock.notifyAll();
        }

        public void switchScheme() {
            this.m_schemeSwitched = true;
            ConnectionPoolImpl.this.m_poolLock.notifyAll();
        }
    }

    class FixedPoolingScheme
    extends PoolingScheme {
        public String getName() {
            return "fixed";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
            ManagedConnection mc = null;
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                if (!ConnectionPoolImpl.this.m_freePool.isEmpty() && (mc = factory.matchManagedConnections(context, ConnectionPoolImpl.this.m_freePool.getCandidateSet())) != null) {
                    this.useConnection(mc);
                }
                if (mc == null) {
                    ConnectionPoolImpl.this.m_freePool.makeRoom(1);
                    if (ConnectionPoolImpl.this.m_maxConnections > 0 && ConnectionPoolImpl.this.getNumOpenConnections() >= ConnectionPoolImpl.this.m_maxConnections) {
                        throw new ResourceAllocationException("Unable to allocate new connection - All connections are in use.");
                    }
                }
            }
            if (mc == null && (mc = ConnectionPoolImpl.this.createManagedConnectionFromFactory(factory, context)) != null) {
                objectArray = ConnectionPoolImpl.this.m_poolLock;
                synchronized (objectArray) {
                    this.useConnection(mc);
                }
            }
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_freePool.size=" + ConnectionPoolImpl.this.m_freePool.size() + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new Exception().printStackTrace(new PrintStream(baos));
                m_logger.finest(baos.toString());
            }
            return mc;
        }
    }

    class DynamicPoolingScheme
    extends PoolingScheme {
        public String getName() {
            return "dynamic";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
            ManagedConnection mc = null;
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                if (!ConnectionPoolImpl.this.m_freePool.isEmpty() && (mc = factory.matchManagedConnections(context, ConnectionPoolImpl.this.m_freePool.getCandidateSet())) != null) {
                    this.useConnection(mc);
                }
            }
            if (mc == null && (mc = ConnectionPoolImpl.this.createManagedConnectionFromFactory(factory, context)) != null) {
                objectArray = ConnectionPoolImpl.this.m_poolLock;
                synchronized (objectArray) {
                    this.useConnection(mc);
                }
            }
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_freePool.size=" + ConnectionPoolImpl.this.m_freePool.size() + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new Exception().printStackTrace(new PrintStream(baos));
                m_logger.finest(baos.toString());
            }
            return mc;
        }

        public void switchScheme() {
            ConnectionPoolImpl.this.getFreePool().makeRoom(0);
        }
    }

    class NonePoolingScheme
    extends PoolingScheme {
        public NonePoolingScheme() {
            ConnectionPoolImpl.this.m_freePool.clear();
        }

        public String getName() {
            return "none";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
            ManagedConnection mc = null;
            mc = ConnectionPoolImpl.this.createManagedConnectionFromFactory(factory, context);
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                this.useConnection(mc);
            }
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new Exception().printStackTrace(new PrintStream(baos));
                m_logger.finest(baos.toString());
            }
            return mc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionPoolConnFactory factory, ManagedConnection mc, boolean discard) {
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                ConnectionPoolImpl.this.m_inUseSet.remove(mc);
                ConnectionPoolImpl.this.updatePoolSizeDMSMetrics();
            }
            ConnectionPoolImpl.this.destroyManagedConnection(factory, mc);
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new Exception().printStackTrace(new PrintStream(baos));
                m_logger.finest(baos.toString());
            }
        }

        public void useConnection(ManagedConnection mc) {
            ConnectionPoolImpl.this.m_inUseSet.add(mc);
            ConnectionPoolImpl.this.updatePoolSizeDMSMetrics();
        }
    }

    abstract class PoolingScheme {
        public PoolingScheme() {
            if (ConnectionPoolImpl.this.m_inUseSet == null) {
                ConnectionPoolImpl.this.m_inUseSet = new HashSet();
            }
            if (ConnectionPoolImpl.this.m_freePool == null) {
                ConnectionPoolImpl.this.m_freePool = new FreePool();
            }
        }

        public abstract ManagedConnection getManagedConnection(ConnectionPoolConnFactory var1, ConnectionPoolConnFactoryContext var2) throws ResourceException;

        public abstract String getName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionPoolConnFactory factory, ManagedConnection mc, boolean discard) {
            boolean addToFreePool = true;
            Object[] objectArray = ConnectionPoolImpl.this.m_poolLock;
            synchronized (objectArray) {
                boolean dynamicScheme;
                boolean bl = dynamicScheme = ConnectionPoolImpl.this.m_scheme.getName().equals("dynamic");
                if (discard) {
                    addToFreePool = false;
                } else if (dynamicScheme || ConnectionPoolImpl.this.m_maxConnections < 0) {
                    addToFreePool = true;
                } else if (ConnectionPoolImpl.this.m_maxConnections == 0 || ConnectionPoolImpl.this.getNumOpenConnections() > ConnectionPoolImpl.this.m_maxConnections) {
                    addToFreePool = false;
                }
                ConnectionPoolImpl.this.m_inUseSet.remove(mc);
                if (addToFreePool) {
                    ConnectionPoolImpl.this.m_freePool.add(factory, mc);
                }
                ConnectionPoolImpl.this.updatePoolSizeDMSMetrics();
                this.notifyConnectionAvailable();
            }
            if (!addToFreePool) {
                ConnectionPoolImpl.this.destroyManagedConnection(factory, mc);
            }
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new Exception().printStackTrace(new PrintStream(baos));
                m_logger.finest(baos.toString());
            }
        }

        public void notifyConnectionAvailable() {
        }

        public void useConnection(ManagedConnection mc) {
            ConnectionPoolImpl.this.m_freePool.remove(mc);
            ConnectionPoolImpl.this.m_inUseSet.add(mc);
            ConnectionPoolImpl.this.updatePoolSizeDMSMetrics();
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]-" + " this=" + this + ",m_freePool.size=" + ConnectionPoolImpl.this.m_freePool.size() + ",m_inUseSet.size=" + ConnectionPoolImpl.this.m_inUseSet.size());
            }
        }

        public void switchScheme() {
        }
    }
}

