/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import oracle.j2ee.connector.PrincipalMapping;

public abstract class AbstractPrincipalMapping
implements PrincipalMapping {
    protected ManagedConnectionFactory m_mcf;
    protected Map m_authMech;
    protected boolean m_isBasicPasswordSupported;
    protected boolean m_isKerbv5Supported;

    public abstract void init(Properties var1);

    public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
        this.m_mcf = mcf;
    }

    public void setAuthenticationMechanisms(Map authMechanisms) {
        this.m_authMech = authMechanisms;
        this.m_isBasicPasswordSupported = false;
        this.m_isKerbv5Supported = false;
        if (this.m_authMech != null) {
            this.m_isBasicPasswordSupported = this.m_authMech.containsKey("BasicPassword");
            this.m_isKerbv5Supported = this.m_authMech.containsKey("Kerbv5");
        }
    }

    public abstract Subject mapping(Subject var1);

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.m_mcf;
    }

    public Map getAuthenticationMechanisms() {
        return this.m_authMech;
    }

    public boolean isBasicPasswordSupported() {
        return this.m_isBasicPasswordSupported;
    }

    public boolean isKerbv5Supported() {
        return this.m_isKerbv5Supported;
    }

    public Principal getPrincipal(Subject subject) {
        Iterator<Principal> iter;
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        if (principals != null && (iter = principals.iterator()).hasNext()) {
            return iter.next();
        }
        return null;
    }
}

