/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer.internal;

import com.evermind.util.ServicesProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerService;
import oracle.ias.container.timer.internal.TimerStoreInterface;

public class FileTimerStore
implements TimerStoreInterface {
    public static final String timerFilenamePrefix = "ejb";
    public static final String cronFilenamePrefix = "cron";
    public static final String filenameSeparator = ".";
    public static final String filenameSuffix = ".timer";
    private static String _homeDirectoryPath = TimerService.instance() == null ? "." : TimerService.instance().getTempDir();
    public static final String persistentStoreDir = "persistence".equals(new File(_homeDirectoryPath).getName()) ? _homeDirectoryPath + File.separator + "timerPersistentStore" : _homeDirectoryPath + File.separator + "persistence" + File.separator + "timerPersistentStore";
    private File rootDir;
    private long _containerId = 0L;
    Object _persistentStoreLock = new Object();

    FileTimerStore(long containerId) {
        if (ServicesProperties.getContainerServiceDebug()) {
            System.out.println("FileTimerStore ctor");
        }
        this.rootDir = new File(persistentStoreDir);
        this.rootDir.mkdirs();
        this._containerId = containerId;
    }

    private String getFilenameFromTimer(Timer timer, boolean isCron) {
        String filename = null;
        String cID = new String(filenameSeparator + timer.getContainerId());
        String appID = new String(filenameSeparator + timer.getApplicationId());
        String tID = new String(filenameSeparator + timer.getTimerId() + filenameSuffix);
        filename = isCron ? new String(cronFilenamePrefix + appID + cID + tID) : new String(timerFilenamePrefix + appID + cID + tID);
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersistentStore(Timer timer, boolean isCron) {
        if (timer.getApplicationId() == null) {
            return;
        }
        String filename = this.getFilenameFromTimer(timer, isCron);
        Object object = this._persistentStoreLock;
        synchronized (object) {
            block7: {
                try {
                    File f = new File(this.rootDir, filename);
                    FileOutputStream fos = new FileOutputStream(f);
                    ObjectOutputStream out = new ObjectOutputStream(fos);
                    out.writeObject(timer);
                    out.flush();
                    out.close();
                    if (ServicesProperties.getContainerServiceDebug()) {
                        System.out.println("wrote timer to file " + filename);
                    }
                }
                catch (Exception e) {
                    if (!ServicesProperties.getContainerServiceDebug()) break block7;
                    System.out.println("Error writing timer to file " + filename + " " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection readPersistentStore(boolean isCron) {
        ArrayList<Timer> list = new ArrayList<Timer>();
        Object object = this._persistentStoreLock;
        synchronized (object) {
            block10: {
                if (ServicesProperties.getContainerServiceDebug()) {
                    System.out.println("readPersistentStore ... ");
                }
                String filename = "";
                try {
                    File[] allFiles = this.rootDir.listFiles(new TimerFilter());
                    for (int i = 0; i < Array.getLength(allFiles); ++i) {
                        if ((!isCron || !allFiles[i].getName().startsWith(cronFilenamePrefix)) && (isCron || !allFiles[i].getName().startsWith(timerFilenamePrefix))) continue;
                        filename = allFiles[i].getName();
                        if (ServicesProperties.getContainerServiceDebug()) {
                            System.out.println("reading timer from file " + filename);
                        }
                        try {
                            FileInputStream fis = new FileInputStream(allFiles[i]);
                            ObjectInputStream in = new ObjectInputStream(fis);
                            Timer timer = (Timer)in.readObject();
                            in.close();
                            fis.close();
                            list.add(timer);
                            continue;
                        }
                        catch (IOException e) {
                            if (!ServicesProperties.getContainerServiceDebug()) continue;
                            System.out.println("Error reading timer from file " + filename + " " + e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ServicesProperties.getContainerServiceDebug()) break block10;
                    System.out.println("Error reading timer from file " + filename + " " + e);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmPersistentStore(Timer timer, boolean isCron) {
        String filename = this.getFilenameFromTimer(timer, isCron);
        Object object = this._persistentStoreLock;
        synchronized (object) {
            block6: {
                try {
                    File f = new File(this.rootDir, filename);
                    boolean done = f.delete();
                    if (ServicesProperties.getContainerServiceDebug()) {
                        System.out.println("deleting timer from file " + filename + " " + done);
                    }
                }
                catch (NullPointerException e) {
                    if (!ServicesProperties.getContainerServiceDebug()) break block6;
                    System.out.println("Error deleting timer from file " + filename + " " + e);
                }
            }
        }
    }

    private class TimerFilter
    implements FilenameFilter {
        private TimerFilter() {
        }

        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            if (name.endsWith(FileTimerStore.filenameSuffix) && name.length() > FileTimerStore.filenameSuffix.length()) {
                String substr = name.substring(0, name.length() - FileTimerStore.filenameSuffix.length());
                return name.indexOf(FileTimerStore.filenameSeparator + FileTimerStore.this._containerId + FileTimerStore.filenameSeparator) != -1;
            }
            return false;
        }
    }
}

