/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ServerMessages;
import com.evermind.util.ServicesProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ias.container.Service;
import oracle.ias.container.ServiceManager;

public class ContainerServiceManager
implements ServiceManager {
    private HashMap m_services = null;
    private static ContainerServiceManager m_instance;
    private Latch _latch;
    private CyclicBarrier _barrier;

    private ContainerServiceManager() {
        m_instance = this;
        this.m_services = new HashMap();
        this._latch = new Latch();
    }

    public static ContainerServiceManager instance() {
        if (m_instance == null) {
            m_instance = new ContainerServiceManager();
        }
        return m_instance;
    }

    public synchronized boolean startServices() {
        Service service = null;
        String name = null;
        Iterator serviceIter = this.m_services.values().iterator();
        ArrayList<Service> threadedServices = new ArrayList<Service>();
        while (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            name = service.getName();
            if (service.isRunning() || !service.isThreaded()) continue;
            threadedServices.add(service);
        }
        this._barrier = new CyclicBarrier(threadedServices.size() + 1);
        for (int i = 0; i < threadedServices.size(); ++i) {
            service = (Service)threadedServices.get(i);
            ServerMessages.infoLaunchingContainerService(service.getName());
            this.launch(service);
        }
        try {
            this._barrier.barrier();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
        serviceIter = this.m_services.values().iterator();
        while (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            name = service.getName();
            if (!service.start()) continue;
            if (service.isRunning()) {
                if (!ServicesProperties.getContainerServiceManagerDebug()) continue;
                System.out.println("Service '" + name + "' started");
                continue;
            }
            System.err.println("Failed to start service '" + name + "'");
        }
        this._latch.release();
        return true;
    }

    public void launch(Runnable service) {
        ApplicationServer appServer = ApplicationServer.getInstance();
        if (appServer != null) {
            appServer.getThreadPool().launch(service);
        } else {
            if (ServicesProperties.getContainerServiceManagerDebug()) {
                System.err.println("m_appServer is null");
            }
            Thread th = new Thread(service);
            th.start();
        }
    }

    public synchronized boolean stopServices() {
        Service service = null;
        String name = null;
        Iterator serviceIter = this.m_services.values().iterator();
        while (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            name = service.getName();
            if (!service.isRunning()) continue;
            if (service.stop()) {
                if (!ServicesProperties.getContainerServiceManagerDebug()) continue;
                System.out.println("Service '" + name + "' stopped");
                continue;
            }
            System.err.println("Failed to stop service '" + name + "'");
        }
        return true;
    }

    public synchronized boolean pauseServices() {
        Service service = null;
        String name = null;
        Iterator serviceIter = this.m_services.values().iterator();
        while (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            name = service.getName();
            if (!service.isRunning()) continue;
            if (service.pause()) {
                if (!ServicesProperties.getContainerServiceManagerDebug()) continue;
                System.out.println("Service '" + name + "' paused");
                continue;
            }
            System.err.println("Failed to pause service '" + name + "'");
        }
        return true;
    }

    public synchronized boolean addService(Service service) {
        String name = service.getName();
        if (this.getService(name) != null) {
            System.err.println("The service name '" + name + "' already exist.");
            return false;
        }
        if (!service.initialize()) {
            System.err.println("Could not initialize service named '" + name + "'.");
            return false;
        }
        this.m_services.put(name, service);
        return true;
    }

    public synchronized boolean removeService(Service service) {
        if (service.isRunning()) {
            service.stop();
        }
        service.shutdown();
        System.out.println("removeService " + service.getName());
        this.m_services.remove(service.getName());
        return true;
    }

    public synchronized boolean postInit() {
        Service service = null;
        Collection serviceList = this.m_services.values();
        Iterator serviceIter = serviceList.iterator();
        while (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            if (!service.isRunning()) continue;
            service.postInit();
        }
        return true;
    }

    public synchronized boolean shutdown() {
        Service service = null;
        Collection serviceList = this.m_services.values();
        Iterator serviceIter = serviceList.iterator();
        while (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            if (service.isRunning()) {
                ServerMessages.infoStoppingContainerService(service.getName());
                service.stop();
            }
            service.shutdown();
        }
        this.m_services.clear();
        return true;
    }

    public synchronized String[] listServices() {
        String[] strs = new String[]{};
        return this.m_services.keySet().toArray(strs);
    }

    public synchronized Service getService(String name) {
        return (Service)this.m_services.get(name);
    }

    public Latch getLatch() {
        return this._latch;
    }

    public CyclicBarrier getBarrier() {
        return this._barrier;
    }
}

