/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.XAState;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.util.TraceLogger;

public class Branch {
    private GlobalTransaction m_transaction;
    private XAResource m_xaResource;
    private Xid m_xid;
    private RMId m_rid;
    private XAState m_state;
    private int m_retryCount;
    private static Logger m_logger = TraceLogger.getLogger(Branch.class);
    private XAException m_exception;

    Branch(GlobalTransaction transaction, XAResource xaResource, Xid xid, RMId rid, int status) {
        this.m_transaction = transaction;
        this.m_xaResource = xaResource;
        this.m_xid = xid;
        this.m_rid = rid;
        this.m_state = new XAState(status);
        this.m_exception = null;
    }

    public GlobalTransaction getTransaction() {
        return this.m_transaction;
    }

    public Xid getXid() {
        return this.m_xid;
    }

    public XAResource xaResource() {
        return this.m_xaResource;
    }

    public void setXaResource(XAResource resource) {
        this.m_xaResource = resource;
    }

    public RMId getRmId() {
        return this.m_rid;
    }

    public void setRMId(RMId rmid) {
        this.m_rid = rmid;
    }

    public int status() {
        return this.m_state.getState();
    }

    public void setStatus(int status) {
        this.m_state = new XAState(status);
    }

    public XAState getXAState() {
        return this.m_state;
    }

    public void setException(XAException e) {
        this.m_exception = e;
    }

    public XAException getException() {
        return this.m_exception;
    }

    boolean isOnePhase() {
        return false;
    }

    boolean supportsRecovery() {
        return true;
    }

    void setStatus(int status, XAException result) throws Store.StoreException {
        this.m_state = new XAState(status);
        this.m_exception = result;
    }

    void incrementRetryCount() {
        ++this.m_retryCount;
    }

    int getRetryCount() {
        return this.m_retryCount;
    }

    public void resetResource() throws Store.StoreException {
        this.setXaResource(null);
    }

    public int act(int action) throws XAException {
        int xaVote = 0;
        switch (action) {
            case 0: {
                this.logMsg("PREPARING");
                xaVote = this.m_xaResource.prepare(this.m_xid);
                break;
            }
            case 1: {
                if (this.getXAState().getState() == 128) break;
                this.logMsg("COMMITTING");
                this.m_xaResource.commit(this.m_xid, false);
                break;
            }
            case 2: {
                this.logMsg("ONE PHASE COMMIT");
                this.m_xaResource.commit(this.m_xid, true);
                break;
            }
            case 3: {
                this.logMsg("ROLLINGBACK");
                this.m_xaResource.rollback(this.m_xid);
                break;
            }
            case 4: {
                this.logMsg("FORGETTING");
                this.m_xaResource.forget(this.m_xid);
                break;
            }
            default: {
                return xaVote;
            }
        }
        return xaVote;
    }

    public String toString() {
        String errorCode = this.m_exception == null ? "" : TransactionMessages.stringForErrorCode(this.m_exception.errorCode) + "";
        return "[" + this.m_xaResource + ", " + NormalXid.toString(this.m_xid) + ", " + this.m_rid + ", " + "state=" + this.m_state.toString() + ", exception error code=" + errorCode + "]";
    }

    private void logMsg(String msg) {
        if (!m_logger.isLoggable(Level.FINE)) {
            return;
        }
        m_logger.log(Level.FINE, TransactionMessages.getTraceMsgInvokeResource(m_logger, Level.FINE, this.m_xaResource, this.m_xid, msg));
    }
}

