/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.util.TypeUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.crimson.tree.ElementNode;
import org.w3c.dom.Node;

public class EjbNode
extends ElementNode {
    private static final boolean debug = false;
    private EjbBundleDescriptor ejbBundleDescriptor;

    public static String[] getTags() {
        String[] tags = new String[]{"session", "entity", "message-driven"};
        return tags;
    }

    public void setEjbBundleDescriptor(EjbBundleDescriptor value) {
        this.ejbBundleDescriptor = value;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        return this.ejbBundleDescriptor;
    }

    public void setDescriptor(EjbDescriptor ejbDescriptor) {
        ElementNode secNode;
        PersistenceDescriptor pers;
        EjbCMPEntityDescriptor cmpEntity;
        EjbEntityDescriptor entity = null;
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(super.getOwnerDocument());
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            this.setTag("entity");
        } else if (ejbDescriptor instanceof EjbSessionDescriptor) {
            this.setTag("session");
        } else {
            this.setTag("message-driven");
        }
        DescriptorNodeUtils.appendDescriptorAttributes(factory, ejbDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        this.appendChild((Node)factory.getTextNode("ejb-name", ejbDescriptor.getName()));
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                this.appendChild((Node)factory.getTextNode("home", ejbDescriptor.getHomeClassName()));
                this.appendChild((Node)factory.getTextNode("remote", ejbDescriptor.getRemoteClassName()));
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                this.appendChild((Node)factory.getTextNode("local-home", ejbDescriptor.getLocalHomeClassName()));
                this.appendChild((Node)factory.getTextNode("local", ejbDescriptor.getLocalClassName()));
            }
        }
        this.appendChild((Node)factory.getTextNode("ejb-class", ejbDescriptor.getEjbClassName()));
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            entity = (EjbEntityDescriptor)ejbDescriptor;
            this.appendChild((Node)factory.getTextNode("persistence-type", entity.getPersistenceType()));
            if (!entity.getPrimaryKeyClassName().equals("")) {
                this.appendChild((Node)factory.getTextNode("prim-key-class", entity.getPrimaryKeyClassName()));
            }
            this.appendChild((Node)factory.getTextNode("reentrant", entity.isReentrantAsString()));
            if (entity.getPersistenceType().equals("Container")) {
                cmpEntity = (EjbCMPEntityDescriptor)entity;
                this.appendChild((Node)factory.getTextNode("cmp-version", cmpEntity.getCMPVersion()));
                if (cmpEntity.isEJB20()) {
                    this.appendChild((Node)factory.getTextNode("abstract-schema-name", cmpEntity.getAbstractSchemaName()));
                }
                pers = cmpEntity.getPersistenceDescriptor();
                Iterator itr = pers.getCMPFields().iterator();
                while (itr.hasNext()) {
                    FieldDescriptor nextField = (FieldDescriptor)itr.next();
                    ElementNode fieldNode = factory.getNode("cmp-field");
                    this.appendChild((Node)fieldNode);
                    if (!nextField.getDescription().equals("")) {
                        fieldNode.appendChild((Node)factory.getTextNode("description", nextField.getDescription()));
                    }
                    fieldNode.appendChild((Node)factory.getTextNode("field-name", nextField.getName()));
                }
                if (cmpEntity.getPrimaryKeyFieldDesc() != null) {
                    this.appendChild((Node)factory.getTextNode("primkey-field", cmpEntity.getPrimaryKeyFieldDesc().getName()));
                }
            }
        }
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            ElementNode sessionTypeNode = factory.getTextNode("session-type", ((EjbSessionDescriptor)ejbDescriptor).getSessionTypeString());
            this.appendChild((Node)sessionTypeNode);
        }
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            this.appendChild((Node)factory.getTextNode("transaction-type", ejbDescriptor.getTransactionType()));
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor;
            if (msgBeanDesc.hasJmsMessageSelector()) {
                this.appendChild((Node)factory.getTextNode("message-selector", msgBeanDesc.getJmsMessageSelector()));
            }
            if (msgBeanDesc.getTransactionType().equals(EjbDescriptor.BEAN_TRANSACTION_TYPE)) {
                String jmsAckModeStr = "Auto-acknowledge";
                this.appendChild((Node)factory.getTextNode("acknowledge-mode", jmsAckModeStr));
            }
            ElementNode msgDrivenDestNode = factory.getNode("message-driven-destination");
            this.appendChild((Node)msgDrivenDestNode);
            String destTypeStr = msgBeanDesc.hasQueueDest() ? "javax.jms.Queue" : "javax.jms.Topic";
            msgDrivenDestNode.appendChild((Node)factory.getTextNode("destination-type", destTypeStr));
            if (msgBeanDesc.hasTopicDest()) {
                String durableSubscriptionStr = msgBeanDesc.hasDurableSubscription() ? "Durable" : "NonDurable";
                msgDrivenDestNode.appendChild((Node)factory.getTextNode("subscription-durability", durableSubscriptionStr));
            }
        }
        DescriptorNodeUtils.appendEnvironmentProperties(factory, ejbDescriptor, this);
        DescriptorNodeUtils.appendEjbReferences(factory, ejbDescriptor, this);
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
            Iterator itr = ejbDescriptor.getRoleReferences().iterator();
            while (itr.hasNext()) {
                RoleReference nextRoleReference = (RoleReference)itr.next();
                ElementNode roleReferenceNode = factory.getNode("security-role-ref");
                this.appendChild((Node)roleReferenceNode);
                if (!"".equals(nextRoleReference.getDescription())) {
                    roleReferenceNode.appendChild((Node)factory.getTextNode("description", nextRoleReference.getDescription()));
                }
                roleReferenceNode.appendChild((Node)factory.getTextNode("role-name", nextRoleReference.getName()));
                if ("".equals(nextRoleReference.getValue())) continue;
                roleReferenceNode.appendChild((Node)factory.getTextNode("role-link", nextRoleReference.getValue()));
            }
        }
        if (ejbDescriptor.getUsesCallerIdentity()) {
            secNode = factory.getNode("security-identity");
            this.appendChild((Node)secNode);
            secNode.appendChild((Node)factory.getTextNode("description", ejbDescriptor.getSecurityIdentityDescription()));
            secNode.appendChild((Node)factory.getTextNode("use-caller-identity", ""));
        } else if (ejbDescriptor.getRunAsIdentity() != null) {
            secNode = factory.getNode("security-identity");
            this.appendChild((Node)secNode);
            secNode.appendChild((Node)factory.getTextNode("description", ejbDescriptor.getSecurityIdentityDescription()));
            ElementNode runAsNode = factory.getNode("run-as");
            secNode.appendChild((Node)runAsNode);
            RunAsIdentityDescriptor runAs = ejbDescriptor.getRunAsIdentity();
            String description = runAs.getDescription();
            if (description != null) {
                runAsNode.appendChild((Node)factory.getTextNode("description", runAs.getDescription()));
            }
            runAsNode.appendChild((Node)factory.getTextNode("role-name", runAs.getRoleName()));
        }
        DescriptorNodeUtils.appendResourceReferences(factory, ejbDescriptor, this);
        DescriptorNodeUtils.appendJmsDestinationReferences(factory, ejbDescriptor, this);
        if (ejbDescriptor instanceof EjbEntityDescriptor && entity.getPersistenceType().equals("Container") && (cmpEntity = (EjbCMPEntityDescriptor)entity).isEJB20()) {
            pers = cmpEntity.getPersistenceDescriptor();
            EjbNode.writeQueries(this, pers, factory);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EjbDescriptor getDescriptor() throws ContentTransformationException {
        try {
            ElementNode idNode;
            ElementNode scopeNode;
            EjbEntityDescriptor ejbDescriptor = null;
            if (!this.getTagName().equals("entity")) return null;
            String persType = XMLUtils.getTextFor(this, "persistence-type");
            ejbDescriptor = persType.equals(EjbEntityDescriptor.BEAN_PERSISTENCE) ? new EjbEntityDescriptor() : new EjbCMPEntityDescriptor();
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbDescriptor, DescriptorNodeUtils.EJB_STYLE);
            ejbDescriptor.setName(XMLUtils.getTextFor(this, "ejb-name"));
            if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
                if (XMLUtils.hasImmediateElementChildFor(this, "home")) {
                    ejbDescriptor.setHomeClassName(XMLUtils.getTextFor(this, "home"));
                    ejbDescriptor.setRemoteClassName(XMLUtils.getTextFor(this, "remote"));
                }
                if (XMLUtils.hasImmediateElementChildFor(this, "local-home")) {
                    ejbDescriptor.setLocalHomeClassName(XMLUtils.getTextFor(this, "local-home"));
                    ejbDescriptor.setLocalClassName(XMLUtils.getTextFor(this, "local"));
                }
                if (ejbDescriptor.getHomeClassName() == null && ejbDescriptor.getLocalHomeClassName() == null) {
                    throw new RuntimeException("Invalid XML : Bean " + ejbDescriptor.getName() + " does not define a local home or home interface");
                }
            }
            ejbDescriptor.setEjbClassName(XMLUtils.getTextFor(this, "ejb-class"));
            if (this.getTagName().equals("entity")) {
                persType = XMLUtils.getTextFor(this, "persistence-type");
                ejbDescriptor.setPersistenceType(persType);
            }
            if (ejbDescriptor instanceof EjbEntityDescriptor) {
                EjbEntityDescriptor entity = ejbDescriptor;
                entity.setPrimaryKeyClassName(XMLUtils.getTextFor(this, "prim-key-class"));
                entity.setReentrant(XMLUtils.getTextFor(this, "reentrant"));
                if (entity instanceof EjbCMPEntityDescriptor) {
                    EjbCMPEntityDescriptor cmpEntity = (EjbCMPEntityDescriptor)entity;
                    boolean isCMP20 = true;
                    String cmpVersion = EjbCMPEntityDescriptor.CMP_2_VERSION;
                    EjbBundleDescriptor ejbBundleDescriptor = this.getEjbBundleDescriptor();
                    if (ejbBundleDescriptor != null && ejbBundleDescriptor.isEJB11()) {
                        cmpVersion = EjbCMPEntityDescriptor.CMP_1_VERSION;
                        isCMP20 = false;
                    } else if (XMLUtils.hasNodesUnder((Node)((Object)this), "cmp-version")) {
                        cmpVersion = XMLUtils.getTextFor(this, "cmp-version");
                        isCMP20 = cmpVersion.equals(EjbCMPEntityDescriptor.CMP_2_VERSION);
                    }
                    cmpEntity.setCMPVersion(cmpVersion);
                    if (isCMP20) {
                        cmpEntity.setAbstractSchemaName(XMLUtils.getTextFor(this, "abstract-schema-name"));
                    }
                    PersistenceDescriptor pers = new PersistenceDescriptor();
                    cmpEntity.setPersistenceDescriptor(pers);
                    HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
                    Enumeration e = XMLUtils.getNodesUnder((Node)((Object)this), "cmp-field");
                    while (e.hasMoreElements()) {
                        ElementNode nextFieldNode = (ElementNode)e.nextElement();
                        String optionalDescription = "";
                        if (XMLUtils.hasNodesUnder((Node)nextFieldNode, "description")) {
                            optionalDescription = XMLUtils.getTextFor(nextFieldNode, "description");
                        }
                        FieldDescriptor field = new FieldDescriptor(XMLUtils.getTextFor(nextFieldNode, "field-name"), optionalDescription);
                        if (isCMP20) {
                            FieldDescriptor.checkFieldName(field.getName());
                        }
                        persistentFields.add(field);
                    }
                    pers.setCMPFields(persistentFields);
                    if (XMLUtils.hasNodesUnder((Node)((Object)this), "primkey-field")) {
                        String field = XMLUtils.getTextFor(this, "primkey-field");
                        cmpEntity.setPrimaryKeyFieldDesc(new FieldDescriptor(field, ""));
                    }
                }
            }
            if (ejbDescriptor instanceof EjbSessionDescriptor) {
                String sessionTypeString = XMLUtils.getTextFor(this, "session-type");
                ((EjbSessionDescriptor)((Object)ejbDescriptor)).setSessionTypeString(sessionTypeString);
            }
            if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                ((EjbDescriptor)ejbDescriptor).setTransactionType(XMLUtils.getTextFor(this, "transaction-type"));
            }
            if ((scopeNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "transaction-scope")) != null) {
                String txScope = XMLUtils.getTextFor(this, "transaction-scope");
                ejbDescriptor.setDistributedTransactionScope(txScope.equals("Distributed"));
            } else {
                ejbDescriptor.setDistributedTransactionScope(true);
            }
            if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                String jmsAckModeStr;
                EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)((Object)ejbDescriptor);
                if (XMLUtils.hasNodesUnder((Node)((Object)this), "message-selector")) {
                    msgBeanDesc.setJmsMessageSelector(XMLUtils.getTextFor(this, "message-selector"));
                }
                if (XMLUtils.hasNodesUnder((Node)((Object)this), "acknowledge-mode") && !(jmsAckModeStr = XMLUtils.getTextFor(this, "acknowledge-mode")).equals("Auto-acknowledge") && !jmsAckModeStr.equals("Dups-ok-acknowledge")) {
                    throw new IllegalArgumentException("Invalid jms acknowledge mode : " + jmsAckModeStr);
                }
                ElementNode msgDrivenDestNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "message-driven-destination");
                if (msgDrivenDestNode != null) {
                    String destTypeStr = XMLUtils.getTextFor(msgDrivenDestNode, "destination-type");
                    if (destTypeStr.equals("javax.jms.Queue")) {
                        msgBeanDesc.setHasQueueDest();
                    } else {
                        if (!destTypeStr.equals("javax.jms.Topic")) throw new IllegalArgumentException("Invalid jms dest type : " + destTypeStr);
                        msgBeanDesc.setHasTopicDest();
                        if (XMLUtils.hasNodesUnder((Node)msgDrivenDestNode, "subscription-durability")) {
                            String subscriptionDurabilityStr = XMLUtils.getTextFor(msgDrivenDestNode, "subscription-durability");
                            if (subscriptionDurabilityStr.equals("Durable")) {
                                msgBeanDesc.setHasDurableSubscription(true);
                            } else {
                                if (!subscriptionDurabilityStr.equals("NonDurable")) throw new IllegalArgumentException("Invalid subscription durability string : " + subscriptionDurabilityStr);
                                msgBeanDesc.setHasDurableSubscription(false);
                            }
                        }
                    }
                } else {
                    msgBeanDesc.setHasQueueDest();
                }
            }
            DescriptorNodeUtils.setEnvironmentProperties(this, ejbDescriptor);
            if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
                Enumeration e = XMLUtils.getNodesUnder((Node)((Object)this), "security-role-ref");
                while (e.hasMoreElements()) {
                    ElementNode roleReferenceNode = (ElementNode)e.nextElement();
                    String roleReferenceName = XMLUtils.getTextFor(roleReferenceNode, "role-name");
                    String description = "";
                    if (XMLUtils.hasNodesUnder((Node)roleReferenceNode, "description")) {
                        description = XMLUtils.getTextFor(roleReferenceNode, "description");
                    }
                    RoleReference rr = new RoleReference(roleReferenceName, description);
                    if (XMLUtils.hasNodesUnder((Node)roleReferenceNode, "role-link")) {
                        rr.setValue(XMLUtils.getTextFor(roleReferenceNode, "role-link"));
                    }
                    ejbDescriptor.addRoleReference(rr);
                }
            }
            if ((idNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "security-identity")) != null) {
                ElementNode runAsNode;
                if (XMLUtils.hasNodesUnder((Node)idNode, "description")) {
                    String desc = XMLUtils.getTextFor(idNode, "description");
                    ejbDescriptor.setSecurityIdentityDescription(desc);
                }
                if ((runAsNode = XMLUtils.getFirstNodeUnder((Node)idNode, "run-as")) != null) {
                    String d;
                    RunAsIdentityDescriptor runAs = new RunAsIdentityDescriptor();
                    if (XMLUtils.hasNodesUnder((Node)runAsNode, "description") && (d = XMLUtils.getTextFor(runAsNode, "description")) != null) {
                        runAs.setDescription(d);
                    }
                    runAs.setRoleName(XMLUtils.getTextFor(runAsNode, "role-name"));
                    ejbDescriptor.setUsesCallerIdentity(false);
                    ejbDescriptor.setRunAsIdentity(runAs);
                } else {
                    ejbDescriptor.setUsesCallerIdentity(true);
                }
            } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                ejbDescriptor.setUsesCallerIdentity(false);
            }
            DescriptorNodeUtils.setResourceReferences(this, ejbDescriptor);
            DescriptorNodeUtils.setJmsDestinationReferences(this, ejbDescriptor);
            return ejbDescriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new ContentTransformationException(iae.getMessage(), this.toString());
        }
    }

    public void completeLoadingDescriptor(EjbDescriptor ejbDescriptor) {
        EjbCMPEntityDescriptor cmp;
        if (ejbDescriptor instanceof EjbCMPEntityDescriptor && (cmp = (EjbCMPEntityDescriptor)ejbDescriptor).isEJB20()) {
            EjbNode.parseQueries(this, cmp.getPersistenceDescriptor());
        }
    }

    static void parseQueries(ElementNode node, PersistenceDescriptor pers) {
        Enumeration e = XMLUtils.getNodesUnder((Node)node, "query");
        while (e.hasMoreElements()) {
            String ejbqlQuery;
            Method method;
            ElementNode queryNode = (ElementNode)e.nextElement();
            QueryDescriptor query = new QueryDescriptor();
            if (XMLUtils.hasNodesUnder((Node)queryNode, "description")) {
                query.setDescription(XMLUtils.getTextFor(queryNode, "description"));
            }
            try {
                method = EjbNode.parseQueryMethod(queryNode, pers.getParentDescriptor());
            }
            catch (Exception ex) {
                throw new RuntimeException("No method found for XML query element: " + ex.getMessage() + queryNode);
            }
            query.setQueryMethod(method);
            pers.setQueryFor(method, query);
            if (XMLUtils.hasNodesUnder((Node)queryNode, "result-type-mapping")) {
                String returnTypeMapping = XMLUtils.getTextFor(queryNode, "result-type-mapping");
                if (returnTypeMapping.equals("Remote")) {
                    query.setHasRemoteReturnTypeMapping();
                } else if (returnTypeMapping.equals("Local")) {
                    query.setHasLocalReturnTypeMapping();
                }
            }
            if ((ejbqlQuery = XMLUtils.getTextFor(queryNode, "ejb-ql")) != null && ejbqlQuery.trim().length() > 0) {
                query.setQuery(ejbqlQuery);
                continue;
            }
            query.setQuery(null);
        }
    }

    private static Method parseQueryMethod(ElementNode queryNode, Descriptor desc) throws Exception {
        Class<?> homeIntf = null;
        Class<?> localHomeIntf = null;
        Class<?> beanClass = null;
        ClassLoader loader = null;
        EjbCMPEntityDescriptor dd = (EjbCMPEntityDescriptor)desc;
        loader = ((EjbBundleArchivist)dd.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        if (dd.isRemoteInterfacesSupported()) {
            homeIntf = loader.loadClass(dd.getHomeClassName());
        }
        if (dd.isLocalInterfacesSupported()) {
            localHomeIntf = loader.loadClass(dd.getLocalHomeClassName());
        }
        beanClass = loader.loadClass(dd.getEjbClassName());
        ElementNode queryMethod = XMLUtils.getFirstNodeUnder((Node)queryNode, "query-method");
        String methodName = XMLUtils.getTextFor(queryMethod, "method-name");
        ElementNode methodParams = XMLUtils.getFirstNodeUnder((Node)queryMethod, "method-params");
        Vector params = XMLUtils.getVectorOfNodesUnder((Node)queryNode, "method-param");
        String[] types = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            ElementNode param = (ElementNode)params.elementAt(i);
            types[i] = XMLUtils.getTextFor(param, "method-param");
        }
        if (methodName.startsWith("ejbSelect")) {
            return TypeUtil.getMethod(beanClass, loader, methodName, types);
        }
        Method localFinder = null;
        Method remoteFinder = null;
        try {
            if (dd.isRemoteInterfacesSupported()) {
                remoteFinder = TypeUtil.getMethod(homeIntf, loader, methodName, types);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (dd.isLocalInterfacesSupported()) {
                localFinder = TypeUtil.getMethod(localHomeIntf, loader, methodName, types);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (remoteFinder != null) {
            return remoteFinder;
        }
        if (localFinder != null) {
            return localFinder;
        }
        throw new RuntimeException("Ambiguous or invalid <query-method>");
    }

    private static void getClass(String type, ClassLoader loader) {
    }

    static void writeQueries(ElementNode node, PersistenceDescriptor pers, XMLUtils factory) {
        Iterator it = pers.getQueriedMethods().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            QueryDescriptor query = pers.getQueryFor(method);
            ElementNode qNode = factory.getNode("query");
            if (query.getDescription() != null) {
                qNode.appendChild((Node)factory.getTextNode("description", query.getDescription()));
            }
            EjbNode.writeQueryMethod(qNode, method, pers, factory);
            if (query.getHasLocalReturnTypeMapping() || query.getHasRemoteReturnTypeMapping()) {
                String mapping = query.getHasRemoteReturnTypeMapping() ? "Remote" : "Local";
                qNode.appendChild((Node)factory.getTextNode("result-type-mapping", mapping));
            }
            String ejbqlText = query.getIsEjbQl() ? query.getQuery() : "";
            qNode.appendChild((Node)factory.getTextNode("ejb-ql", ejbqlText));
            node.appendChild((Node)qNode);
        }
    }

    private static void writeQueryMethod(ElementNode queryNode, Method method, PersistenceDescriptor pers, XMLUtils factory) {
        ElementNode queryMethod = factory.getNode("query-method");
        queryNode.appendChild((Node)queryMethod);
        queryMethod.appendChild((Node)factory.getTextNode("method-name", method.getName()));
        EjbCMPEntityDescriptor dd = (EjbCMPEntityDescriptor)pers.getParentDescriptor();
        ElementNode methodParamsNode = factory.getNode("method-params");
        queryMethod.appendChild((Node)methodParamsNode);
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            String param = MethodDescriptor.fixParamClassName(params[i].getName());
            ElementNode parameterNode = factory.getTextNode("method-param", param);
            methodParamsNode.appendChild((Node)parameterNode);
        }
    }

    public static Vector readEjbNodes(InputStream is) {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(EjbNode.class, nodeToClass, is);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new Vector();
        }
    }
}

