/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MethodDescriptor
extends Descriptor {
    public static String EJB_HOME = "Home";
    public static String EJB_LOCALHOME = "LocalHome";
    public static String EJB_REMOTE = "Remote";
    public static String EJB_LOCAL = "Local";
    public static String EJB_BEAN = "Bean";
    public static String ALL_OF_NAME = "AllOfName";
    public static String ALL_EJB_METHODS = "*";
    private String[] parameterClassNames = null;
    private String[] javaParameterClassNames = null;
    private String className = "";
    private String ejbClassSymbol;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$MethodDescriptor == null ? (class$com$sun$enterprise$deployment$MethodDescriptor = MethodDescriptor.class$("com.sun.enterprise.deployment.MethodDescriptor")) : class$com$sun$enterprise$deployment$MethodDescriptor);
    private int JAVA_FORMAT = 1;
    private int XML_FORMAT = -1;
    private int XML_JAVA_FORMAT = 0;
    private static Map javaPrimitivesTypes;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$MethodDescriptor;

    public MethodDescriptor(String name, String description, String[] parameterClassNames, String ejbClassSymbol) {
        super(name, description);
        if (name == null) {
            super.setName("");
        }
        if (parameterClassNames != null) {
            this.convertToAppropriateFormat(parameterClassNames);
        }
        this.setEjbClassSymbol(ejbClassSymbol);
    }

    private void convertToAppropriateFormat(String[] parameterClassNames) {
        int format = this.isJavaFormat(parameterClassNames);
        if (format == this.JAVA_FORMAT) {
            this.javaParameterClassNames = parameterClassNames;
            this.parameterClassNames = this.fixParamClassNames(parameterClassNames);
        } else if (format == this.XML_FORMAT) {
            this.javaParameterClassNames = this.xmlFormat2JavaClassNames(parameterClassNames);
            this.parameterClassNames = parameterClassNames;
        } else if (format == this.XML_JAVA_FORMAT) {
            this.javaParameterClassNames = parameterClassNames;
            this.parameterClassNames = parameterClassNames;
        }
    }

    public MethodDescriptor(String name, String description, String ejbClassSymbol) {
        super(name, description);
        this.parameterClassNames = null;
        this.setEjbClassSymbol(ejbClassSymbol);
    }

    public MethodDescriptor(Method method) {
        super(method.getName(), "");
        Class<?> methodClass = method.getClass();
        Method[] methods = methodClass.getMethods();
        this.parameterClassNames = this.getParameterClassNamesFor(method);
        this.javaParameterClassNames = this.getJavaFormatClassNamesFor(method);
        this.className = method.getDeclaringClass().getName();
    }

    public MethodDescriptor(Method method, String methodIntf) {
        this(method);
        this.setEjbClassSymbol(methodIntf);
    }

    public MethodDescriptor(Method method, EjbDescriptor ejbDescriptor, ClassLoader classloader) {
        this(method);
        this.processEjbSymbol(method, ejbDescriptor, classloader);
    }

    public boolean isExact() {
        boolean isExactName = !this.getName().equals(ALL_EJB_METHODS);
        boolean hasMethodIntf = !"".equals(this.getEjbClassSymbol());
        boolean hasParamsListed = this.getParameterClassNames() != null;
        return isExactName && hasMethodIntf && hasParamsListed;
    }

    public int getStyle() {
        if (this.getName().equals(ALL_EJB_METHODS)) {
            return 1;
        }
        if (this.getParameterClassNames() == null) {
            return 2;
        }
        return 3;
    }

    public Method getMethod(EjbDescriptor ejbDescriptor) {
        Method method;
        block26: {
            method = null;
            try {
                EjbBundleArchivist archivist = (EjbBundleArchivist)ejbDescriptor.getEjbBundleDescriptor().getArchivist();
                ClassLoader classloader = archivist.getClassLoader();
                String[] javaParamClassNames = this.getJavaParameterClassNames();
                if (this.ejbClassSymbol == null || this.ejbClassSymbol.equals("") || this.ejbClassSymbol.equals(EJB_BEAN)) {
                    try {
                        Class<?> ejbClass = classloader.loadClass(ejbDescriptor.getEjbClassName());
                        return TypeUtil.getMethod(ejbClass, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                                Class<?> homeClass = classloader.loadClass(ejbDescriptor.getHomeClassName());
                                return TypeUtil.getMethod(homeClass, classloader, this.getName(), javaParamClassNames);
                            }
                        }
                        catch (NoSuchMethodException nsme2) {
                            // empty catch block
                        }
                        try {
                            if (ejbDescriptor.isLocalInterfacesSupported()) {
                                Class<?> cl = classloader.loadClass(ejbDescriptor.getLocalHomeClassName());
                                return TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                            }
                            break block26;
                        }
                        catch (NoSuchMethodException nsme3) {}
                        break block26;
                    }
                }
                if (this.ejbClassSymbol.equals(EJB_HOME)) {
                    try {
                        Class<?> homeClass = classloader.loadClass(ejbDescriptor.getHomeClassName());
                        method = TypeUtil.getMethod(homeClass, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {}
                } else if (this.ejbClassSymbol.equals(EJB_LOCALHOME)) {
                    try {
                        Class<?> cl = classloader.loadClass(ejbDescriptor.getLocalHomeClassName());
                        method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {}
                } else if (this.ejbClassSymbol.equals(EJB_REMOTE)) {
                    try {
                        Class<?> cl = classloader.loadClass(ejbDescriptor.getRemoteClassName());
                        method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {}
                } else if (this.ejbClassSymbol.equals(EJB_LOCAL)) {
                    try {
                        Class<?> cl = classloader.loadClass(ejbDescriptor.getLocalClassName());
                        method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return method;
    }

    public Method getMethod(Class declaringClass) {
        try {
            return TypeUtil.getMethod(declaringClass, declaringClass.getClassLoader(), this.getName(), this.getJavaParameterClassNames());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Vector doStyleConversion(EjbDescriptor ejbDescriptor, Collection allMethods) {
        Vector<MethodDescriptor> v = new Vector<MethodDescriptor>();
        if (this.getName().equals(ALL_EJB_METHODS)) {
            Iterator itr = allMethods.iterator();
            while (itr.hasNext()) {
                MethodDescriptor next = (MethodDescriptor)itr.next();
                if (!next.isExact()) {
                    // empty if block
                }
                next.setDescription(this.getDescription());
                if (this.getEjbClassSymbol().equals("")) {
                    v.addElement(next);
                    continue;
                }
                if (!this.getEjbClassSymbol().equals(next.getEjbClassSymbol())) continue;
                v.addElement(next);
            }
        } else if (this.getParameterClassNames() == null) {
            v.addAll(this.getMethodDescriptorsOfName(this.getName(), allMethods));
        } else if (this.getEjbClassSymbol().equals("")) {
            v.addAll(this.getMethodDescriptorsOfNameAndParameters(this.getName(), this.getParameterClassNames(), allMethods));
        } else {
            v.addElement(this);
        }
        return v;
    }

    private Set getMethodDescriptorsOfNameAndParameters(String name, String[] parameterArray, Collection methodDescriptors) {
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        Iterator itr = this.getMethodDescriptorsOfName(name, methodDescriptors).iterator();
        while (itr.hasNext()) {
            MethodDescriptor next = (MethodDescriptor)itr.next();
            if (!this.stringArrayEquals(parameterArray, next.getParameterClassNames())) continue;
            if (!next.isExact()) {
                // empty if block
            }
            methods.add(next);
        }
        return methods;
    }

    private Set getMethodDescriptorsOfName(String name, Collection methodDescriptors) {
        HashSet<MethodDescriptor> set = new HashSet<MethodDescriptor>();
        Iterator itr = methodDescriptors.iterator();
        while (itr.hasNext()) {
            MethodDescriptor next = (MethodDescriptor)itr.next();
            if (!name.equals(next.getName())) continue;
            if (!next.isExact()) {
                // empty if block
            }
            if (this.getEjbClassSymbol().equals("")) {
                set.add(next);
                continue;
            }
            if (!this.getEjbClassSymbol().equals(next.getEjbClassSymbol())) continue;
            set.add(next);
        }
        return set;
    }

    public boolean isEquivalent(Method method) {
        return this.equals(new MethodDescriptor(method));
    }

    public String getEjbClassSymbol() {
        if (this.ejbClassSymbol == null) {
            this.ejbClassSymbol = "";
        }
        return this.ejbClassSymbol;
    }

    public void setEjbClassSymbol(String ejbClassSymbol) {
        this.ejbClassSymbol = ejbClassSymbol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEjbSymbol(Method method, EjbDescriptor ejbDescriptor, ClassLoader classloader) {
        try {
            Class<?> declaringClass = null;
            String declaringClassname = method.getDeclaringClass().getName();
            ClassLoader cl = classloader != null ? classloader : ((EjbBundleArchivist)ejbDescriptor.getEjbBundleDescriptor().getArchivist()).getClassLoader();
            Class<?> bean = cl.loadClass(ejbDescriptor.getEjbClassName());
            declaringClass = classloader.loadClass(declaringClassname);
            if (ejbDescriptor.getType().equals("Message-driven")) {
                if (declaringClass.isAssignableFrom(bean)) {
                    this.ejbClassSymbol = EJB_BEAN;
                    return;
                }
                System.out.println("declaring class = " + declaringClass);
                System.out.println("method = " + this);
                System.out.println("bean class = " + bean);
                throw new IllegalArgumentException();
            }
            boolean foundremote = ejbDescriptor.isRemoteInterfacesSupported();
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                Class<?> home = cl.loadClass(ejbDescriptor.getHomeClassName());
                Class<?> remote = cl.loadClass(ejbDescriptor.getRemoteClassName());
                if (declaringClass.isAssignableFrom(home)) {
                    this.ejbClassSymbol = EJB_HOME;
                } else if (declaringClass.isAssignableFrom(remote)) {
                    this.ejbClassSymbol = EJB_REMOTE;
                } else if (declaringClass.isAssignableFrom(bean)) {
                    this.ejbClassSymbol = EJB_BEAN;
                } else {
                    foundremote = false;
                }
            }
            boolean foundlocal = ejbDescriptor.isLocalInterfacesSupported();
            if (!foundremote && ejbDescriptor.isLocalInterfacesSupported()) {
                Class<?> localhome = cl.loadClass(ejbDescriptor.getLocalHomeClassName());
                Class<?> local = cl.loadClass(ejbDescriptor.getLocalClassName());
                if (declaringClass.isAssignableFrom(localhome)) {
                    this.ejbClassSymbol = EJB_LOCALHOME;
                } else if (declaringClass.isAssignableFrom(local)) {
                    this.ejbClassSymbol = EJB_LOCAL;
                } else if (declaringClass.isAssignableFrom(bean)) {
                    this.ejbClassSymbol = EJB_BEAN;
                } else {
                    foundlocal = false;
                }
            }
            if (foundlocal) return;
            if (foundremote) return;
            System.out.println("method class = " + declaringClass);
            System.out.println("bean class = " + bean);
            throw new IllegalArgumentException("Method is not on any EJB interface");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmethodnotfound", "{0} not found in {1}", new Object[]{method, ejbDescriptor}));
        }
    }

    public String getFormattedString() {
        return this.getName() + this.getPrettyParameterString();
    }

    public String getPrettyParameterString() {
        String prettyParameterString = "(";
        if (this.parameterClassNames != null) {
            int i = 0;
            while (i < this.parameterClassNames.length) {
                int j = i + 1;
                prettyParameterString = i > 0 ? prettyParameterString + ", " + this.parameterClassNames[i] + " parameter" + j : prettyParameterString + this.parameterClassNames[i] + " parameter" + j;
                ++i;
            }
        } else {
            prettyParameterString = "unspecified";
        }
        prettyParameterString = prettyParameterString + ")";
        return prettyParameterString;
    }

    public String[] getParameterClassNames() {
        return this.parameterClassNames;
    }

    public String[] getJavaParameterClassNames() {
        return this.javaParameterClassNames;
    }

    private boolean stringArrayEquals(String[] s1, String[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s2 == null && s1 != null) {
            return false;
        }
        if (s1.length == s2.length) {
            int i = 0;
            while (i < s1.length) {
                if (!s1[i].equals(s2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        MethodDescriptor otherMethodDescriptor;
        return other != null && other instanceof MethodDescriptor && (otherMethodDescriptor = (MethodDescriptor)other).getName().equals(this.getName()) && this.stringArrayEquals(otherMethodDescriptor.getParameterClassNames(), this.getParameterClassNames()) && this.getEjbClassSymbol().equals(otherMethodDescriptor.getEjbClassSymbol());
    }

    public int hashCode() {
        return this.getPrettyParameterString().hashCode() + this.getName().hashCode();
    }

    public String toString() {
        return "Method Descriptor: name: " + this.getName() + " params: " + this.getPrettyParameterString() + " intf: " + this.ejbClassSymbol;
    }

    private String[] getParameterClassNamesFor(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        String[] classNames = new String[classes.length];
        int i = 0;
        while (i < classes.length) {
            Class<?> compType = classes[i].getComponentType();
            if (compType == null) {
                classNames[i] = classes[i].getName();
            } else {
                int dimensions = 1;
                while (compType.getComponentType() != null) {
                    ++dimensions;
                    compType = compType.getComponentType();
                }
                classNames[i] = compType.getName();
                int j = 0;
                while (j < dimensions) {
                    int n = i;
                    classNames[n] = classNames[n] + "[]";
                    ++j;
                }
            }
            ++i;
        }
        return classNames;
    }

    private int isJavaFormat(String[] params) {
        int ret = this.XML_JAVA_FORMAT;
        int i = 0;
        while (i < params.length) {
            int index = params[i].indexOf(91);
            if (index != -1) {
                if (index == 0) {
                    return this.JAVA_FORMAT;
                }
                return this.XML_FORMAT;
            }
            ret = this.XML_JAVA_FORMAT;
            ++i;
        }
        return ret;
    }

    private String[] getJavaFormatClassNamesFor(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        String[] classNames = new String[classes.length];
        int i = 0;
        while (i < classes.length) {
            classNames[i] = classes[i].getName();
            ++i;
        }
        return classNames;
    }

    private String[] fixParamClassNames(String[] paramClassNames) {
        if (paramClassNames == null) {
            return null;
        }
        String[] newParams = new String[paramClassNames.length];
        int i = 0;
        while (i < paramClassNames.length) {
            newParams[i] = MethodDescriptor.fixParamClassName(paramClassNames[i]);
            ++i;
        }
        return newParams;
    }

    private String[] xmlFormat2JavaClassNames(String[] from) {
        String[] to = new String[from.length];
        int i = 0;
        while (i < from.length) {
            to[i] = new String(MethodDescriptor.xmlFormat2JavaClassNames(from[i]));
            ++i;
        }
        return to;
    }

    public static String xmlFormat2JavaClassNames(String param) {
        int indexOfArray = param.indexOf(91);
        if (indexOfArray == -1) {
            return param;
        }
        String buf = param.substring(0, indexOfArray);
        int lastIndexOf = param.lastIndexOf(93);
        int dimension = lastIndexOf - indexOfArray + 1;
        dimension /= 2;
        StringBuffer fs = new StringBuffer();
        int i = 0;
        while (i < dimension) {
            fs.append("[");
            ++i;
        }
        String javaPrimitiveType = (String)MethodDescriptor.getJavaPrimitiveTypes().get(buf);
        if (javaPrimitiveType != null) {
            fs.append(javaPrimitiveType);
        } else {
            fs.append("L");
            fs.append(buf);
            fs.append(";");
        }
        return fs.toString();
    }

    public static Map getJavaPrimitiveTypes() {
        if (javaPrimitivesTypes == null) {
            javaPrimitivesTypes = new Hashtable();
            javaPrimitivesTypes.put("char", "C");
            javaPrimitivesTypes.put("byte", "B");
            javaPrimitivesTypes.put("double", "D");
            javaPrimitivesTypes.put("float", "F");
            javaPrimitivesTypes.put("int", "I");
            javaPrimitivesTypes.put("long", "J");
            javaPrimitivesTypes.put("short", "S");
            javaPrimitivesTypes.put("boolean", "Z");
        }
        return javaPrimitivesTypes;
    }

    public static String fixParamClassName(String param) {
        if (param.charAt(0) == '[') {
            int dimensions = param.lastIndexOf(91) + 1;
            char code = param.charAt(dimensions);
            String newparam = null;
            switch (code) {
                case 'B': {
                    newparam = "byte";
                }
                case 'C': {
                    newparam = "char";
                }
                case 'D': {
                    newparam = "double";
                }
                case 'F': {
                    newparam = "float";
                }
                case 'I': {
                    newparam = "int";
                }
                case 'J': {
                    newparam = "long";
                }
                case 'S': {
                    newparam = "short";
                }
                case 'Z': {
                    newparam = "boolean";
                }
                case 'L': {
                    newparam = param.substring(dimensions + 1);
                }
            }
            int j = 0;
            while (j < dimensions) {
                newparam = newparam + "[]";
                ++j;
            }
            return newparam;
        }
        return param;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

