/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import java.util.Iterator;
import oracle.oc4j.corba.util.LocalStringManagerImpl;

public class EjbEntityDescriptor
extends EjbDescriptor {
    public static String TYPE = "Entity";
    public static String BEAN_PERSISTENCE = "Bean";
    public static String CONTAINER_PERSISTENCE = "Container";
    protected String persistenceType;
    protected boolean isReentrant = false;
    protected String isReentrantAsString;
    protected String primaryKeyClassName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbEntityDescriptor.class);

    public EjbEntityDescriptor() {
    }

    public EjbEntityDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbEntityDescriptor) {
            EjbEntityDescriptor entity = (EjbEntityDescriptor)other;
            this.persistenceType = entity.persistenceType;
            this.isReentrant = entity.isReentrant;
            this.primaryKeyClassName = entity.primaryKeyClassName;
        }
    }

    public void replaceEntityDescriptor(EjbEntityDescriptor oldEntityDesc) {
        EjbBundleDescriptor bundle = oldEntityDesc.getEjbBundleDescriptor();
        bundle.replaceEjb(oldEntityDesc, this);
        Iterator refs = oldEntityDesc.getAllEjbReferencers().iterator();
        while (refs.hasNext()) {
            EjbReferenceDescriptor ref = (EjbReferenceDescriptor)refs.next();
            ref.setEjbDescriptor(this);
        }
    }

    public boolean classesChanged() {
        return super.classesChanged();
    }

    public String getTransactionType() {
        if (this.transactionType == null) {
            this.transactionType = CONTAINER_TRANSACTION_TYPE;
        }
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        if (!CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionentitybeancanonlyhavecntnrtxtype", "Entity beans can only have Container transaction type. The type was being set to {0}", new Object[]{transactionType}));
            }
        }
        this.transactionType = transactionType;
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    public String isReentrantAsString() {
        return this.isReentrantAsString == null ? Boolean.toString(this.isReentrant) : this.isReentrantAsString;
    }

    public void setReentrant(String reentrantString) {
        if (reentrantString.toLowerCase().equals("true")) {
            this.isReentrant = true;
            this.isReentrantAsString = reentrantString;
        } else if (reentrantString.toLowerCase().equals("false")) {
            this.isReentrant = false;
            this.isReentrantAsString = reentrantString;
        } else if (this.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionstringnotlegalvalue", "{0} is not a legal value for entity reentrancy", new Object[]{reentrantString}));
        }
        super.changed();
    }

    public void setReentrant(boolean isReentrant) {
        this.setReentrant(isReentrant ? "true" : "false");
    }

    public String getPersistenceType() {
        if (this.persistenceType == null) {
            this.persistenceType = BEAN_PERSISTENCE;
        }
        return this.persistenceType;
    }

    public void setPersistenceType(String persistenceType) {
        boolean isValidChange;
        boolean bl = isValidChange = BEAN_PERSISTENCE.equals(persistenceType) || CONTAINER_PERSISTENCE.equals(persistenceType);
        if (!isValidChange) {
            if (!this.isBoundsChecking()) {
            } else {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionpersistenceisnotallowedtype", "{0} is not an allowed persistence type", new Object[]{persistenceType}));
            }
        }
        this.persistenceType = persistenceType;
        super.changed();
    }

    public String getPrimaryKeyClassName() {
        if (this.primaryKeyClassName == null) {
            this.primaryKeyClassName = Object.class.getName();
        }
        return this.primaryKeyClassName;
    }

    public void setPrimaryKeyClassName(String primaryKeyClassName) {
        this.primaryKeyClassName = primaryKeyClassName;
        super.changed();
    }

    public String getType() {
        return TYPE;
    }

    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeonentitybean", "Cannon set type on an entity bean"));
    }

    public String toString() {
        String s = super.toString();
        s = s + "\n Entity descriptor";
        s = s + "\n isReentrant " + this.isReentrant;
        s = s + "\n primaryKeyClassName " + this.primaryKeyClassName;
        s = s + "\n persistenceType " + this.persistenceType;
        return s;
    }
}

