/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.CodeGeneratingVisitor;
import com.sun.ejb.ejbql.EjbQLParseException;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.RuntimeInfoVisitor;
import com.sun.ejb.ejbql.SymbolTable;
import com.sun.ejb.ejbql.parser.EjbQLParser;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import java.lang.reflect.Method;

public class EjbQLDriver {
    private EjbBundleDescriptor ejbBundle_;
    private SymbolTable symbolTable_;

    public EjbQLDriver(EjbBundleDescriptor ejbBundle) throws EjbQLParseException {
        this.ejbBundle_ = ejbBundle;
        this.symbolTable_ = new SymbolTable(ejbBundle);
    }

    public EjbQLQuery parse(String ejbName, String homeClassName, String methodName, String query) {
        EjbBundleDescriptor ejbBundle = this.ejbBundle_;
        EjbCMPEntityDescriptor descriptor = null;
        descriptor = (EjbCMPEntityDescriptor)ejbBundle.getEjbByName(ejbName);
        EjbBundleArchivist archivist = (EjbBundleArchivist)ejbBundle.getArchivist();
        ClassLoader classLoader = archivist.getClassLoader();
        Method queryMethod = null;
        if (homeClassName != null) {
            try {
                Class<?> homeClass = classLoader.loadClass(homeClassName);
                queryMethod = EjbQLParser.lookupQueryMethod(homeClass.getDeclaredMethods(), methodName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.out);
            }
        }
        String ejbBeanName = descriptor.getEjbClassName();
        if (queryMethod == null) {
            try {
                Class<?> ejbClass = classLoader.loadClass(ejbBeanName);
                queryMethod = EjbQLParser.lookupQueryMethod(ejbClass.getDeclaredMethods(), methodName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.out);
            }
        }
        if (queryMethod == null) {
            // empty if block
        }
        try {
            PersistenceDescriptor pd = descriptor.getPersistenceDescriptor();
            EjbQLQuery ejbQLQuery = this.parse(pd, queryMethod, query);
            String sql = this.generateSql(ejbQLQuery);
            return ejbQLQuery;
        }
        catch (Exception e) {
            return null;
        }
    }

    public EjbQLQuery parse(PersistenceDescriptor descriptor, Method queryMethod, String queryString) throws EjbQLParseException {
        return EjbQLParser.parse(this.symbolTable_, descriptor, queryMethod, queryString);
    }

    public String generateSql(EjbQLQuery query) throws Exception {
        CodeGeneratingVisitor codeGenerator = new CodeGeneratingVisitor(query);
        return codeGenerator.generateSql();
    }

    public RuntimeInfoVisitor getRuntimeInfo(EjbQLQuery query) throws Exception {
        RuntimeInfoVisitor runtimeInfoVisitor = new RuntimeInfoVisitor(query);
        runtimeInfoVisitor.generateRuntimeInfo();
        return runtimeInfoVisitor;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        return this.ejbBundle_;
    }
}

