/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.corba.ee.impl.orb;

import com.oracle.corba.ee.impl.orb.config.ORBConfig;
import com.oracle.corba.ee.spi.orb.ORBProvider;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.oc4j.corba.transport.CorbaTransportManager;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

public abstract class ORBProviderImplBase
implements ORBProvider {
    private ORB m_orb = null;
    private Logger m_log = Logger.getLogger("oc4j.orb.logger");
    private boolean m_isShutdown = false;
    private Thread m_thread;

    public ORB createORB(ORBConfig config) throws InvalidName, InvalidName {
        try {
            Properties props = config.getORBProperties();
            String[] args = config.getORBArguments();
            this.m_orb = ORB.init((String[])args, (Properties)props);
        }
        catch (Exception e) {
            this.m_log.severe("Error initializing ORB due to exception " + e);
            throw new IllegalStateException("Error initializing ORB");
        }
        this.setShutdown(false);
        this.m_thread = new Thread(new Runnable(){

            public void run() {
                while (!ORBProviderImplBase.this.isShutdown()) {
                    try {
                        ORBProviderImplBase.this.m_orb.run();
                    }
                    catch (Exception e) {
                        ORBProviderImplBase.this.m_log.severe("Unable to run ORB object due to exception " + e);
                        throw new IllegalStateException("Unable to run ORB object due to exception " + e);
                    }
                }
            }
        });
        this.m_thread.setDaemon(true);
        this.m_thread.start();
        return this.m_orb;
    }

    private boolean isShutdown() {
        return this.m_isShutdown;
    }

    private void setShutdown(boolean isShutdown) {
        this.m_isShutdown = isShutdown;
    }

    public void shutdownORB() {
        if (this.m_orb != null) {
            this.setShutdown(true);
            if (this.m_thread != null) {
                try {
                    this.m_thread.join(1000L);
                    this.m_thread = null;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                this.m_orb.shutdown(true);
            }
            catch (Exception e) {
                this.m_log.warning("Error encountered while shutting down ORB: " + e);
            }
            this.m_orb.destroy();
            this.m_orb = null;
            CorbaTransportManager.getInstance().reinit();
        }
    }
}

