/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.corba.ee.impl.orb;

import com.oracle.corba.ee.impl.orb.SunRIORBProviderImpl;
import com.oracle.corba.ee.impl.orb.config.ORBConfig;
import com.oracle.corba.ee.spi.orb.ORBProvider;
import com.sun.corba.ee.impl.legacy.connection.EndPointInfoImpl;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import java.net.Socket;
import java.rmi.Remote;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.rmi.CORBA.Tie;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.POAPolicyCreationStrategy;
import oracle.oc4j.corba.iiop.IIOPSSLSocketFactory;
import oracle.oc4j.corba.iiop.security.ClientSecurityMechanismSelector;
import oracle.oc4j.corba.iiop.security.SecurityMechanismSelector;
import oracle.oc4j.corba.orb.OrbManager;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;

public class ORBManagerImpl
extends OrbManager {
    private ORB m_orb;
    private ORBConfig m_orbConfig;
    private ORBConfig m_clientOrbConfig;
    private static ORBManagerImpl s_OrbManagerImpl;
    private ORBProvider m_orbProvider = new SunRIORBProviderImpl();
    private static Logger traceLogger;

    private ORBManagerImpl() {
    }

    public static ORBManagerImpl getORBManager() {
        if (s_OrbManagerImpl == null) {
            s_OrbManagerImpl = new ORBManagerImpl();
        }
        return s_OrbManagerImpl;
    }

    private void createORB() throws ORBConfigurationException {
        if (this.m_orbConfig == null) {
            throw new IllegalStateException("ORB Configuration has not been set");
        }
        try {
            this.m_orb = this.m_orbProvider.createORB(this.m_orbConfig);
        }
        catch (InvalidName e) {
            throw new ORBConfigurationException(e);
        }
    }

    public void setORBConfig(ORBConfig config) throws ORBConfigurationException {
        if (this.m_orbConfig == null) {
            this.m_orbConfig = config;
            this.m_orbProvider = this.getORBProvider();
        } else {
            traceLogger.warning("ORB configuration already set.  Ignoring new configuration");
        }
    }

    private ORBProvider getORBProvider() {
        ORBProvider provider = new SunRIORBProviderImpl();
        if (this.m_orbConfig != null) {
            try {
                provider = (ORBProvider)Class.forName(this.m_orbConfig.getORBProviderClass()).newInstance();
            }
            catch (Exception e) {
                traceLogger.throwing(this.getClass().getName(), "getORBProvider", e);
            }
        }
        return provider;
    }

    public ORBConfig getORBConfig() {
        return this.m_orbConfig;
    }

    public ORBConfig getClientORBConfig() {
        if (this.m_orbProvider != null && this.m_clientOrbConfig == null) {
            this.m_clientOrbConfig = this.m_orbProvider.getClientORBConfiguration();
        }
        return this.m_clientOrbConfig;
    }

    public ORB getORBReference() throws ORBConfigurationException {
        if (this.m_orbConfig == null) {
            this.m_orb = super.getORBReference();
        }
        if (this.m_orb == null) {
            this.createORB();
        }
        return this.m_orb;
    }

    public void shutdown() {
        if (this.m_orbProvider != null) {
            this.m_orbProvider.shutdownORB();
        }
        this.m_orbConfig = null;
        this.m_orb = null;
    }

    public POAPolicyCreationStrategy getPOAPolicyCreationStrategy() {
        return this.m_orbConfig.getPOAPolicyCreationStrategy();
    }

    public Tie getTie(Remote remote) {
        return this.m_orbProvider.loadTie(remote);
    }

    protected Socket getSocket(ClientRequestInfo cri) {
        return this.m_orbProvider.getSocket(cri);
    }

    protected TaggedComponent getComponent(Object o) {
        return this.m_orbProvider.getComponent(o);
    }

    protected Iterator getMechList(Object ior) {
        return this.m_orbProvider.getMechList(ior);
    }

    protected CompoundSecMech[] getCompoundSecList(byte[] b) {
        return this.m_orbProvider.getCompoundSecList(b);
    }

    protected TLS_SEC_TRANS getTlsSecTrans(byte[] b) {
        return this.m_orbProvider.getTlsSecTrans(b);
    }

    protected void setSocketFactoryProperty(Properties props) {
        if (!props.containsKey("com.sun.CORBA.connection.ORBSocketFactoryClass")) {
            props.setProperty("com.sun.CORBA.connection.ORBSocketFactoryClass", IIOPSSLSocketFactory.class.getName());
        }
    }

    protected void setORBClassProperty(Properties props) {
        if (!props.containsKey("org.omg.CORBA.ORBClass")) {
            props.setProperty("org.omg.CORBA.ORBClass", "com.sun.corba.ee.impl.orb.ORBImpl");
        }
    }

    protected void setORBSingletonClassProperty(Properties props) {
        if (!props.containsKey("org.omg.CORBA.ORBSingletonClass")) {
            props.setProperty("org.omg.CORBA.ORBSingletonClass", "com.sun.corba.ee.impl.orb.ORBSingleton");
        }
    }

    protected void setManagers(KeyManager[] k, TrustManager[] t) {
        IIOPSSLSocketFactory.setManagers(k, t);
    }

    public Object createEndPointInfoImpl(String type, int port, String hostname) {
        return new EndPointInfoImpl(type, port, hostname);
    }

    protected ClientSecurityMechanismSelector getSecMechSelector() {
        boolean isOrbConfigNotNull = this.m_orbConfig != null;
        traceLogger.log(Level.FINEST, "isOrbConfigNotNull: " + isOrbConfigNotNull);
        return isOrbConfigNotNull ? new SecurityMechanismSelector() : new ClientSecurityMechanismSelector();
    }

    static {
        OrbManager.setManager(ORBManagerImpl.getORBManager());
        traceLogger = TraceLogger.getLogger(ORBManagerImpl.class);
    }
}

