/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee.test;

import com.oracle.bricks.j2ee.Session;
import com.oracle.bricks.j2ee.SessionManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class Worker
implements Runnable {
    private Session session;
    private int sessionId = 0;
    private SessionManager manager;
    private int worker;
    private Random random = new Random();
    private int piecesOfJunk = 5;
    private int junkSize = 10;
    private int maxSessionSize = 100;
    private int maxSessionLifetime = 120000;
    private int maxClientThinkTime = 3000;
    private int maxAppTime = 10;
    private int maxList = 10;
    private int flushInterval = -1;
    private static Logger log = TraceLogger.getLogger(Worker.class);

    public Worker(int worker, SessionManager manager) {
        this.manager = manager;
        this.worker = worker;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            try {
                block9: while (true) {
                    try {
                        this.session = this.manager.create((Serializable)(this.sessionId++ + ":" + this.worker + "@" + this.manager.getAddress()));
                    }
                    catch (Exception e) {
                        Worker.log.log(Level.FINER, "Error creating session", e);
                        continue;
                    }
                    this.session.setMaxInactiveTime(this.maxSessionLifetime);
                    lifetime = (int)Math.round(Math.random() * (double)this.maxSessionLifetime);
                    sessionTime = System.currentTimeMillis() + (long)lifetime;
                    Worker.log.log(Level.FINEST, "LiveSession: " + this.session.getId() + " lifetime: " + lifetime);
                    while (true) {
                        if (System.currentTimeMillis() < sessionTime) ** break;
                        continue block9;
                        try {
                            thinkTime = Math.round(Math.random() * (double)this.maxClientThinkTime);
                            Worker.log.info("client thinking " + thinkTime + " milliseconds");
                            Thread.sleep(thinkTime);
                        }
                        catch (InterruptedException e) {
                            Worker.log.log(Level.FINER, " thread interrupted");
                        }
                        inBoxSize = (int)Math.round(Math.random() * (double)this.maxList);
                        for (i = 0; i < inBoxSize; ++i) {
                            try {
                                Thread.sleep(Math.round(Math.random() * (double)this.maxAppTime));
                            }
                            catch (InterruptedException e) {
                                Worker.log.log(Level.FINER, " thread interrupted");
                                return;
                            }
                            if (this.random.nextBoolean()) {
                                this.getRandomAttribute();
                                continue;
                            }
                            if ((double)this.random.nextFloat() > 0.25) {
                                this.modifyRandomAttribute();
                                continue;
                            }
                            this.removeRandomAttribute();
                        }
                        if (this.flushInterval != -1) continue;
                        this.session.flush();
                    }
                    break;
                }
            }
            catch (Throwable e) {
                Worker.log.log(Level.FINER, "Caught", e);
                continue;
            }
            break;
        }
    }

    private void modifyRandomAttribute() {
        Serializable value = this.randomValue();
        long time = System.currentTimeMillis();
        try {
            this.session.put(this.keyOf((int)Math.round(Math.random() * (double)this.maxSessionSize)), value);
        }
        catch (Exception e) {
            log.log(Level.FINER, "exception modifying attribute", e);
        }
        time = System.currentTimeMillis() - time;
        log.log(Level.FINEST, "modified in " + time + " milliseconds");
    }

    private void removeRandomAttribute() {
        Iterator keys = null;
        try {
            keys = this.session.keyList().iterator();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        if (keys.hasNext()) {
            long time = System.currentTimeMillis();
            try {
                this.session.remove((Serializable)keys.next());
            }
            catch (Exception e) {
                log.log(Level.FINER, "exception removing attribute", e);
            }
            time = System.currentTimeMillis() - time;
            log.log(Level.FINEST, "remove in " + time + " milliseconds");
        }
    }

    private void getRandomAttribute() {
        Iterator keys = null;
        try {
            keys = this.session.keyList().iterator();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        if (keys.hasNext()) {
            long time = System.currentTimeMillis();
            try {
                this.session.get((Serializable)keys.next());
            }
            catch (Exception e) {
                log.log(Level.FINER, "exception getting attribute", e);
            }
            time = System.currentTimeMillis() - time;
            log.log(Level.FINEST, "remove in " + time + " milliseconds");
        }
    }

    private Serializable keyOf(int i) {
        return new Integer(i);
    }

    private Serializable randomValue() {
        HashMap<Serializable, Map> value = new HashMap<Serializable, Map>();
        int num = (int)Math.round(Math.random() * (double)this.piecesOfJunk);
        for (int i = 0; i < num; ++i) {
            value.put(this.keyOf(i), this.randomJunk());
        }
        return value;
    }

    private Map randomJunk() {
        HashMap<Serializable, byte[]> map = new HashMap<Serializable, byte[]>();
        int randomSize = (int)Math.round(Math.random() * (double)this.junkSize);
        for (int i = 0; i < randomSize; ++i) {
            map.put(this.keyOf(i), new byte[i]);
        }
        return map;
    }
}

