/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.LoggerContext;
import java.util.Properties;

public class MemoryLogger
implements Logger {
    private transient LoggerContext context;
    private int logMaxLength = 20;
    private LogEvent[] events = new LogEvent[this.logMaxLength];
    private boolean isFull = false;
    private int logPointer = 0;

    public synchronized void log(LogEvent event) {
        if (this.logPointer == this.events.length) {
            this.isFull = true;
            this.logPointer = 0;
        }
        this.events[this.logPointer] = event;
        ++this.logPointer;
    }

    public void setContext(LoggerContext context) {
        this.context = context;
    }

    public synchronized LogEvent[] getEvents() {
        LogEvent[] shippedEvents = null;
        if (this.isFull) {
            shippedEvents = new LogEvent[this.events.length];
            int logIndex = (this.logPointer + 1) % this.events.length;
            for (int i = 0; i < shippedEvents.length; ++i) {
                shippedEvents[i] = this.events[logIndex].getSerializableVersion();
                logIndex = (logIndex + 1) % this.events.length;
            }
        } else {
            shippedEvents = new LogEvent[this.logPointer];
            for (int i = 0; i < shippedEvents.length; ++i) {
                shippedEvents[i] = this.events[i].getSerializableVersion();
            }
        }
        return shippedEvents;
    }

    public void setLogTimestamp(boolean logTimestamp) {
    }

    public void close() {
    }

    public void init(Properties properties) {
    }
}

