/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.util.Map;
import oracle.oc4j.api.MetricCollector;

public class LatencyMetricCollector
implements MetricCollector {
    public static final String KEY_MEDIAN_LATENCY_MILLIS = "median-latency";
    public static final int DEFAULT_MEDIAN_LATENCY_MILLIS = 500;
    private int m_medianLatencyMillis = 500;
    public static final String KEY_HISTORY_PROPORTION = "history-proportion";
    public static final float DEFAULT_HISTORY_PROPORTION = 0.33333334f;
    private float m_historyProportion = 0.33333334f;
    private static final LatencyMetricCollector m_instance = new LatencyMetricCollector();
    private boolean m_enabled = false;
    private long m_sumOfLatencies = 0L;
    private int m_numberOfMeasurements;
    private int m_previousMetric = INITIAL_METRIC;

    public static LatencyMetricCollector getInstance() {
        return m_instance;
    }

    private LatencyMetricCollector() {
        if (DEBUG) {
            System.out.println("LatencyMetricCollector Constructor, enabled=" + this.m_enabled);
        }
    }

    public void setParameters(Map params) {
        String medianLatencyString = (String)params.get(KEY_MEDIAN_LATENCY_MILLIS);
        if (DEBUG) {
            System.out.println("LatencyMetricCollector: parameter median-latency is " + medianLatencyString);
        }
        if (medianLatencyString != null) {
            try {
                int medianLatency = Integer.parseInt(medianLatencyString);
                if (medianLatency <= 0) {
                    System.err.println("LatencyMetricCollector: parameter " + medianLatencyString + " is incorrect (should be a positive integer value");
                    return;
                }
                this.m_medianLatencyMillis = medianLatency;
            }
            catch (NumberFormatException e) {
                System.err.println("LatencyMetricCollector: parameter " + medianLatencyString + " is incorrect (should be a positive integer value)");
            }
        }
        String historyProportionString = (String)params.get(KEY_HISTORY_PROPORTION);
        if (DEBUG) {
            System.out.println("LatencyMetricCollector: parameter history-proportion is " + historyProportionString);
        }
        if (historyProportionString != null) {
            try {
                float historyProportion = Float.parseFloat(historyProportionString);
                if (historyProportion <= 0.0f) {
                    System.err.println("LatencyMetricCollector: parameter " + historyProportionString + " is incorrect (should be a floating point value between 0.0 and 1.0)");
                    return;
                }
                this.m_historyProportion = historyProportion;
            }
            catch (NumberFormatException e) {
                System.err.println("LatencyMetricCollector: parameter " + historyProportionString + " is incorrect (should be a floating point value between 0.0 and 1.0)");
            }
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (DEBUG) {
            System.out.println("LatencyMetricCollector.setEnabled to " + enabled);
        }
        this.m_enabled = enabled;
    }

    void addMeasurement(long latency) {
        this.m_sumOfLatencies += latency;
        ++this.m_numberOfMeasurements;
    }

    public int getMetric() {
        if (this.m_numberOfMeasurements == 0) {
            if (DEBUG) {
                System.out.println("Metric: No measurements available, returning previous value:" + this.m_previousMetric);
            }
            return this.m_previousMetric;
        }
        float averageLatencySec = (float)this.m_sumOfLatencies / (float)this.m_numberOfMeasurements;
        int metricThisRound = Math.round(100.0f / (1.0f + averageLatencySec / (float)this.m_medianLatencyMillis));
        int returnedMetric = Math.round((1.0f - this.m_historyProportion) * (float)metricThisRound + this.m_historyProportion * (float)this.m_previousMetric);
        if (DEBUG) {
            System.out.println("Metric: current average latency(ms)=" + averageLatencySec);
            System.out.println("Metric: previous metric=" + this.m_previousMetric);
            System.out.println("Metric: metric this round=" + metricThisRound);
        }
        this.m_previousMetric = returnedMetric;
        this.m_numberOfMeasurements = 0;
        this.m_sumOfLatencies = 0L;
        return returnedMetric;
    }
}

