/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Bag
extends AbstractCollection {
    int[] itemQuantity;
    Object[] item = new Object[10];
    int nrOfItems;

    public Bag() {
        this.itemQuantity = new int[10];
    }

    public Bag(Collection collection) {
        this();
        this.addAll(collection);
    }

    public boolean add(Object object) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (!this.item[i].equals(object)) continue;
            int n = i;
            this.itemQuantity[n] = this.itemQuantity[n] + 1;
            return true;
        }
        this.ensureCapacity(this.nrOfItems + 1);
        this.item[this.nrOfItems] = object;
        this.itemQuantity[this.nrOfItems++] = 1;
        return true;
    }

    public void ensureCapacity(int size) {
        if (this.item.length <= size) {
            Object[] oldItems = this.item;
            int[] oldQuantities = this.itemQuantity;
            this.item = new Object[size + 10];
            this.itemQuantity = new int[size + 10];
            System.arraycopy(oldItems, 0, this.item, 0, this.nrOfItems);
            System.arraycopy(oldQuantities, 0, this.itemQuantity, 0, this.nrOfItems);
        }
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof Bag) {
            Bag other = (Bag)collection;
            for (int x = 0; x < other.nrOfItems; ++x) {
                int i;
                for (i = 0; i < this.nrOfItems; ++i) {
                    if (!this.item[i].equals(other.item[x])) continue;
                    int n = i;
                    this.itemQuantity[n] = this.itemQuantity[n] + other.itemQuantity[x];
                    break;
                }
                if (i != this.nrOfItems) continue;
                this.ensureCapacity(this.nrOfItems + 1);
                this.item[this.nrOfItems] = other.item[x];
                this.itemQuantity[this.nrOfItems++] = other.itemQuantity[x];
            }
            return true;
        }
        return super.addAll(collection);
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (!this.item[i].equals(object)) continue;
            int n = i;
            this.itemQuantity[n] = this.itemQuantity[n] - 1;
            if (this.itemQuantity[n] <= 0) {
                this.removeIndex(i);
            }
            return true;
        }
        return false;
    }

    private void removeIndex(int i) {
        this.itemQuantity[i] = this.itemQuantity[--this.nrOfItems];
        this.item[i] = this.item[this.nrOfItems];
    }

    public Iterator iterator() {
        return new BagIterator(this);
    }

    public int size() {
        return this.nrOfItems;
    }

    private class BagIterator
    implements Iterator {
        Bag bag;
        int index;
        int quantityIndex;

        public BagIterator(Bag bag) {
            this.bag = bag;
        }

        public Object next() {
            if (this.quantityIndex >= this.bag.itemQuantity[this.index]) {
                this.quantityIndex = 0;
                ++this.index;
            }
            if (this.index >= this.bag.nrOfItems) {
                throw new NoSuchElementException();
            }
            ++this.quantityIndex;
            return this.bag.item[this.index];
        }

        public void remove() {
            int n = this.index;
            this.bag.itemQuantity[n] = this.bag.itemQuantity[n] - 1;
            if (this.bag.itemQuantity[n] == 0) {
                Bag.this.removeIndex(this.index);
            }
        }

        public boolean hasNext() {
            return this.index < this.bag.nrOfItems && (this.quantityIndex < this.bag.itemQuantity[this.index] || this.index != this.bag.nrOfItems - 1);
        }
    }
}

