/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.sql;

import com.evermind.sql.SerializableRowSet;
import com.evermind.sql.SerializableRowSetColumn;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SerializableRowSetMetaData
implements ResultSetMetaData,
Serializable {
    public static final long serialVersionUID = 2676799332747648091L;
    private SerializableRowSet rowSet;
    protected SerializableRowSetColumn[] columnData;

    public SerializableRowSetMetaData(SerializableRowSet rowSet, ResultSetMetaData metaData) throws SQLException {
        this.rowSet = rowSet;
        this.columnData = new SerializableRowSetColumn[metaData.getColumnCount()];
        for (int i = 0; i < this.columnData.length; ++i) {
            this.columnData[i] = new SerializableRowSetColumn();
            this.columnData[i].name = metaData.getColumnName(i + 1);
            try {
                this.columnData[i].tableName = metaData.getTableName(i + 1);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public String getColumnTypeName(int column) {
        return this.columnData[column - 1].type;
    }

    public String getColumnName(int column) {
        return this.columnData[column - 1].name;
    }

    public String getSchemaName() {
        return null;
    }

    public int getPrecision(int pos) {
        return -1;
    }

    public int getScale(int pos) {
        return -1;
    }

    public String getTableName(int column) {
        return this.columnData[column - 1].tableName;
    }

    public boolean isReadOnly(int pos) {
        return true;
    }

    public boolean isSigned(int column) {
        return false;
    }

    public int isNullable(int column) {
        return -1;
    }

    public String getCatalogName(int column) {
        return null;
    }

    public int getColumnDisplaySize(int column) {
        return -1;
    }

    public String getColumnClassName(int column) {
        return "java.lang.Object";
    }

    public boolean isCaseSensitive(int column) {
        return true;
    }

    public boolean isAutoIncrement(int column) {
        return false;
    }

    public boolean isSearchable(int column) {
        return false;
    }

    public boolean isCurrency(int type) {
        return false;
    }

    public boolean isWritable(int column) {
        return false;
    }

    public int getColumnCount() {
        return this.columnData.length;
    }

    public String getSchemaName(int column) {
        return null;
    }

    public int getColumnType(int column) {
        return -1;
    }

    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    public String getColumnLabel(int column) {
        return this.columnData[column - 1].name;
    }
}

