/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.BoundObject;
import com.evermind.server.rmi.RMIInterfaceType;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.Replaceable;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.Remote;

public class RMIServerOutputStream
extends RMIOutputStream {
    private ServerRmiMessageHandler m_handler;
    private Object m_mainObject;
    private String m_mainName;
    private SentTypes m_sentTypes = new SentTypes();

    public RMIServerOutputStream(OutputStream out, ServerRmiMessageHandler handler) throws IOException {
        super(out);
        this.m_handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMainObject(Object object, String name) throws IOException {
        this.m_mainObject = object;
        this.m_mainName = name;
        try {
            this.writeObject(object);
            Object var4_3 = null;
            this.m_mainObject = null;
            this.m_mainName = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mainObject = null;
            this.m_mainName = null;
            throw throwable;
        }
    }

    protected Object replaceObject(Object object) throws IOException {
        if (object instanceof Replaceable) {
            return ((Replaceable)object).getReplacement();
        }
        if (object instanceof Remote) {
            return this.replaceWithOrmiProxy(object);
        }
        return super.replaceObject(object);
    }

    Object replaceWithOrmiProxy(Object object) {
        BoundObject bound = this.m_handler.bindObject(object);
        return bound.createObjectInfo(this.m_sentTypes.getTypeToSend(bound), this.m_mainName, this.m_mainObject);
    }

    static class SentTypes {
        private int sentTypesLength = 0;
        private RMIInterfaceType[] sentTypes = new RMIInterfaceType[10];

        SentTypes() {
        }

        private RMIInterfaceType getSentType(int typeID) {
            return this.sentTypes[typeID];
        }

        private RMIInterfaceType addSentType(Class aClass) {
            if (this.sentTypesLength >= this.sentTypes.length) {
                RMIInterfaceType[] oldTypes = this.sentTypes;
                this.sentTypes = new RMIInterfaceType[oldTypes.length * 2];
                System.arraycopy(oldTypes, 0, this.sentTypes, 0, oldTypes.length);
            }
            RMIInterfaceType newType = new RMIInterfaceType(aClass);
            RMIInterfaceType rMIInterfaceType = newType;
            this.sentTypes[this.sentTypesLength++] = rMIInterfaceType;
            return rMIInterfaceType;
        }

        private int getSentTypeId(Class type) {
            try {
                for (int i = this.sentTypesLength - 1; i >= 0; --i) {
                    if (!this.sentTypes[i].matchesType(type)) continue;
                    return i;
                }
                return -1;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error in getSentTypeID: " + t + ", type: " + type + ", sentTypes: " + this.sentTypes + " sentTypesLength: " + (this.sentTypes == null ? 0 : this.sentTypes.length) + ", sentLength II: " + this.sentTypesLength);
            }
        }

        int getTypeToSend(BoundObject bound) {
            int typeID = this.getSentTypeId(bound.getObject().getClass());
            if (typeID < 0) {
                bound.setType(this.addSentType(bound.getObject().getClass()));
            } else {
                bound.setType(this.getSentType(typeID));
            }
            return typeID;
        }
    }
}

