/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.Application;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.JndiNamespaceReplicationService;
import com.evermind.server.rmi.RMIBinding;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.naming.NamingException;
import oracle.j2ee.clustering.ChannelAdapterFactory;
import oracle.j2ee.clustering.ClusteringMessageDispatcher;
import oracle.j2ee.clustering.CustomMessage;
import oracle.j2ee.clustering.CustomMessageHandler;
import oracle.j2ee.clustering.JGroupsMessageDispatcher;
import oracle.j2ee.clustering.JndiChannelAdapterFactory;
import oracle.j2ee.clustering.MessageDispatchException;
import oracle.j2ee.clustering.OC4JChannelAdapterFactory;
import oracle.j2ee.jndi.ContextValueUpdateMessage;
import oracle.j2ee.jndi.JndiMessage;
import oracle.j2ee.jndi.RenameMessage;
import oracle.j2ee.jndi.UnbindMessage;
import oracle.j2ee.util.TraceLogger;

public class JGroupJndiNamespaceReplicationService
implements JndiNamespaceReplicationService {
    private static final String MESSAGE_PUBLISHING_ERROR_MSG = "Message publishing attempt failed";
    private static final String NULL_GROUP_NAME_MSG = "Group name specified was not part of the list of registered groups, returning without publishing a message";
    private static final String DEFAULT_APPLICATION_NAME = "default";
    private ChannelAdapterFactory m_adapterFactory = null;
    private ClusteringMessageDispatcher m_msgDispatcher = null;
    private static Logger m_logger = TraceLogger.getLogger(JGroupJndiNamespaceReplicationService.class);
    private Map m_mapOfApplicationNamesToGroupNames = new HashMap();
    private Map m_mapOfApplicationNamesToHandlers = new HashMap();

    public JGroupJndiNamespaceReplicationService() {
        boolean isChannelSharingEnabled = System.getProperty("oc4j.jndi.replication.useSharedChannel", "true").equals("true");
        this.m_adapterFactory = isChannelSharingEnabled ? new OC4JChannelAdapterFactory() : new JndiChannelAdapterFactory();
        this.m_msgDispatcher = new JGroupsMessageDispatcher(this.m_adapterFactory);
    }

    JGroupJndiNamespaceReplicationService(ClusteringMessageDispatcher msgDispatcher, ChannelAdapterFactory adapterFactory) {
        this.m_msgDispatcher = msgDispatcher;
        this.m_adapterFactory = adapterFactory;
    }

    public void sendContextValueUpdate(String domain, String name, RMIBinding binding) throws IOException, NamingException {
        String applicationName = domain;
        if (this.m_msgDispatcher != null) {
            try {
                String groupName = this.getGroupName(applicationName);
                if (groupName != null) {
                    ContextValueUpdateMessage messageToSend = new ContextValueUpdateMessage(applicationName, name, binding.getSerializable(), binding.getDistributionMode());
                    this.m_msgDispatcher.publishMessage(groupName, messageToSend);
                } else {
                    m_logger.finest(NULL_GROUP_NAME_MSG);
                }
            }
            catch (MessageDispatchException messageDispatchException) {
                IOException ioException = new IOException(MESSAGE_PUBLISHING_ERROR_MSG);
                ioException.initCause(messageDispatchException);
                throw ioException;
            }
        }
    }

    public void sendUnbind(String domain, String name) throws IOException, NamingException {
        String applicationName = domain;
        UnbindMessage messageToSend = new UnbindMessage(applicationName, name);
        if (this.m_msgDispatcher != null) {
            try {
                String groupName = this.getGroupName(applicationName);
                if (groupName != null) {
                    this.m_msgDispatcher.publishMessage(groupName, messageToSend);
                } else {
                    m_logger.finest(NULL_GROUP_NAME_MSG);
                }
            }
            catch (MessageDispatchException messageDispatchException) {
                IOException ioException = new IOException(MESSAGE_PUBLISHING_ERROR_MSG);
                ioException.initCause(messageDispatchException);
                throw ioException;
            }
        }
    }

    public void sendRename(String domain, String oldName, String newName) throws IOException {
        String applicationName = domain;
        RenameMessage messageToSend = new RenameMessage(applicationName, oldName, newName);
        if (this.m_msgDispatcher != null) {
            try {
                String groupName = this.getGroupName(applicationName);
                if (groupName != null) {
                    this.m_msgDispatcher.publishMessage(groupName, messageToSend);
                } else {
                    m_logger.finest(NULL_GROUP_NAME_MSG);
                }
            }
            catch (MessageDispatchException messageDispatchException) {
                IOException ioException = new IOException(MESSAGE_PUBLISHING_ERROR_MSG);
                ioException.initCause(messageDispatchException);
                throw ioException;
            }
        }
    }

    public void registerApplication(String groupName, Application application) {
        if (this.m_msgDispatcher != null) {
            this.m_mapOfApplicationNamesToGroupNames.put(application.getName(), groupName);
            this.m_adapterFactory.addChannelAdapter(groupName, application.getConfig().getClusterConfig());
            JndiMessageHandler handler = new JndiMessageHandler(application);
            try {
                this.m_msgDispatcher.registerMessageHandler(groupName, handler);
                this.m_mapOfApplicationNamesToHandlers.put(application.getName(), handler);
            }
            catch (MessageDispatchException messageDispatchException) {
                m_logger.log(Level.FINE, "Exception encountered while registering handler with dispatcher", messageDispatchException);
            }
        }
    }

    public void unRegisterApplication(String groupName, Application application) {
        if (this.m_msgDispatcher != null) {
            String mappedGroupName = (String)this.m_mapOfApplicationNamesToGroupNames.get(application.getName());
            if (groupName.equals(mappedGroupName)) {
                this.m_mapOfApplicationNamesToGroupNames.remove(application.getName());
                this.m_adapterFactory.removeChannelAdapter(groupName);
                JndiMessageHandler handler = (JndiMessageHandler)this.m_mapOfApplicationNamesToHandlers.remove(application.getName());
                try {
                    this.m_msgDispatcher.unRegisterMessageHandler(groupName, handler);
                }
                catch (MessageDispatchException messageDispatchException) {
                    m_logger.log(Level.FINE, "Exception encountered when attempting to unRegister an application", messageDispatchException);
                }
            } else {
                m_logger.fine("Attempt to unregister an application with a different group than was originally registered, returning without unRegistering");
            }
        }
    }

    public void receive(Message message) {
    }

    public ServerIdentification[] getKnownPeers() {
        if (this.m_msgDispatcher != null) {
            String mappedGroupName = (String)this.m_mapOfApplicationNamesToGroupNames.get(DEFAULT_APPLICATION_NAME);
            return this.m_msgDispatcher.getKnownPeers(mappedGroupName);
        }
        return new ServerIdentification[0];
    }

    private String getGroupName(String applicationName) {
        return (String)this.m_mapOfApplicationNamesToGroupNames.get(applicationName);
    }

    static class JndiMessageHandler
    implements CustomMessageHandler {
        private Application m_application = null;

        public JndiMessageHandler(Application application) {
            this.m_application = application;
        }

        public void handleMessage(CustomMessage message) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.finest("Message received for application name = " + this.m_application.getName() + "msg = " + message);
            }
            if (message instanceof JndiMessage) {
                this.handleJndiMessage((JndiMessage)message);
            }
        }

        private void handleJndiMessage(JndiMessage jndiMessage) {
            if (jndiMessage instanceof UnbindMessage) {
                this.handleUnbindMessage((UnbindMessage)jndiMessage);
            } else if (jndiMessage instanceof RenameMessage) {
                this.handleRenameMessage((RenameMessage)jndiMessage);
            } else if (jndiMessage instanceof ContextValueUpdateMessage) {
                this.handleContextValueUpdateMessage((ContextValueUpdateMessage)jndiMessage);
            }
        }

        private void handleContextValueUpdateMessage(ContextValueUpdateMessage contextValueUpdateMessage) {
            String msgApplication = contextValueUpdateMessage.getApplicationName();
            String bindingName = contextValueUpdateMessage.getBindingName();
            if (this.m_application.getName().equals(msgApplication)) {
                RMIServerContext context = this.m_application.getContext().getRMIContext();
                RMIServer rmiServer = this.m_application.getServer().getRMIServer();
                if (context != null) {
                    context.putBinding(bindingName, rmiServer.newBinding(contextValueUpdateMessage.getBindingValue(), contextValueUpdateMessage.getDistributionMode()));
                }
            }
        }

        private void handleRenameMessage(RenameMessage renameMessage) {
            String msgDomain = renameMessage.getApplicationName();
            String oldName = renameMessage.getOldBindingName();
            String newName = renameMessage.getNewBindingName();
            if (this.m_application.getName().equals(msgDomain)) {
                RMIServerContext context = this.m_application.getContext().getRMIContext();
                try {
                    context.rename(oldName, newName, true);
                }
                catch (NamingException e) {
                    throw new RuntimeException("failed to execute clustered unbind: " + e);
                }
            }
        }

        private void handleUnbindMessage(UnbindMessage unbindMessage) {
            String msgDomain = unbindMessage.getApplicationName();
            String oldName = unbindMessage.getBindingName();
            if (this.m_application.getName().equals(msgDomain)) {
                RMIServerContext context = this.m_application.getContext().getRMIContext();
                try {
                    context.unbind(oldName, 2);
                }
                catch (NamingException e) {
                    throw new RuntimeException("failed to execute clustered unbind: " + e);
                }
            }
        }
    }
}

