/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindTopic;
import com.evermind.server.multicastjms.JMSServerConfig;
import com.evermind.server.multicastjms.deployment.QueueConnectionFactoryConfig;
import com.evermind.server.multicastjms.deployment.TopicConnectionFactoryConfig;
import com.evermind.util.JMSProperties;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class XMLJMSServerConfig
extends XMLServerConfig
implements JMSServerConfig {
    protected Map queues;
    protected Map topics;
    protected List queueConnectionFactories;
    protected List topicConnectionFactories;

    public XMLJMSServerConfig(XMLApplicationServerConfig parent) {
        super(parent);
    }

    public Map getTopicMappings() {
        return this.topics;
    }

    public Map getQueueMappings() {
        return this.queues;
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("queue")) {
            this.parseQueueNode(node);
        } else if (name.equals("topic")) {
            this.parseTopicNode(node);
        } else if (name.equals("queue-connection-factory")) {
            this.addQueueConnectionFactory(new QueueConnectionFactoryConfig(node, false));
        } else if (name.equals("xa-queue-connection-factory")) {
            this.addQueueConnectionFactory(new QueueConnectionFactoryConfig(node, true));
        } else if (name.equals("topic-connection-factory")) {
            this.addTopicConnectionFactory(new TopicConnectionFactoryConfig(node, false));
        } else if (name.equals("xa-topic-connection-factory")) {
            this.addTopicConnectionFactory(new TopicConnectionFactoryConfig(node, true));
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public void addQueueConnectionFactory(QueueConnectionFactoryConfig config) {
        if (this.queueConnectionFactories == null) {
            this.queueConnectionFactories = new ArrayList();
        }
        if (config.getPort() <= 0) {
            config.setPort(this.getPort());
        }
        this.queueConnectionFactories.add(config);
    }

    public void addTopicConnectionFactory(TopicConnectionFactoryConfig config) {
        if (this.topicConnectionFactories == null) {
            this.topicConnectionFactories = new ArrayList();
        }
        if (config.getPort() <= 0) {
            config.setPort(this.getPort());
        }
        this.topicConnectionFactories.add(config);
    }

    public void parseQueueNode(Node parent) throws InstantiationException {
        EvermindQueue queue = new EvermindQueue(parent, this.getURL());
        if (queue.getLocation() != null && queue.getQueueName() != null) {
            this.queues.put(queue.getLocation(), queue);
        }
    }

    public void parseTopicNode(Node parent) throws InstantiationException {
        String topicName = XMLUtils.getNodeAttribute(parent, "name");
        String location = XMLUtils.getNodeAttribute(parent, "location");
        if (location == null) {
            throw new InstantiationException("topic tag with missing location attribute");
        }
        if (topicName != null && location != null) {
            EvermindTopic topic = new EvermindTopic(topicName, location);
            this.topics.put(location, topic);
        }
    }

    protected void reset() {
        super.reset();
        this.queues = new HashMap();
        this.topics = new HashMap();
    }

    public void init(URL url) throws InstantiationException, IOException {
        super.init(url);
        int jmsPort = JMSProperties.getPortJms();
        if (jmsPort > 0) {
            this.port = jmsPort;
        }
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("jms-server")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not a jms-server file as expected");
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
    }

    public List getQueueConnectionFactories() {
        if (this.queueConnectionFactories == null) {
            return Collections.EMPTY_LIST;
        }
        return this.queueConnectionFactories;
    }

    public List getTopicConnectionFactories() {
        if (this.topicConnectionFactories == null) {
            return Collections.EMPTY_LIST;
        }
        return this.topicConnectionFactories;
    }
}

