/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.util.ConfigUtils;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.jms.Queue;
import org.w3c.dom.Node;

public class EvermindQueue
implements Queue,
Serializable {
    static final long serialVersionUID = 9101019728694123824L;
    protected String name;
    protected String location;
    protected String description;
    protected String persistenceFile;

    public EvermindQueue(String name) {
        this.name = name;
    }

    public EvermindQueue(Node parent, URL url) throws InstantiationException {
        this.name = XMLUtils.getNodeAttribute(parent, "name");
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        this.description = XMLUtils.getSubnodeValue(parent, "description");
        String relativeFile = XMLUtils.getNodeAttribute(parent, "persistence-file");
        if (relativeFile != null && url != null) {
            try {
                this.persistenceFile = ConfigUtils.getURL(url, relativeFile).getFile();
            }
            catch (IOException e) {
                throw new InstantiationException("Invalid persistence-file URL: " + e.getMessage());
            }
        }
        if (this.name == null) {
            throw new InstantiationException("queue tag with missing name attribute");
        }
    }

    public String getQueueName() {
        return this.name;
    }

    public String getPersistenceFile() {
        return this.persistenceFile;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "[Queue " + this.name + "]";
    }
}

