/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;
import com.evermind.parser.NotExpression;
import com.evermind.parser.PowerExpression;
import com.evermind.server.multicastjms.EvermindBytesMessage;
import com.evermind.server.multicastjms.EvermindMapMessage;
import com.evermind.server.multicastjms.EvermindObjectMessage;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueSession;
import com.evermind.server.multicastjms.EvermindRemoteTemporaryQueue;
import com.evermind.server.multicastjms.EvermindRemoteTemporaryTopic;
import com.evermind.server.multicastjms.EvermindStreamMessage;
import com.evermind.server.multicastjms.EvermindTemporaryQueue;
import com.evermind.server.multicastjms.EvermindTemporaryTopic;
import com.evermind.server.multicastjms.EvermindTextMessage;
import com.evermind.server.multicastjms.EvermindTopic;
import com.evermind.server.multicastjms.PropertyMap;
import com.evermind.server.multicastjms.ServerQueue;
import com.evermind.util.StringUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class EvermindMessage
extends PropertyMap
implements Message,
ExpressionContext {
    private static final int FLAG_TYPE_SET = 1;
    private static final int FLAG_PRIORITY_SET = 2;
    private static final int FLAG_DELIVERYMODE_SET = 4;
    private static final int FLAG_TIME_TO_LIVE_SET = 8;
    private static final int FLAG_TIMESTAMP_SENT = 16;
    private static final int FLAG_REPLYTO_SET = 32;
    private static final int FLAG_CORRELATIONID_SET = 64;
    private static final int DESTINATION_QUEUE = 1;
    private static final int DESTINATION_TOPIC = 2;
    private static final int DESTINATION_TEMPORARYQUEUE = 3;
    private static final int DESTINATION_TEMPORARYTOPIC = 4;
    long sender;
    int id;
    long timestamp;
    private String correlationID;
    private int priority = 4;
    private long expiration = 0L;
    protected Destination destination;
    private Destination replyTo;
    private boolean redelivered;
    private int deliveryMode = 2;
    private String messageType;
    private String destinationName;
    protected transient EvermindQueueSession receivedSession;
    protected transient ServerQueue originQueue;
    protected transient EvermindMessage original;

    public int getTypeID() {
        return 6;
    }

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        int flags = in.read();
        if ((flags & 1) != 0) {
            this.messageType = dataIn.readUTF();
        }
        if ((flags & 2) != 0) {
            this.priority = dataIn.readInt();
        }
        if ((flags & 4) != 0) {
            this.deliveryMode = in.read();
        }
        if ((flags & 8) != 0) {
            this.expiration = dataIn.readLong();
        }
        if ((flags & 0x10) != 0) {
            this.timestamp = dataIn.readLong();
        }
        if ((flags & 0x20) != 0) {
            int type = in.read();
            this.replyTo = type == 1 ? new EvermindQueue(dataIn.readUTF()) : (type == 2 ? new EvermindTopic(dataIn.readUTF(), null) : (type == 3 ? new EvermindRemoteTemporaryQueue(dataIn.readInt(), dataIn.readInt()) : new EvermindRemoteTemporaryTopic(dataIn.readInt(), dataIn.readInt())));
        }
        if ((flags & 0x40) != 0) {
            this.correlationID = dataIn.readUTF();
        }
        super.read(in, dataIn);
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        int flags = 0;
        if (this.messageType != null) {
            flags |= 1;
        }
        if (this.priority != 4) {
            flags |= 2;
        }
        if (this.deliveryMode != 2) {
            flags |= 4;
        }
        if (this.expiration != 0L) {
            flags |= 8;
        }
        if (this.timestamp != 0L) {
            flags |= 0x10;
        }
        if (this.replyTo != null) {
            flags |= 0x20;
        }
        if (this.correlationID != null) {
            flags |= 0x40;
        }
        out.write(flags);
        if (this.messageType != null) {
            dataOut.writeUTF(this.messageType);
        }
        if (this.priority != 4) {
            dataOut.writeInt(this.priority);
        }
        if (this.deliveryMode != 2) {
            out.write(this.deliveryMode);
        }
        if (this.expiration != 0L) {
            dataOut.writeLong(this.expiration);
        }
        if (this.timestamp != 0L) {
            dataOut.writeLong(this.timestamp);
        }
        if (this.replyTo != null) {
            if (this.replyTo instanceof EvermindQueue) {
                out.write(1);
                dataOut.writeUTF(((EvermindQueue)this.replyTo).getQueueName());
            } else if (this.replyTo instanceof EvermindTopic) {
                out.write(2);
                dataOut.writeUTF(((EvermindTopic)this.replyTo).getTopicName());
            } else if (this.replyTo instanceof EvermindTemporaryQueue) {
                out.write(3);
                dataOut.writeLong(((EvermindTemporaryQueue)this.replyTo).getClientID());
                dataOut.writeInt(((EvermindTemporaryQueue)this.replyTo).getID());
            } else if (this.replyTo instanceof EvermindTemporaryTopic) {
                out.write(4);
                dataOut.writeLong(((EvermindTemporaryTopic)this.replyTo).getClientID());
                dataOut.writeInt(((EvermindTemporaryTopic)this.replyTo).getID());
            } else if (this.replyTo instanceof EvermindRemoteTemporaryQueue) {
                out.write(4);
                dataOut.writeLong(((EvermindTemporaryQueue)this.replyTo).getClientID());
                dataOut.writeInt(((EvermindTemporaryQueue)this.replyTo).getID());
            } else if (this.replyTo instanceof EvermindTemporaryQueue) {
                out.write(4);
                dataOut.writeLong(((EvermindTemporaryQueue)this.replyTo).getClientID());
                dataOut.writeInt(((EvermindTemporaryQueue)this.replyTo).getID());
            }
        }
        if (this.correlationID != null) {
            dataOut.writeUTF(this.correlationID);
        }
        super.write(out, dataOut);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getJMSType() {
        return this.messageType;
    }

    public void setJMSType(String type) {
        this.messageType = type;
    }

    public long getJMSExpiration() {
        return this.expiration;
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.redelivered = redelivered;
    }

    public boolean getJMSRedelivered() {
        return this.redelivered;
    }

    public int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int mode) {
        this.deliveryMode = mode;
    }

    public Destination getJMSDestination() {
        return this.destination;
    }

    public void setJMSPriority(int priority) {
        this.priority = priority;
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public void setJMSExpiration(long expiration) {
        this.expiration = expiration;
    }

    public void setJMSDestination(Destination destination) {
        this.destination = destination;
    }

    public String getJMSMessageID() {
        return "ID:".concat(Long.toString(this.sender << (int)(32L + (long)this.id), 16));
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        if (!messageID.startsWith("ID:")) {
            throw new JMSException("Invalid JMSMEssageID, does not start with 'ID:': " + messageID);
        }
        messageID = messageID.substring(3);
        try {
            long value = Long.parseLong(messageID, 16);
            this.id = (int)value;
            this.sender = value >>> 32;
        }
        catch (NumberFormatException e) {
            throw new JMSException("Invalid JMSMessageID: " + messageID);
        }
    }

    public long getJMSTimestamp() {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void clearBody() {
    }

    public void acknowledge() throws JMSException {
        if (this.receivedSession != null) {
            this.receivedSession.acknowledgeMessage(this);
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.setJMSCorrelationID(new String(correlationID));
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.getJMSCorrelationID().getBytes();
    }

    public void setJMSCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    public String getJMSCorrelationID() {
        return this.correlationID;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination destination) {
        this.replyTo = destination;
    }

    public double getDoubleParameter(String name) {
        if (name.equals("JMSDeliveryMode")) {
            return this.deliveryMode;
        }
        if (name.equals("JMSTimestamp")) {
            return this.timestamp;
        }
        if (name.equals("JMSCorrelationID")) {
            throw new NumberFormatException();
        }
        if (name.equals("JMSType")) {
            if (this.messageType == null) {
                throw new NumberFormatException("JMSType was null");
            }
            return Double.parseDouble(this.messageType);
        }
        if (name.equals("JMSMessageID")) {
            return this.id;
        }
        try {
            for (int i = 0; i < this.propertyCount; ++i) {
                if (!this.properties[i].name.equals(name)) continue;
                return this.properties[i].getDoubleValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getParameter(String name) {
        if (name.equals("JMSDeliveryMode")) {
            return String.valueOf(this.deliveryMode);
        }
        if (name.equals("JMSMessageID")) {
            return Integer.toHexString(this.id);
        }
        if (name.equals("JMSTimestamp")) {
            return String.valueOf(this.timestamp);
        }
        if (name.equals("JMSCorrelationID")) {
            return this.correlationID;
        }
        if (name.equals("JMSType")) {
            return this.messageType;
        }
        return this.getStringProperty(name);
    }

    public void setParameter(String name, double value) {
        throw new IllegalStateException("Message not writable");
    }

    public void setParameter(String name, String value) {
        throw new IllegalStateException("Message not writable");
    }

    public static EvermindMessage readMessage(int type, InputStream in, DataInputStream dataIn) throws IOException {
        EvermindMessage message = null;
        switch (type) {
            case 7: {
                return null;
            }
            case 4: {
                message = new EvermindMapMessage();
                message.read(in, dataIn);
                break;
            }
            case 1: {
                message = new EvermindObjectMessage();
                message.read(in, dataIn);
                break;
            }
            case 5: {
                message = new EvermindTextMessage();
                message.read(in, dataIn);
                break;
            }
            case 6: {
                message = new EvermindMessage();
                message.read(in, dataIn);
                break;
            }
            case 3: {
                message = new EvermindStreamMessage(false);
                message.read(in, dataIn);
                break;
            }
            case 2: {
                message = new EvermindBytesMessage(false);
                message.read(in, dataIn);
            }
        }
        return message;
    }

    public String toString() {
        return "[Message " + this.id + ", " + super.toString() + ", " + this.destination + "]";
    }

    public String getAndSign() {
        return "and";
    }

    public String getLessOrEqualsSign() {
        return "<=";
    }

    public String getAssignmentEqualsSign() {
        return "==";
    }

    public String getBooleanEqualsSign() {
        return "=";
    }

    public String getBooleanNotEqualsSign() {
        return "<>";
    }

    public String getBooleanName(int type) {
        if (type == 0) {
            return "FALSE";
        }
        if (type == 1) {
            return "TRUE";
        }
        return "UNKNOWN";
    }

    public String getLessSign() {
        return "<";
    }

    public String getMoreOrEqualsSign() {
        return ">=";
    }

    public String getMoreSign() {
        return ">";
    }

    public String getOrSign() {
        return "or";
    }

    public void writeStringLiteral(StringBuffer buffer, String string, Expression enclosing) {
        buffer.append('\'');
        buffer.append(StringUtils.replace(string, '\'', "''"));
        buffer.append('\'');
    }

    public void writePowerExpression(StringBuffer buffer, Expression left, Expression right, PowerExpression powerExpression, Expression enclosing) {
        buffer.append('(');
        left.write(buffer, this, enclosing);
        buffer.append(" ^ ");
        right.write(buffer, this, enclosing);
        buffer.append(')');
    }

    public void writeNotEquals(StringBuffer buffer, Expression left, Expression right, Expression notEqualsExpression, Expression enclosing) {
        buffer.append('(');
        left.write(buffer, this, enclosing);
        buffer.append(" != ");
        right.write(buffer, this, enclosing);
        buffer.append(')');
    }

    public void writeNotExpression(StringBuffer buffer, NotExpression notExpression, Expression expression, Expression enclosing) {
        buffer.append("!(");
        expression.write(buffer, this, enclosing);
        buffer.append(')');
    }

    public void writeParameter(StringBuffer buffer, String parameter, Expression enclosing) {
        buffer.append(parameter);
    }

    public EvermindMessage cloneMessage() {
        return this.clone(new EvermindMessage());
    }

    public EvermindMessage clone(EvermindMessage other) {
        super.cloneProperties(other);
        other.sender = this.sender;
        other.id = this.id;
        other.timestamp = this.timestamp;
        other.correlationID = this.correlationID;
        other.priority = this.priority;
        other.expiration = this.expiration;
        other.destination = this.destination;
        other.replyTo = this.replyTo;
        other.redelivered = this.redelivered;
        other.deliveryMode = this.deliveryMode;
        other.messageType = this.messageType;
        other.destinationName = this.destinationName;
        return other;
    }

    public static EvermindMessage clone(Message other) throws JMSException {
        byte[] buffer;
        Enumeration enumeration;
        EvermindMessage message;
        if (other instanceof TextMessage) {
            message = new EvermindTextMessage(((TextMessage)other).getText());
        } else if (other instanceof MapMessage) {
            message = new EvermindMapMessage();
            enumeration = ((MapMessage)other).getMapNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                ((MapMessage)message).setObject(name, ((MapMessage)other).getObject(name));
            }
        } else if (other instanceof ObjectMessage) {
            message = new EvermindObjectMessage(((ObjectMessage)other).getObject());
        } else if (other instanceof BytesMessage) {
            int length;
            message = new EvermindBytesMessage(true);
            buffer = new byte[4096];
            while ((length = ((BytesMessage)other).readBytes(buffer)) >= 0) {
                ((BytesMessage)message).writeBytes(buffer, 0, length);
            }
        } else if (other instanceof StreamMessage) {
            int length;
            message = new EvermindStreamMessage(true);
            buffer = new byte[4096];
            while ((length = ((StreamMessage)other).readBytes(buffer)) >= 0) {
                ((StreamMessage)message).writeBytes(buffer, 0, length);
            }
        } else {
            message = new EvermindMessage();
        }
        message.setJMSCorrelationID(other.getJMSCorrelationID());
        message.setJMSDeliveryMode(other.getJMSDeliveryMode());
        message.setJMSDestination(other.getJMSDestination());
        message.setJMSExpiration(other.getJMSExpiration());
        message.setJMSMessageID(other.getJMSMessageID());
        message.setJMSPriority(other.getJMSPriority());
        message.setJMSRedelivered(other.getJMSRedelivered());
        message.setJMSReplyTo(other.getJMSReplyTo());
        message.setJMSTimestamp(other.getJMSTimestamp());
        message.setJMSType(other.getJMSType());
        enumeration = other.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            message.setObjectProperty(name, other.getObjectProperty(name));
        }
        return message;
    }
}

