/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindConnectionMetaData;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class EvermindConnection
implements Connection {
    protected long clientID;
    protected String username;
    protected String password;
    protected ExceptionListener exceptionListener;
    protected boolean started;
    protected boolean closed;
    protected int waitingForStart;

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public String getClientID() {
        return Long.toHexString(this.clientID);
    }

    public void setClientID(String clientID) throws InvalidClientIDException {
        try {
            this.clientID = Long.parseLong(clientID, 16);
        }
        catch (NumberFormatException e) {
            throw new InvalidClientIDException("Must be a 64bit hexadecimal number");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        EvermindConnection evermindConnection = this;
        synchronized (evermindConnection) {
            this.started = true;
            if (this.waitingForStart > 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitForStart(long timeout) throws JMSException {
        long startedTime = timeout > 0L ? System.currentTimeMillis() : 0L;
        try {
            while (!this.started) {
                EvermindConnection evermindConnection = this;
                synchronized (evermindConnection) {
                    block12: {
                        try {
                            ++this.waitingForStart;
                            if (timeout == 0L) {
                                this.wait();
                                break block12;
                            }
                            if (timeout < 0L) {
                                boolean bl = false;
                                return bl;
                            }
                            long difference = System.currentTimeMillis() - startedTime;
                            if (difference < timeout) {
                                this.wait(difference);
                                break block12;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            --this.waitingForStart;
                        }
                    }
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new JMSException("Interrupted while waiting");
        }
    }

    public void stop() throws JMSException {
        this.started = false;
    }

    public void close() throws JMSException {
    }

    public ConnectionMetaData getMetaData() {
        return new EvermindConnectionMetaData();
    }

    public boolean isStarted() {
        return this.started;
    }

    public Session createSession(boolean transacted, int ackmode) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public ConnectionConsumer createConnectionConsumer(Destination d, String selector, ServerSessionPool sp, int maxmsgs) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic t, String name, String selector, ServerSessionPool sp, int masmsgs) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

