/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSProvider;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSServerMessages;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.JMXSupport;
import com.evermind.server.jms.KnobsController;
import com.evermind.server.jms.LRUPool;
import com.evermind.server.jms.Pool;
import com.evermind.server.jms.Poolable;
import com.evermind.server.jms.SessionID;
import com.evermind.server.jms.Tset;
import com.evermind.server.jms.TxMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.oc4j.admin.management.callbackinterfaces.JMSPersistenceCallBackIf;
import oracle.oc4j.admin.management.mbeans.JMSPersistence;
import oracle.oc4j.security.OC4JSecurity;

public final class ServerFile
implements Poolable,
JMSPersistenceCallBackIf {
    private long m_lastUsed;
    private final TxMap m_txMap;
    private final String m_file;
    private final byte m_qtDest;
    private final String m_name;
    private final boolean m_noFile;
    private final boolean m_doLock;
    private final boolean m_doPriv;
    private final boolean m_isPoolable;
    private final JMSStats m_jstats;
    private RandomAccessFile m_raf;
    private final Buddy m_buddy;
    private final Set m_objs;
    private final Set m_trans;
    private final Tset m_isOpen;
    private final Tset m_isClosed;
    private final Map m_txObj;
    private final Map m_objTx;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(ServerFile.class);
    private static final Pool s_pool = new LRUPool((Integer)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.maxOpenFiles", new ConfigPropertyListener(){

        public void onConfigPropertyChange(ConfigPropertyEvent event) {
            ServerFile.setMaxOpenFiles((Integer)event.getPropertyValue());
        }
    }), ServerFile.class.toString());
    public static final int NO_TX = 0;
    public static final byte STORE_QUEUE = 3;
    public static final byte STORE_TOPIC = 5;
    public static final byte STORE_FREE = 7;
    public static final byte STORE_XOPEN = 11;
    public static final byte STORE_XDONE = 13;
    public static final byte STORE_USED = 17;
    public static final byte STORE_ENQ = 19;
    public static final byte STORE_DEQ = 23;
    private static final long WAIT_TIME = 1000L;
    private static final boolean LAZY_SYNC = (Boolean)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.lazySync");
    private static final boolean FORCE_RECOVERY = (Boolean)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.forceRecovery");
    private static final int PAGE_SIZE = 512;
    private static final int MAGIC_SIZE = 1;
    private static final int PAGE_SIZE_SIZE = 4;
    private static final int DEST_LENGTH_SIZE = 4;
    private static final int NPAGES_SIZE = 4;
    private static final int TXID_SIZE = 4;
    private static final int DATA_LENGTH_SIZE = 4;
    private static final int ROOT_PAGE_SIZE = 503;
    private static final int DATA_PAGE_HDR = 13;

    ServerFile(TxMap txMap, String pfx, String file, byte qtDest, String name) throws IOException {
        this(txMap, pfx, file, qtDest, name, true, true);
    }

    ServerFile(TxMap txMap, String pfx, String file, byte qtDest, String name, boolean doLock, boolean doPriv) throws IOException {
        this(txMap, pfx, file, qtDest, name, doLock, doPriv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerFile(TxMap txMap, String pfx, String file, byte qtDest, String name, boolean doLock, boolean doPriv, boolean isPoolable) throws IOException {
        block14: {
            this.m_lastUsed = 0L;
            this.m_raf = null;
            this.m_buddy = new Buddy();
            this.m_objs = new HashSet();
            this.m_trans = new HashSet();
            this.m_isOpen = new Tset(false);
            this.m_isClosed = new Tset(false);
            this.m_txObj = new HashMap();
            this.m_objTx = new HashMap();
            this.m_txMap = txMap;
            this.m_file = file;
            this.m_qtDest = qtDest;
            this.m_name = name;
            this.m_noFile = JMSUtils.isNull(this.m_file);
            this.m_doLock = doLock;
            this.m_doPriv = doPriv;
            this.m_isPoolable = isPoolable;
            if (!this.m_noFile) {
                Pool pool;
                if (this.m_isPoolable) {
                    Pool pool2 = s_pool;
                    synchronized (pool2) {
                        this.addPool();
                    }
                }
                String parent = pfx;
                String self = "File." + name;
                this.m_jstats = JMSStats.create(parent, self, "JMSPersistence");
                this.m_jstats.setMBean(new JMSPersistence(this, self, this.m_file, name, txMap != null ? ServerFile.getDestType(parent) + name : null));
                this.m_jstats.state("destination", name, true);
                this.m_jstats.state("persistenceFile", this.m_file, true);
                boolean success = false;
                try {
                    this.openFile();
                    success = true;
                    Object var13_13 = null;
                    if (success) break block14;
                    this.m_jstats.close();
                    if (!this.m_isPoolable) break block14;
                    pool = s_pool;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!success) {
                        this.m_jstats.close();
                        if (this.m_isPoolable) {
                            Pool pool3 = s_pool;
                            synchronized (pool3) {
                                this.removePool();
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (pool) {
                    this.removePool();
                }
            }
            this.m_jstats = null;
        }
    }

    static ServerFile getDummy() throws IOException {
        return new ServerFile(null, null, null, 0, null);
    }

    private static String getDestType(String parent) {
        String parentPath = "/JMS/";
        int dotIdx = parent.indexOf(46, "/JMS/".length());
        if (parent.startsWith("/JMS/") && dotIdx > 0) {
            return parent.substring("/JMS/".length(), dotIdx + 1);
        }
        return parent;
    }

    public String getCanonicalName() {
        return JMXSupport.getCanonicalName(this.m_jstats.getMBean());
    }

    public static void main(String[] argv) {
        System.out.println(JMSProvider.NAME + ", " + "OC4J JMS 1.1\n");
        if (argv.length == 0) {
            System.out.println("Usage: ServerFile <file> ...");
            return;
        }
        for (int i = 0; i < argv.length; ++i) {
            ServerFile.dumpFile(argv[i]);
        }
    }

    private static void dumpFile(String file) {
        System.out.println("ServerFile: " + file);
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            long len = raf.length();
            if (len % 512L != 0L) {
                len += 512L;
            }
            int npages = (int)(len / 512L);
            System.out.println("  pages=" + npages);
            ServerFile.dumpRoot(raf);
            ServerFile.dumpPages(raf, npages);
            raf.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        System.out.println("");
    }

    private static void dumpRoot(RandomAccessFile raf) throws Exception {
        byte qtDest = raf.readByte();
        int pageSize = raf.readInt();
        int nlen = raf.readInt();
        byte[] data = new byte[nlen];
        raf.readFully(data);
        String name = (String)((Object)JMSUtils.toSerializable(data));
        System.out.println("  page[0]: " + ServerFile.pp(qtDest) + " " + pageSize + " " + nlen + " " + name);
    }

    private static void dumpPages(RandomAccessFile raf, int npages) throws Exception {
        int plen;
        for (int i = 1; i < npages; i += plen) {
            raf.seek(512L * (long)i);
            byte magic = raf.readByte();
            plen = raf.readInt();
            int tx = raf.readInt();
            int dlen = raf.readInt();
            System.out.println("  page[" + i + "]: " + ServerFile.pp(magic) + " " + plen + " " + tx + " " + dlen);
            if (plen <= 0 || i + plen > npages) {
                magic = 7;
                plen = 1;
            }
            if (dlen <= 0 || ServerFile.getPos(i) + (long)dlen > ServerFile.getPos(npages)) {
                magic = 7;
                plen = 1;
            }
            if (!ServerFile.isFirst(magic)) continue;
            try {
                byte[] data = new byte[dlen];
                raf.readFully(data);
                Object obj = ServerFile.reconstruct(data);
                System.out.println("    " + obj + " [" + data + "]");
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public String toString() {
        return "ServerFile[" + (JMSUtils.isNull(this.m_name) ? "dummy" : this.m_name + "," + this.m_file) + "]";
    }

    public void activate() throws IOException {
        s_traceLogger.fine("{0}: activate", new Object[]{this});
        this.reopenFile();
    }

    public void passivate() throws IOException {
        s_traceLogger.fine("{0}: passivate", new Object[]{this});
        this.close(false);
    }

    public long getLastUsed() {
        return this.m_lastUsed;
    }

    public boolean isOpen() {
        return this.m_isOpen.test();
    }

    synchronized boolean isDummy() {
        return this.m_noFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.m_noFile) {
            return;
        }
        if (!this.m_isClosed.testAndSet(true)) {
            long tok = this.startPhase("close", false);
            try {
                this.close(true);
            }
            finally {
                this.stopPhase("close", tok, false);
            }
            if (this.m_isPoolable) {
                this.removePool();
            }
            this.m_jstats.close();
        }
    }

    public synchronized int usedPageCount() {
        return this.m_noFile ? 0 : this.m_buddy.usedPages();
    }

    public synchronized int holePageCount() {
        return this.m_noFile ? 0 : this.m_buddy.freePages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer writeObject(byte[] obj, Object txid) throws IOException {
        if (this.m_noFile) {
            return null;
        }
        long tok = this.startPhase("writeObject");
        try {
            Integer n = this.internalWriteObject(obj, txid);
            return n;
        }
        finally {
            this.stopPhase("writeObject", tok);
        }
    }

    private Integer internalWriteObject(byte[] obj, Object txid) throws IOException {
        int tx = this.getTx(txid);
        int npages = this.getPageCount(obj);
        int page = this.allocatePages(npages);
        this.writePages(obj, tx, page, npages);
        Integer objid = new Integer(page);
        this.addObject(txid, objid);
        return objid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeObject(Integer objid, Object txid) throws IOException {
        if (this.m_noFile || objid == null || objid <= 0) {
            return;
        }
        long tok = this.startPhase("removeObject");
        try {
            this.internalRemoveObject(objid, txid);
        }
        finally {
            this.stopPhase("removeObject", tok);
        }
    }

    private void internalRemoveObject(Integer objid, Object txid) throws IOException {
        int tx;
        if (objid == null || objid <= 0) {
            return;
        }
        if (!this.m_objs.contains(objid)) {
            JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03000", this, objid));
        }
        if ((tx = this.getTx(txid)) == 0 || this.m_objTx.containsKey(objid)) {
            this.delObject(objid);
        } else {
            byte magic = 23;
            this.addTx(txid, objid, magic);
            this.setTx(objid, magic, tx);
        }
        this.sync(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rasa(Iterator iter) throws IOException {
        if (this.m_noFile) {
            return;
        }
        long tok = this.startPhase("rasa");
        try {
            while (iter.hasNext()) {
                Integer objid = (Integer)iter.next();
                if (this.m_objs.contains(objid)) {
                    this.delObject(objid);
                    continue;
                }
                JMSServerMessages.warningInvalidObjid(this, objid);
            }
            this.syncForce();
        }
        finally {
            this.stopPhase("rasa", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer replaceObject(Integer objid, byte[] obj) throws IOException {
        if (this.m_noFile) {
            return null;
        }
        long tok = this.startPhase("replaceObject");
        try {
            Integer newid = this.internalWriteObject(obj, null);
            this.internalRemoveObject(objid, null);
            Integer n = newid;
            return n;
        }
        finally {
            this.stopPhase("replaceObject", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Object txid) throws IOException {
        if (this.m_noFile) {
            return;
        }
        long tok = this.startPhase("commit");
        try {
            Map m = (Map)this.m_txObj.get(txid);
            this.m_txObj.remove(txid);
            if (m == null) {
                return;
            }
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Integer objid = (Integer)entry.getKey();
                Byte magic = (Byte)entry.getValue();
                if (magic == 19) {
                    this.setOk(objid);
                } else {
                    this.delObject(objid);
                }
                this.m_objTx.remove(objid);
            }
            this.syncForce();
        }
        finally {
            this.stopPhase("commit", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Object txid) throws IOException {
        if (this.m_noFile) {
            return;
        }
        long tok = this.startPhase("rollback");
        try {
            Map m = (Map)this.m_txObj.get(txid);
            this.m_txObj.remove(txid);
            if (m == null) {
                return;
            }
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Integer objid = (Integer)entry.getKey();
                Byte magic = (Byte)entry.getValue();
                if (magic == 23) {
                    this.setOk(objid);
                } else {
                    this.delObject(objid);
                }
                this.m_objTx.remove(objid);
            }
            this.syncForce();
        }
        finally {
            this.stopPhase("rollback", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer[] scanTransactions() throws IOException {
        if (this.m_noFile) {
            return null;
        }
        long tok = this.startPhase("scanTransactions");
        try {
            Integer[] trans = new Integer[this.m_trans.size()];
            int i = 0;
            Iterator iter = this.m_trans.iterator();
            while (iter.hasNext()) {
                trans[i++] = (Integer)iter.next();
            }
            Integer[] integerArray = trans;
            return integerArray;
        }
        finally {
            this.stopPhase("scanTransactions", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer[] scanObjects() throws IOException {
        if (this.m_noFile) {
            return null;
        }
        long tok = this.startPhase("scanObjects");
        try {
            Integer[] objs = new Integer[this.m_objs.size()];
            int i = 0;
            Iterator iter = this.m_objs.iterator();
            while (iter.hasNext()) {
                objs[i++] = (Integer)iter.next();
            }
            Integer[] integerArray = objs;
            return integerArray;
        }
        finally {
            this.stopPhase("scanObjects", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] readObject(Integer objid) throws IOException {
        if (this.m_noFile || objid == null || objid <= 0) {
            return null;
        }
        long tok = this.startPhase("readObject");
        try {
            byte[] byArray = this.readObject((int)objid);
            return byArray;
        }
        finally {
            this.stopPhase("readObject", tok);
        }
    }

    protected boolean isXASession(Object txid) {
        return this.m_txObj.get(txid) != null;
    }

    protected Object getOpenXATxID(Integer objid) {
        if (this.m_objTx.containsKey(objid)) {
            return this.m_objTx.get(objid);
        }
        return null;
    }

    protected boolean wasEnqueuedInOpenTx(Object txid, Integer objid) {
        Byte mb;
        Map m = (Map)this.m_txObj.get(txid);
        if (m != null && (mb = (Byte)m.get(objid)) != null) {
            return mb == 19;
        }
        return false;
    }

    private void openFile() throws IOException {
        if (!this.m_doPriv) {
            this.safeOpenFile();
            return;
        }
        try {
            OC4JSecurity.doUnprivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ServerFile.this.safeOpenFile();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private void checkLockFile() throws IOException {
        if (this.m_doLock) {
            String lockN = this.m_file + ".lock";
            File lockF = new File(lockN);
            boolean exists = false;
            try {
                exists = !lockF.createNewFile();
            }
            catch (IOException ie) {
                throw new IOException(ie.getMessage() + ": " + this.m_file);
            }
            RandomAccessFile lockRaf = new RandomAccessFile(lockF, "rw");
            if (exists) {
                String lockId = "";
                try {
                    lockId = lockRaf.readUTF();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (!lockId.equals(JMSServer.s_instanceId)) {
                    JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03001", this, this.m_file, lockN));
                }
            } else {
                lockRaf.writeUTF(JMSServer.s_instanceId);
            }
            lockRaf.close();
            lockF.deleteOnExit();
        }
    }

    private void safeOpenFile() throws IOException {
        if (this.m_isPoolable) {
            this.checkLockFile();
        }
        File f = new File(this.m_file);
        boolean created = f.createNewFile();
        this.m_raf = new RandomAccessFile(this.m_file, "rw");
        if (!this.m_isPoolable) {
            boolean gotLock = false;
            IOException exception = null;
            try {
                gotLock = this.m_raf.getChannel().tryLock() != null;
            }
            catch (IOException ex) {
                exception = ex;
            }
            if (!gotLock) {
                JMSServerMessages.severeLockPersistenceFile(this, exception);
            }
        }
        if (!created) {
            this.recover();
        } else {
            this.root();
        }
        this.m_isOpen.set(true);
        if (this.m_isPoolable) {
            this.close(false);
        }
    }

    private void reopenFile() throws IOException {
        if (!this.m_doPriv) {
            this.safeReopenFile();
            return;
        }
        try {
            OC4JSecurity.doUnprivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ServerFile.this.safeReopenFile();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private void safeReopenFile() throws IOException {
        this.m_raf = new RandomAccessFile(this.m_file, "rw");
        this.m_isOpen.set(true);
        this.m_jstats.state("isOpen", this.m_isOpen.test());
    }

    private void close(final boolean removeLock) throws IOException {
        if (!this.m_doPriv) {
            this.safeClose(removeLock);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ServerFile.this.safeClose(removeLock);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private void safeClose(boolean removeLock) throws IOException {
        if (this.m_noFile) {
            return;
        }
        if (this.m_isOpen.testAndSet(false)) {
            this.m_jstats.state("isOpen", this.m_isOpen.test());
            this.compact();
            this.m_raf.close();
        }
        if (removeLock && this.m_doLock && this.m_isPoolable) {
            String lockN = this.m_file + ".lock";
            File lockF = new File(lockN);
            lockF.delete();
        }
    }

    private void recover() throws IOException {
        int n;
        long len = this.m_raf.length();
        if (len == 0L) {
            this.root();
            return;
        }
        if (len % 512L != 0L) {
            len += 512L;
        }
        int npages = (int)(len / 512L);
        this.m_raf.setLength(ServerFile.getPos(npages));
        int rootp = this.m_buddy.allocate(1);
        this.seek(0);
        try {
            this.checkRoot();
        }
        catch (IOException ex) {
            if (FORCE_RECOVERY) {
                s_traceLogger.fine("checkRoot", ex);
                this.makeRoot();
            }
            throw ex;
        }
        HashSet toFree = new HashSet();
        int i = 1;
        while (i < npages && (n = this.recoverNext(npages, i, toFree)) != i) {
            i = n;
        }
        int bsize = this.m_buddy.size();
        int rsize = Buddy.round2(this.m_buddy.size());
        for (int i2 = bsize; i2 < rsize; ++i2) {
            this.loadFree(i2, 1, toFree);
        }
        Iterator iter = toFree.iterator();
        while (iter.hasNext()) {
            Integer p = (Integer)iter.next();
            this.m_buddy.free(p);
            try {
                this.seek(p);
                this.m_raf.writeByte(7);
                this.m_raf.writeInt(1);
            }
            catch (Throwable ex) {
                s_traceLogger.fine("recover", ex);
            }
        }
        this.sync();
    }

    private void loadFree(int page, int psize, Set toFree) {
        for (int i = 0; i < psize; ++i) {
            int p = page + i;
            this.m_buddy.loadUsed(p, 1);
            toFree.add(new Integer(p));
        }
    }

    private void checkRoot() throws IOException {
        int nlen;
        int pageSize;
        byte qtDest = this.m_raf.readByte();
        if (qtDest != this.m_qtDest) {
            JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03002", this, ServerFile.pp(this.m_qtDest), ServerFile.pp(qtDest)));
        }
        if ((pageSize = this.m_raf.readInt()) != 512) {
            JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03003", this, new Integer(512), new Integer(pageSize)));
        }
        if ((nlen = this.m_raf.readInt()) <= 0 || nlen > 503) {
            JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03004", this, new Integer(nlen)));
        }
        byte[] data = new byte[nlen];
        this.m_raf.readFully(data);
        String name = (String)((Object)JMSUtils.toSerializable(data));
        if (!this.m_name.startsWith(name)) {
            JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03005", this, this.m_name, name));
        }
    }

    private int recoverNext(int npages, int page, Set toFree) throws IOException {
        this.seek(page);
        byte magic = this.m_raf.readByte();
        int psize = this.m_raf.readInt();
        int tx = this.m_raf.readInt();
        int size = this.m_raf.readInt();
        if (psize == 0) {
            magic = 7;
            psize = 1;
        }
        if (psize < 0 || page + psize > npages) {
            JMSServerMessages.warningInvalidPageSize(this, psize, page);
            magic = 7;
            psize = 1;
        }
        if (magic != 7 && (size <= 0 || ServerFile.getPos(page) + (long)size > ServerFile.getPos(npages))) {
            JMSServerMessages.warningInvalidPageSize(this, size, page);
            magic = 7;
            psize = 1;
        }
        switch (magic) {
            case 17: 
            case 19: 
            case 23: {
                this.recoverObject(magic, page, psize, tx, toFree);
                break;
            }
            default: {
                psize = 1;
                JMSServerMessages.warningInvalidMagic(this, ServerFile.pp(magic), page);
            }
            case 7: {
                if (page + psize > npages) {
                    psize = 1;
                }
                this.loadFree(page, psize, toFree);
            }
        }
        return page + psize;
    }

    private void recoverObject(byte magic, int page, int npages, int tx, Set toFree) {
        try {
            ServerFile.reconstruct(this.readObject(page));
            if (this.isOpen(tx)) {
                Integer objid = new Integer(page);
                Object txid = this.getTxid(tx);
                this.addObject(txid, objid);
                this.addTx(txid, objid, magic);
                this.m_buddy.loadUsed(page, npages);
                this.m_trans.add(new Integer(tx));
            } else if (magic == 19 && !this.isCommitted(tx) || magic == 23 && this.isCommitted(tx)) {
                this.seek(page);
                this.m_raf.writeByte(7);
                this.loadFree(page, npages, toFree);
            } else {
                this.setOk(page);
                this.m_objs.add(new Integer(page));
                this.m_buddy.loadUsed(page, npages);
            }
        }
        catch (IOException ex) {
            JMSServerMessages.warningRecoverError(this, page, ex);
            this.loadFree(page, npages, toFree);
        }
    }

    private void root() throws IOException {
        int rootp = this.m_buddy.allocate(1);
        this.makeRoot();
        this.m_raf.setLength(ServerFile.getPos(this.m_buddy.size()));
    }

    private void makeRoot() throws IOException {
        this.seek(0);
        this.m_raf.writeByte(this.m_qtDest);
        this.m_raf.writeInt(512);
        byte[] data = JMSUtils.toBytes((Serializable)((Object)this.m_name));
        int len = Math.min(data.length, 503);
        this.m_raf.writeInt(len);
        this.m_raf.write(data, 0, len);
    }

    private void touchIn() throws IOException {
        this.getPool();
    }

    private void touchOut() {
        try {
            this.putPool();
        }
        catch (Throwable ex) {
            s_traceLogger.fine("touchOut", ex);
        }
        this.m_lastUsed = System.currentTimeMillis();
        this.m_jstats.state("lastUsed", new Long(this.m_lastUsed));
    }

    private int getTx(Object txid) throws IOException {
        return this.m_txMap == null ? 0 : this.m_txMap.getTx(txid);
    }

    private Object getTxid(int tx) throws IOException {
        return this.m_txMap == null ? null : this.m_txMap.getTxid(tx);
    }

    private boolean isCommitted(int tx) throws IOException {
        return this.m_txMap == null ? false : this.m_txMap.isCommitted(tx);
    }

    private boolean isOpen(int tx) throws IOException {
        return this.m_txMap == null || tx == 0 ? false : this.m_txMap.isOpen(tx);
    }

    private void setOk(int pageid) throws IOException {
        this.seek(pageid);
        this.m_raf.writeByte(17);
        this.m_raf.readInt();
        this.m_raf.writeInt(0);
    }

    private void setTx(int pageid, byte magic, int tx) throws IOException {
        this.seek(pageid);
        this.m_raf.readByte();
        this.m_raf.readInt();
        this.m_raf.writeInt(tx);
        this.seek(pageid);
        this.m_raf.writeByte(magic);
    }

    private void addTx(Object txid, Integer objid, byte magic) {
        if (JMSUtils.isNull(txid)) {
            return;
        }
        HashMap<Integer, Byte> m = (HashMap<Integer, Byte>)this.m_txObj.get(txid);
        if (m == null) {
            m = new HashMap<Integer, Byte>();
            this.m_txObj.put(txid, m);
        }
        m.put(objid, new Byte(magic));
        this.m_objTx.put(objid, txid);
    }

    private void delTx(Integer objid) {
        if (!this.m_objTx.containsKey(objid)) {
            return;
        }
        Object txid = this.m_objTx.get(objid);
        this.m_objTx.remove(objid);
        Map m = (Map)this.m_txObj.get(txid);
        if (m != null) {
            m.remove(objid);
        }
    }

    private int getPageCount(byte[] data) {
        int size = data.length + 13;
        int npages = size / 512;
        if (size % 512 != 0) {
            ++npages;
        }
        return Buddy.round2(npages);
    }

    private int allocatePages(int npages) {
        return this.m_buddy.allocate(npages);
    }

    private void writePages(byte[] data, int tx, int page, int npages) throws IOException {
        this.seek(page);
        this.m_raf.writeByte(7);
        this.m_raf.writeInt(npages);
        this.m_raf.writeInt(tx);
        this.m_raf.writeInt(data.length);
        this.m_raf.write(data);
        this.m_raf.setLength(ServerFile.getPos(this.m_buddy.size()));
        this.seek(page);
        this.m_raf.writeByte(tx == 0 ? 17 : 19);
        this.sync(tx);
    }

    private byte[] readObject(int pageid) throws IOException {
        this.seek(pageid);
        this.m_raf.readByte();
        int npages = this.m_raf.readInt();
        int tx = this.m_raf.readInt();
        int size = this.m_raf.readInt();
        byte[] data = new byte[size];
        this.m_raf.readFully(data);
        return data;
    }

    private static boolean isFirst(byte magic) {
        return magic == 17 || magic == 19 || magic == 23;
    }

    static Object reconstruct(byte[] data) throws IOException {
        Serializable ret = null;
        byte code = data[0];
        ret = code == 0 ? JMSUtils.toSerializable(data, 1, data.length - 1) : (code == 7 ? ConsumerInfo.toConsumer(data) : (code == 8 ? SessionID.toSessionID(data) : EvermindMessage.toMessage(data)));
        return ret;
    }

    private void addObject(Object txid, Integer objid) throws IOException {
        if (this.m_objs.contains(objid)) {
            JMSUtils.toIOException(JMSServerMessages.getMessage("J2EE JMS-03010", this, objid));
        }
        this.m_objs.add(objid);
        this.addTx(txid, objid, (byte)19);
    }

    private void delObject(Integer objid) throws IOException {
        this.freePage(objid);
        this.m_objs.remove(objid);
        this.delTx(objid);
    }

    private void compact() throws IOException {
        this.m_buddy.compact();
        this.m_raf.setLength(ServerFile.getPos(this.m_buddy.size()));
        this.syncForce();
    }

    private void freePage(int page) throws IOException {
        if (page <= 0) {
            return;
        }
        this.setFree(page);
        this.seek(page);
        this.m_raf.writeByte(7);
    }

    private void setFree(int page) {
        this.m_buddy.free(page);
    }

    private void seek(int page) throws IOException {
        this.m_raf.seek(ServerFile.getPos(page));
    }

    private static long getPos(int page) {
        return (long)page * 512L;
    }

    private void sync(int tx) throws IOException {
        if (tx == 0) {
            this.syncForce();
        } else {
            this.sync();
        }
    }

    private void sync() throws IOException {
        if (!LAZY_SYNC) {
            this.syncForce();
        }
    }

    private void syncForce() throws IOException {
        this.m_raf.getFD().sync();
    }

    static String pp(int magic) {
        String ret = "(" + magic + "=";
        switch (magic) {
            case 3: {
                ret = ret + "queue";
                break;
            }
            case 5: {
                ret = ret + "topic";
                break;
            }
            case 7: {
                ret = ret + "free";
                break;
            }
            case 11: {
                ret = ret + "xopen";
                break;
            }
            case 13: {
                ret = ret + "xdone";
                break;
            }
            case 17: {
                ret = ret + "used";
                break;
            }
            case 19: {
                ret = ret + "enq";
                break;
            }
            case 23: {
                ret = ret + "deq";
                break;
            }
            default: {
                ret = ret + "unknown";
            }
        }
        return ret + ")";
    }

    private long startPhase(String func) throws IOException {
        return this.startPhase(func, true);
    }

    private long startPhase(String func, boolean doTouch) throws IOException {
        if (doTouch && this.m_isPoolable) {
            this.touchIn();
        }
        return this.m_jstats.phase(func);
    }

    private void stopPhase(String func, long tok) {
        this.stopPhase(func, tok, true);
    }

    private void stopPhase(String func, long tok, boolean doTouch) {
        this.m_jstats.phase(func, tok);
        this.m_jstats.state("usedPageCount", new Integer(this.usedPageCount()));
        this.m_jstats.state("holePageCount", new Integer(this.holePageCount()));
        if (doTouch && this.m_isPoolable) {
            this.touchOut();
        }
    }

    private void addPool() throws IOException {
        try {
            s_pool.add(this);
        }
        catch (Exception ex) {
            JMSUtils.toIOException("add(" + s_pool + ")", ex);
        }
    }

    private void removePool() throws IOException {
        try {
            s_pool.remove(this);
        }
        catch (Exception ex) {
            JMSUtils.toIOException("remove(" + s_pool + ")", ex);
        }
    }

    private void getPool() throws IOException {
        try {
            s_pool.get(this);
        }
        catch (Exception ex) {
            JMSUtils.toIOException("get(" + s_pool + ")", ex);
        }
    }

    private void putPool() throws IOException {
        try {
            s_pool.put(this);
        }
        catch (Exception ex) {
            JMSUtils.toIOException("put(" + s_pool + ")", ex);
        }
    }

    private static void setMaxOpenFiles(int newValue) {
        if (s_pool instanceof LRUPool) {
            ((LRUPool)s_pool).setSize(newValue);
        }
    }

    private static final class Buddy {
        private int m_maxSize = 1;
        private final TreeMap m_sizePage = new TreeMap();
        private final TreeMap m_pageSize = new TreeMap();

        public Buddy() {
            this.add(this.m_maxSize, 0);
        }

        public void loadUsed(int page, int size) {
            this.m_maxSize += size;
            this.m_pageSize.put(new Integer(page), new Integer(size));
        }

        public int size() {
            return this.m_maxSize;
        }

        public int allocate(int size) {
            size = Buddy.round2(size);
            this.ensure(size);
            Integer k = new Integer(size);
            while (!this.m_sizePage.containsKey(k)) {
                if (this.split(size) != -1) continue;
                this.ensure(2 * this.m_maxSize);
            }
            TreeSet s = (TreeSet)this.m_sizePage.get(k);
            Integer p = (Integer)Buddy.getAny(s);
            s.remove(p);
            if (s.size() == 0) {
                this.m_sizePage.remove(k);
            }
            this.m_pageSize.put(p, new Integer(size));
            return p;
        }

        public void free(int page) {
            Integer p = new Integer(page);
            Integer s = (Integer)this.m_pageSize.get(p);
            this.m_pageSize.remove(p);
            this.free(s, p);
        }

        public void compact() {
            Integer p;
            if (this.m_maxSize == 1 || this.m_sizePage.size() == 0) {
                return;
            }
            Integer k = new Integer(this.m_maxSize);
            if (this.m_sizePage.containsKey(k) && (p = (Integer)Buddy.getAny((TreeSet)this.m_sizePage.get(k))) == 0) {
                this.m_sizePage.remove(k);
                this.m_maxSize = 1;
                this.add(this.m_maxSize, 0);
                return;
            }
            while (this.m_sizePage.size() != 0 && (k = (Integer)this.m_sizePage.lastKey()) == this.m_maxSize / 2 && (p = (Integer)Buddy.getAny((TreeSet)this.m_sizePage.get(k))) == this.m_maxSize / 2) {
                this.m_sizePage.remove(k);
                this.m_maxSize /= 2;
            }
        }

        public int freePages() {
            return this.m_maxSize - this.usedPages();
        }

        public int usedPages() {
            int ret = 0;
            Iterator iter = this.m_pageSize.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Integer s = (Integer)entry.getValue();
                ret += s.intValue();
            }
            return ret;
        }

        private void ensure(int size) {
            if (size > this.m_maxSize) {
                while (size > this.m_maxSize) {
                    this.free(this.m_maxSize, this.m_maxSize);
                    this.m_maxSize *= 2;
                }
            }
        }

        private void free(int size, int page) {
            this.add(size, page);
            this.coalesce(size, page);
        }

        private void coalesce(int size, int page) {
            Integer k = new Integer(size);
            TreeSet s = (TreeSet)this.m_sizePage.get(k);
            Integer p0 = new Integer(page);
            Integer p1 = new Integer(page ^ size);
            if (s.contains(p0) && s.contains(p1)) {
                s.remove(p0);
                s.remove(p1);
                if (s.size() == 0) {
                    this.m_sizePage.remove(k);
                }
                int pp = Math.min(page, page ^ size);
                this.add(size * 2, pp);
                this.coalesce(size * 2, pp);
            }
        }

        private void add(int size, int page) {
            Integer k = new Integer(size);
            TreeSet<Integer> s = (TreeSet<Integer>)this.m_sizePage.get(k);
            if (s == null) {
                s = new TreeSet<Integer>();
                this.m_sizePage.put(k, s);
            }
            s.add(new Integer(page));
        }

        private int split(int size) {
            if (size > this.m_maxSize) {
                return -1;
            }
            Integer k = new Integer(size);
            Integer k2 = new Integer(2 * size);
            if (!this.m_sizePage.containsKey(k2) && this.split(2 * size) == -1) {
                return -1;
            }
            TreeSet s = (TreeSet)this.m_sizePage.get(k2);
            Integer p = (Integer)Buddy.getAny(s);
            s.remove(p);
            if (s.size() == 0) {
                this.m_sizePage.remove(k2);
            }
            this.add(size, p);
            this.add(size, p + size);
            return 0;
        }

        public void dump() {
            int i;
            System.out.println("maxSize=" + this.m_maxSize);
            System.out.println("freeList");
            Object[] keys = this.m_sizePage.keySet().toArray();
            Arrays.sort(keys);
            for (i = 0; i < keys.length; ++i) {
                System.out.print("  size=" + keys[i] + " pages={");
                TreeSet s = (TreeSet)this.m_sizePage.get(keys[i]);
                Iterator iter = s.iterator();
                while (iter.hasNext()) {
                    Integer p = (Integer)iter.next();
                    System.out.print(" " + p);
                }
                System.out.println(" }");
            }
            System.out.println("");
            System.out.println("usedList");
            keys = this.m_pageSize.keySet().toArray();
            Arrays.sort(keys);
            for (i = 0; i < keys.length; ++i) {
                System.out.println("  page=" + keys[i] + " size=" + this.m_pageSize.get(keys[i]));
            }
            System.out.println("");
        }

        private static Object getAny(Set s) {
            Object ret = null;
            Iterator iter = s.iterator();
            if (iter.hasNext()) {
                ret = iter.next();
            }
            return ret;
        }

        private static int round2(int size) {
            int ret;
            for (ret = 1; ret < size; ret *= 2) {
            }
            return ret;
        }
    }
}

