/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSTraceLogger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

final class Knobs
implements Comparable {
    private static final KnobValidator POSITIVELONG_VALIDATOR = new KnobValidator(){

        public Object validate(Object value) {
            Long lahng = (Long)value;
            if (lahng <= 0L) {
                throw new IllegalArgumentException("Expecting integer greater than 0, but got " + String.valueOf(lahng));
            }
            return lahng;
        }
    };
    private static final KnobValidator POSITIVEINTEGER_VALIDATOR = new KnobValidator(){

        public Object validate(Object value) {
            Integer integer = (Integer)value;
            if (integer <= 0) {
                throw new IllegalArgumentException("Expecting integer greater than 0, but got " + String.valueOf(integer));
            }
            return integer;
        }
    };
    static final String SERVER_POLL = "oc4j.jms.serverPoll";
    static final String MESSAGE_POLL = "oc4j.jms.messagePoll";
    static final String EXPIRATION_INTERVAL = "oc4j.jms.expirationInterval";
    static final String LISTENER_ATTEMPTS = "oc4j.jms.listenerAttempts";
    static final String MAX_OPEN_FILES = "oc4j.jms.maxOpenFiles";
    static final String INTRA_SESSION = "oc4j.jms.intraSession";
    static final String USE_UUID = "oc4j.jms.useUUID";
    static final String LAZY_SYNC = "oc4j.jms.lazySync";
    static final String SAVE_ALL_EXPIRED = "oc4j.jms.saveAllExpired";
    static final String USE_SOCKETS = "oc4j.jms.useSockets";
    static final String SOCKET_BUFSIZE = "oc4j.jms.socketBufsize";
    static final String USE_PERSISTENCE = "oc4j.jms.usePersistence";
    static final String DO_GC = "oc4j.jms.doGc";
    static final String DEBUG = "oc4j.jms.debug";
    static final String DEBUG_WAIT = "oc4j.jms.debugWait";
    static final String PRINTSTACKTRACE = "oc4j.jms.printStackTrace";
    static final String PSEUDO_TRANSACTION_ENLISTMENT = "oc4j.jms.pseudoTransactionEnlistment";
    static final String NO_DMS = "oc4j.jms.noDms";
    static final String NO_JMX = "oc4j.jms.noJmx";
    static final String COMPUTE_MSGSIZE = "oc4j.jms.computeMsgsize";
    static final String FORCE_RECOVERY = "oc4j.jms.forceRecovery";
    static final String PAGING_THRESHOLD = "oc4j.jms.pagingThreshold";
    static final String FORCE_PERSISTENCE = "oc4j.jms.forcePersistence";
    static final String RECONNECT_ATTEMPTS = "oc4j.jms.reconnectAttempts";
    static final String RECONNECT_WAIT = "oc4j.jms.reconnectWait";
    static final String HTTP_INITIAL_RESEND_INTERVAL = "oc4j.jms.httpInitialResendInterval";
    static final String HTTP_MAX_RESEND_INTERVAL = "oc4j.jms.httpMaxResendInterval";
    static final String HTTP_RESPONSE_TIMEOUT = "oc4j.jms.httpResponseTimeout";
    static final String CHECK_PERMISSIONS = "oc4j.jms.checkPermissions";
    static final String REMEMBER_ALL_XIDS = "oc4j.jms.rememberAllXids";
    private final String m_prop;
    private final String m_type;
    private final Object m_def;
    private Object m_val;
    private final String m_where;
    private final boolean m_isdocumented;
    private final boolean m_runtimeConfig;
    private final String m_msg;
    private final KnobValidator m_validator;
    static final String JMS_CLIENT = "JMS client";
    static final String OC4J_SERVER = "OC4J server";
    private static final Map s_map = new HashMap();
    private static final Knobs[] s_knobs = new Knobs[]{new Knobs("oc4j.jms.serverPoll", "long", POSITIVELONG_VALIDATOR, new Long(15000L), "JMS client", true, true, "Control the time interval, in milliseconds, over which a JMS client\nconnection polls the OC4J server to see if the server is still alive.\nIf a server death is detected, the JMS client connection will attempt\nto invoke its exception listener (if one has been configured).\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS connections within that\nJVM.\n\nUnreasonable values for the server poll interval (i.e. 0 or negative)\nwill be ignored and the default used.\n"), new Knobs("oc4j.jms.messagePoll", "long", POSITIVELONG_VALIDATOR, new Long(1000L), "JMS client", true, true, "Control the time interval, in milliseconds, of the maximum amount of\ntime a JMS client message consumer will wait during blocking receives\nand message listeners, before polling the OC4J server to see if the\nreceive can be satisfied.\n\nThis value does not apply to \"receiveNoWait()\".\n\nThis value applies to a timed receive only if the wait interval\nspecified in the receive call is larger than the poll interval.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS consumers within that\nJVM.\n\nUnreasonable values for the message poll interval (i.e. 0 or negative)\nwill be ignored and the default used.\n"), new Knobs("oc4j.jms.expirationInterval", "long", POSITIVELONG_VALIDATOR, new Long(60000L), "OC4J server", false, false, "Control the time interval, in milliseconds, at which the OC4J JMS\nserver-side message expiration task will run.  A JMS client will never\nsee expired messages, regardless of the value of this interval, but the\nexpired message objects themselves will be cleaned out of the server\n(and persistence files, if any) only periodically, as controlled by\nthis interval.\n\nExcessively frequent expiration can degrade server performance.\n\nThe system property should be set when starting the OC4J server, and\nremains in until the server is shutdown.\n\nUnreasonable values for the expiration interval (i.e. 0 or negative)\nwill be ignored and the default used.\n"), new Knobs("oc4j.jms.listenerAttempts", "int", POSITIVEINTEGER_VALIDATOR, new Integer(5), "JMS client", true, true, "Control the maximum number of times a message will be delivered by a\nJMS session to a message listener before considering the message to\nhave been `processed'.\n\nA session does not consider a message to have been successfully\nprocessed by a listener until the listener returns from the call to\n`onMessage()' without throwing any exceptions (or throwing exceptions\nonly after invoking one of `commit()', `rollback()', or `recover()' on\nthe session delivering the message, or invoking `acknowledge()' on the\nmessage itself).\n\nIf the listener does throw exceptions (as above), the session will\nattempt to immediately redeliver the original message to the listener\n(no JMS headers in the message will be changed, and all changes made to\nthe message by the previous invocation of the listener will be\ndiscarded).\n\nAfter the maximum number of attempts has been reached, the session will\nmove the message to the OC4J JMS exception queue, and proceed to the\nnext message.  When moving the undeliverable message to the exception\nqueue, OC4J will use the delivering session for message enqueue---this\nmeans that if the session is later recovered or rolledback, the\nexception message will be removed from the exception queue, and the\noriginal message (with appropriate redelivery properties updated) will\nbe retained in the original destination.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS consumers within that\nJVM.\n\nUnreasonable values for the listener attempts value (i.e. 0 or negative)\nwill be ignored and the default used.\n"), new Knobs("oc4j.jms.maxOpenFiles", "int", POSITIVEINTEGER_VALIDATOR, new Integer(64), "OC4J server", true, true, "Control the maximum number of persistence files that the OC4J server\nwill keep open at any given time.\n\nPersistence files are used to store messages sent to non-temporary\ndestinations that have been configured (via `config/jms.xml') to use\nfile-based persistence.\n\nIn order to limit the number of open files (and open file descriptors),\nthe OC4J server will not keep open more than the configured maximum\nnumber of files.  If more persistent destinations are configured and\naccessed, the OC4J server will use an LRU scheme to close those files\nnot in use and (re)open files for use by other destinations as\nnecessary.\n\nThe maximum number of open files does not limit the total number of\ndestinations (persistent or otherwise) that can be configured and used\nin an OC4J server.\n\nThis parameter also does not apply to temporary destinations since\nthese destinations cannot be persistified.\n\nThe system property should be set when starting the OC4J server, and\nremains in until the server is shutdown.\n\nUnreasonable values for the maximum number of open files (i.e. 0 or\nnegative) will be ignored and the default used.\n"), new Knobs("oc4j.jms.intraSession", "boolean", new Boolean(true), "OC4J server", false, "Control if a message can be sent and subsequently received in the same\ntransaction within a transacted session.\n\nBy default, sent messages are visible for receives within the same\ntransaction/transacted session, even before commit.\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n\nJMS client-side behavior w.r.t. intra-session visibility of messages is\ncontrolled by the OC4J server setting.\n"), new Knobs("oc4j.jms.useUUID", "boolean", new Boolean(false), "JMS client", false, "Control whether to use a cryptographically secure, but significantly\nresource/time expensive, universally unique identifier (UUID) generator\nin the OC4J JMS server and all JMS clients.\n\nUUIDs offer better guarantees of uniqueness and do not leak information\nabout the system.\n\nIf UUIDs are disabled, the OC4J JMS server and all JMS clients assume\nthat the value:\n\nhostname.UID\n\nis unique prefix across all JVMs and hosts.  The `UID' is an intra-host\nunique ID as generated by `java.rmi.server.UID'.  The JDK documents the\nconditions under which UID is intra-host unique.  The `hostname.UID'\nprefix is used within each JVM to generate unique IDs.\n\nIf the condition of uniqueness does not hold true, very bad things can\nhappen at the JMS client and the OC4J server.\n\nCaveat user.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS operations within that\nJVM.\n"), new Knobs("oc4j.jms.lazySync", "boolean", new Boolean(false), "OC4J server", false, "Flush data to persistence files only at significant commit/rollback\npoints.  Normal data writes will be buffered.\n\nEnabling lazy syncs can significantly improve the performance of\npersistent JMS destinations, but may result in greater corruption of\nmessages and transactions, depending on how much data the IO subsystem\nbuffers, how much data is partially written to disk (partial writes are\ndangerous since they are equivalent to corrupted writes when a failure\noccurs), and in what order the buffered data is written to files.\n\nCaveat user.\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n"), new Knobs("oc4j.jms.saveAllExpired", "boolean", null, new Boolean(false), "OC4J server", true, true, "Save all expired messages in the OC4J JMS exception queue, even if the\nmessages are part of a non-persistent or temporary destination.\n\nBy default, only messages on persistent destinations will be saved to\nthe exception queue on expiration.\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n"), new Knobs("oc4j.jms.useSockets", "boolean", new Boolean(false), "JMS client", false, "Control whether to always use TCP/IP sockets to communicate between the\nJMS client and OC4J JMS server.\n\nThe default is to use normal procedure calls to communicate between a\nweb or ejb client and an OC4J server within the same JVM.\n\nUsing TCP/IP or procedures calls are functionally identical, but may\nhave different performance characteristics.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS operations within that\nJVM.\n"), new Knobs("oc4j.jms.socketBufsize", "int", new KnobValidator(){

        public Object validate(Object newValue) {
            int MAX_BUFSIZE = 8192;
            Integer integer = (Integer)newValue;
            if (integer < 1 || integer > MAX_BUFSIZE) {
                throw new IllegalArgumentException("Expecting Integer in the range: 0<bufsize<=" + String.valueOf(MAX_BUFSIZE) + ", " + "but got " + String.valueOf(integer));
            }
            return integer;
        }
    }, new Integer(65536), "JMS client", true, false, "Use the specified buffer size per TCP/IP socket for socket-based\ninput/output streams.  This knob is relevant only for remote\napplication clients and for OC4J container clients when socket\ncommunication is forced.\n\nThe buffer size per socket is limited to a minimum value of 8kBytes.\nThe primary effect of changing buffer size is in the performance of\nmessage enqueue/dequeue---larger messages will benefit from larger\nbuffer sizes.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS operations within that\nJVM.\n"), new Knobs("oc4j.jms.usePersistence", "boolean", new Boolean(false), "OC4J server", false, "Control whether to use file-based persistence for any JMS suitably\nconfigured destination or for the OC4J JMS exception queue.\n\nBy default, file-based persistence is disabled everywhere.  This flag\nmust be used to enable file-based persistence in standalone mode, or in\nconfigurations where there will be no sharing violations of the\npersistence files.\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n"), new Knobs("oc4j.jms.doGc", "boolean", new Boolean(false), "JMS client", false, "Control whether the JMS libraries and OC4J JMS server will explicitly\ninvoke the JVM's garbage collector at specific program points:\nconnection creation/termination, and initialization/shutdown.\n\nFor well-written JMS programs that clean up their state by calling\n`close()' on all JMS objects they create, this option is not required.\nBadly written JMS programs may need to force garbage collection to\navoid running out of JVM and operating system resources.\n\nFinally, garbage collection is not a panacea for bad resource\nmanagement, since the JVM never guarantees that finalizers for orphaned\nobjects will ever execute.  There is no substiture for well-written\nsoftware.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients) and remains in effect for all JMS operations within that\nJVM.\n"), new Knobs("oc4j.jms.debug", "boolean", null, new Boolean(false), "JMS client", true, true, "Control whether JMS clients and the OC4J JMS server will log `NORMAL'\ntrace events.  By default, NORMAL events are not logged.  Turning on\ntracing will produce copious output useful for debugging, but little\nelse.\n\nOther OC4J log events: warnings, errors, and critical errors will\nalways be logged regardless of the setting of this knob.\n\nEvents are logged to `stderr' always (on remote application clients and\nthe OC4J JMS server).  Events generated in the OC4J JMS server are also\nlogged to either the `server.log' or `jms.log', depending on when the\nevent occurred---events that occur before the JMS server is completely\ninitialized may be logged to `server.log'; other events will be logged\nto `jms.log'.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n"), new Knobs("oc4j.jms.debugWait", "boolean", null, new Boolean(false), "JMS client", false, false, ""), new Knobs("oc4j.jms.printStackTrace", "boolean", null, new Boolean(false), "JMS client", true, true, "Control whether JMS clients and the OC4J JMS server will print, to\nstderr, the stack trace of exceptions thrown, caught internally, and\nlogged.\n\nBy default, only the exception message is printed to stderr.  Detailed\nexception stack traces are written only to the server-side logs (for\nexceptions thrown on the OC4J JMS server).\n\nThis control knob does not affect exceptions that are not logged but\npropagated to the client .\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n"), new Knobs("oc4j.jms.pseudoTransactionEnlistment", "boolean", null, new Boolean(false), "JMS client", false, true, "WARNING: This feature will not exist in 11g.\n\nWhen true, all JMS Sessions (XA and non-XA) will be enlisted into\nglobal transactions, which is in violation of J2EE 1.4 and associated specs.\n\nThis knob exists to allow pre-existing applications using unsupported,\nnon-compliant JMS semantics to continue to run following the implementation\nof fully JMS-compliant behavior in 10.1.3.1.0.\n\nUsers are cautioned that enabling this flag will have uncertain results in other\nJMS applications that expect compliant behavior (i.e. BPEL, ESB, etc.).\n\n"), new Knobs("oc4j.jms.noDms", "boolean", null, new Boolean(false), "JMS client", true, true, "Control whether JMS clients and the OC4J JMS server collect DMS\nstatistics or not.  By default, DMS statistics are collected for all\nrelevant objects.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n"), new Knobs("oc4j.jms.noJmx", "boolean", null, new Boolean(false), "JMS client", false, true, "Control whether JMS clients and the OC4J JMS server perform JMX\ninstrumentation or not.  By default, JMX instrumentation is performed\nfor all relevant objects.  The setting of this option does not affect\nJMX management of the OC4J JMS server (which is always enabled and\navailable).\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n"), new Knobs("oc4j.jms.computeMsgsize", "boolean", new Boolean(false), "JMS client", false, "Control whether JMS clients and the OC4J JMS server compute a valid\nsize (in bytes) for JMS message objects.  Since the computation of\nmessage size is an expensive operation, it is disabled by default.  DMS\nstatistics pertaining to message sizes (and, indirectly, store sizes)\nwill be inaccurate unless this control knob is enabled.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n"), new Knobs("oc4j.jms.forceRecovery", "boolean", null, new Boolean(false), "OC4J server", true, true, "Control whether the OC4J JMS server forcibly recovers corrupted\npersistence files.\n\nForcible recovery will almost always enable the OC4J JMS server to\ncorrectly startup and make the persistence files/destinations available\nfor use, but at the cost of losing messages and/or masking user\nmisconfiguration.  Therefore, forcible recovery is disabled by\ndefault.  If the OC4J JMS server is unable to correctly recover from\ncorrupted persistence files, enabling this knob may help.\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n"), new Knobs("oc4j.jms.pagingThreshold", "double", new KnobValidator(){

        public Object validate(Object value) {
            Double dubble = (Double)value;
            if (dubble < 0.0 || dubble > 1.0) {
                throw new IllegalArgumentException("Expecting Double in the range: 0<=threshold<=1.0, but got " + String.valueOf(dubble));
            }
            return dubble;
        }
    }, new Double(1.0), "OC4J server", true, true, "Control whether the OC4J JMS server will page out message bodies to\npersistence files when the server JVM runs low on memory.\n\nIf the value (1-freeMemory/totalMemory) (i.e. the ratio of allocated to\ntotal memory in the JVM) goes over the value of this control knob, the\nOC4J JMS server will attempt to page out the message bodies.  If the\nvalue of allocated to total memory in the JVM falls below specified the\nthreshold the OC4J JMS server will retain message bodies in JVM\nmemory.\n\nBy default, no paging is enabled, i.e. the value of the knob is 1.0.\nSetting it to 0.0 forces paging always.  Only message bodies are\nconsidered for paging---message headers and properties are never\npaged.  Messages sent to non-persistent destinations or having a\nnon-persistent delivery mode are never considered for paging.\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n\nUnreasonable values for the paging threshold (i.e. outside the range\n[0,1]) will be folded to the nearest value in the valid range, i.e.\nnegative values will mean 0, and values greater than 1 will mean 1.\n"), new Knobs("oc4j.jms.forcePersistence", "boolean", new Boolean(true), "OC4J server", false, "Control whether to force file-based persistence for OC4J JMS.\n\nBy default, file-based persistence is disabled everywhere.  If this\nflag is enabled, it overrides all other persistence-related settings\n(including other control knobs and the presence/absence of OPMN and\nother clustering services/environments).\n\nThe system property should be set when starting the OC4J server, and\nremains in effect for all JMS clients (application, web, and ejb),\nuntil the server is shutdown.\n"), new Knobs("oc4j.jms.reconnectAttempts", "int", POSITIVEINTEGER_VALIDATOR, new Integer(0), "JMS client", true, false, "Control the number of attempts an application-client (or more\ngenerally, a remote client) will attempt to reconnect to the OC4J JMS\nserver, after network communication failure.\n\nBy default, the JMS client does not attempt to reconnect with the\nserver, and throws a JMSException to the application code, immediately\nafter a network communication failure is detected.  In other words, the\nnumber of reconnect attempts is \"0\".\n\nA positive value indicates that the JMS client will use a combination\nof exponential backoff and reconnects, until the limit has been\nreached, at which time it will throw a JMSException to the\napplication.\n\nIf any reconnect attempt succeeds, the remote client attempts to\nrecreate its pre-failure state (to the extent possible) on the OC4J JMS\nserver, and also resets its internal reconnection attempt counter (so\nthat subsequent failures will cause reconnection to start from\nscratch).\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n\nUnreasonable values for the reconnect attempts (i.e. negative values)\nwill be ignored and the default used.\n"), new Knobs("oc4j.jms.reconnectWait", "long", POSITIVELONG_VALIDATOR, new Long(30000L), "JMS client", true, false, "Control the starting wait time for the exponential backoff algorithm\nused by JMS clients in attempting to reconnect with the OC4J JMS server\nafter network communication failure.\n\nThe 1st reconnection is attempted after the specified wait time.  The\n2nd reconnection is attempted after 2*the specified wait time.  The 3rd\nreconnection is attempted after 2*2*the specified wait time, and so on,\nuntil the Nth reconnection is attempted after (2**(N-1))*the specified\nwait time.\n\nThe system property should be set when starting a JMS application\nclient program, or when starting the OC4J server (for web and ejb\nclients and the JMS server itself) and remains in effect for all\noperations within that JVM.\n\nUnreasonable values for the reconnect attempts (i.e. 0 or negative\nvalues) will be ignored and the default used.\n"), new Knobs("oc4j.jms.httpInitialResendInterval", "long", POSITIVELONG_VALIDATOR, new Long(5000L), "JMS client", true, false, "Control the intitial wait time for the backoff algorithm used by\nJMS clients in attempting to reconnect with the JMS HTTP tunnelling\nServlet after network communication failure.\n\nThe 1st reconnection is attempted after the specified wait time.  The\n2nd reconnection is attempted after 2*the specified wait time.  The 3rd\nreconnection is attempted after 2*2*the specified wait time, and so on,\nuntil the wait time reaches the value specified by the\noc4j.jms.httpMaxResendInterval value.  Reconnection attempts will\neventually stop when the sum of all waits is greater than or equal to\nthe value of oc4j.jms.httpResponseTimeout.\n\nThe system property should be set when starting a JMS application\nclient program and remains in effect for for all operations within\nthat JVM.\n\nUnreasonable values for the reconnect attempts (i.e. 0 or negative\nvalues) will be ignored and the default used.\n"), new Knobs("oc4j.jms.httpMaxResendInterval", "long", POSITIVELONG_VALIDATOR, new Long(30000L), "JMS client", true, false, "Control the maximum wait time interval for the backoff algorithm used\nby JMS clients in attempting to reconnect with the JMS HTTP tunnelling\nServlet after network communication failure.\n\nThe 1st reconnection is attempted after the specified wait time.  The\n2nd reconnection is attempted after 2*the specified wait time.  The 3rd\nreconnection is attempted after 2*2*the specified wait time, and so on,\nuntil the wait time reaches the value specified by the\noc4j.jms.httpMaxResendInterval value.  Reconnection attempts will\neventually stop when the sum of all waits is greater than or equal to\nthe value of oc4j.jms.httpResponseTimeout.\n\nThe system property should be set when starting a JMS application\nclient program and remains in effect for for all operations within\nthat JVM.\n\nUnreasonable values for the reconnect attempts (i.e. 0 or negative\nvalues) will be ignored and the default used.\n"), new Knobs("oc4j.jms.httpResponseTimeout", "long", POSITIVELONG_VALIDATOR, new Long(600000L), "JMS client", true, false, "Control the maximum ammount of nterval for the backoff algorithm used\nby JMS clients in attempting to reconnect with the JMS HTTP tunnelling\nServlet after network communication failure.\n\nThe 1st reconnection is attempted after the specified wait time.  The\n2nd reconnection is attempted after 2*the specified wait time.  The 3rd\nreconnection is attempted after 2*2*the specified wait time, and so on,\nuntil the wait time reaches the value specified by the\noc4j.jms.httpMaxResendInterval value.  Reconnection attempts will\neventually stop when the sum of all waits is greater than or equal to\nthe value of oc4j.jms.httpResponseTimeout.\n\nThe system property should be set when starting a JMS application\nclient program and remains in effect for for all operations within\nthat JVM.\n\nUnreasonable values for the reconnect attempts (i.e. 0 or negative\nvalues) will be ignored and the default used.\n"), new Knobs("oc4j.jms.checkPermissions", "boolean", null, new Boolean(false), "OC4J server", false, true, "Control whether access/authorization checks are performed on enqueue,\ndequeue, or browse operations on JMS destinations.\n\nAuthorization is role/destination/operation based.  In other words, an\noperation succeeds only if the current user for the JMS connection has\nbeen granted the appropriate com.evermind.server.jms.JMSPermission for\nthe relevant OC4J JMS destination and for the operation currently being\nattempted.\n\nIf any of these 3 checks fails, the entire operation fails with a\nJMSSecurityException.\n\nThe system property should be set when starting the OC4J server, and\nremains in until the server is shutdown.\n\n"), new Knobs("oc4j.jms.rememberAllXids", "boolean", null, new Boolean(false), "OC4J server", false, true, "Control whether the OC4J JMS server remembers the Xids of prepared\nglobal transaction branches that do not involve any persistent\ndestinations.\n\nBy default, OC4J JMS remembers and presents to the transaction manager\n(on XAResource.recover()) only those Xids for transaction branches that\ninvolve at least one persistent destination.  Xids for transaction\nbranches that involve only non-persistent and temporary destinations\nare silently discarded since the changes made to these types of\ndestinations are never recoverable.\n\nEnabling this control knob will cause the OC4J JMS server to remember\nand recover all Xids (regardless of the mix of persistent,\nnon-persistent, and temporary destinations involved in the transaction\nbranches).  The commit/rollback recovery of transaction branches that\ndo not involve any persistent destinations is a noop.\n\nThis option has no relevance to normal XAResource operation.  It is\nmeaningful only for crash recovery.\n\nThe system property should be set when starting the OC4J server, and\nremains in until the server is shutdown.\n\n")};
    private static final JMSTraceLogger s_traceLogger;

    private Knobs(String prop, String type, Object def, String where, boolean isdocumented, String msg) {
        this(prop, type, null, def, where, isdocumented, false, msg);
    }

    private Knobs(String prop, String type, KnobValidator validator, Object def, String where, boolean isdocumented, boolean runtimeConfig, String msg) {
        this.m_prop = prop;
        this.m_type = type;
        this.m_def = def;
        this.m_where = where;
        this.m_msg = msg;
        this.m_validator = validator;
        this.m_isdocumented = isdocumented;
        this.m_runtimeConfig = runtimeConfig;
        this.m_val = Knobs.load(this.m_prop, this.m_type, this.m_validator, this.m_def);
    }

    static Map getRuntimeConfigKnobs() {
        HashMap<String, Object> knobMap = new HashMap<String, Object>();
        for (int index = 0; index < s_knobs.length; ++index) {
            if (!Knobs.s_knobs[index].m_runtimeConfig || !Knobs.s_knobs[index].m_isdocumented) continue;
            knobMap.put(s_knobs[index].getProperty(), s_knobs[index].getValue());
        }
        return knobMap;
    }

    public int compareTo(Object o) {
        return o == null || !(o instanceof Knobs) ? -1 : this.m_prop.compareTo(((Knobs)o).m_prop);
    }

    String getProperty() {
        return this.m_prop;
    }

    String getType() {
        return this.m_type;
    }

    Object getDefault() {
        return this.m_def;
    }

    Object getValue() {
        return this.m_val;
    }

    void setValue(Object newValue) {
        if (!this.m_runtimeConfig) {
            throw new IllegalStateException(JMSMessages.getMessage("J2EE JMS-02620", this.m_prop));
        }
        this.m_val = this.m_validator != null ? this.m_validator.validate(newValue) : newValue;
    }

    String getWhere() {
        return this.m_where;
    }

    String getMessage() {
        return this.m_msg;
    }

    public String toString() {
        return "JVM property:  " + this.getProperty() + "\n" + "Type:          " + this.getType() + "\n" + "Default:       " + this.getDefault() + "\n" + "Current value: " + this.getValue() + "\n" + "Where:         " + this.getWhere() + "\n" + "Explanation:" + "\n" + "" + "\n" + "" + this.getMessage() + "\n" + "";
    }

    static String getProperty(final String prop) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(prop);
            }
        });
    }

    boolean isDocumented() {
        return this.m_isdocumented;
    }

    private static Object load(String prop, String type, KnobValidator validator, Object def) {
        Object ret = def;
        try {
            String propVal = Knobs.getProperty(prop);
            if (propVal != null) {
                Object val = Knobs.makeWrappedPrimitive(type, propVal);
                ret = validator != null ? validator.validate(val) : val;
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("load", ex);
        }
        return ret;
    }

    static Knobs findKnob(String name) {
        return s_map.containsKey(name) ? (Knobs)s_map.get(name) : null;
    }

    static Object getKnob(String name) {
        Knobs k = Knobs.findKnob(name);
        return k == null ? null : k.getValue();
    }

    static void setKnob(String name, Object newValue) {
        Knobs k = Knobs.findKnob(name);
        if (k == null) {
            return;
        }
        k.setValue(newValue);
    }

    static void state(DummyStats jStats) {
        for (int i = 0; i < s_knobs.length; ++i) {
            if (!s_knobs[i].isDocumented()) continue;
            jStats.state(s_knobs[i].getProperty(), s_knobs[i].getValue(), true);
        }
    }

    static Knobs[] getKnobs() {
        return s_knobs;
    }

    static String makeString() {
        String ret = "OC4J JMS configuration knobs:\n";
        for (int i = 0; i < s_knobs.length; ++i) {
            if (!s_knobs[i].isDocumented()) continue;
            ret = ret + s_knobs[i].toString();
        }
        return ret;
    }

    static Object makeWrappedPrimitive(String type, String str) {
        Comparable<Boolean> wrappedValue = null;
        boolean cantCast = false;
        try {
            if (type.equals("boolean") && str.equals("true")) {
                wrappedValue = new Boolean(true);
            } else if (type.equals("boolean") && str.equals("false")) {
                wrappedValue = new Boolean(false);
            } else if (type.equals("byte")) {
                wrappedValue = new Byte(str);
            } else if (type.equals("char") && str.length() == 1) {
                wrappedValue = new Character(str.charAt(0));
            } else if (type.equals("double")) {
                wrappedValue = new Double(str);
            } else if (type.equals("float")) {
                wrappedValue = new Float(str);
            } else if (type.equals("int")) {
                wrappedValue = new Integer(str);
            } else if (type.equals("long")) {
                wrappedValue = new Long(str);
            } else if (type.equals("short")) {
                wrappedValue = new Short(str);
            } else {
                cantCast = true;
            }
        }
        catch (Throwable ex) {
            cantCast = true;
        }
        if (cantCast) {
            throw new ClassCastException(JMSMessages.getMessage("J2EE JMS-02608", str, type));
        }
        return wrappedValue;
    }

    public static void main(String[] argv) {
        System.out.println("OC4J JMS 1.1\n");
        System.out.println(Knobs.makeString());
        System.exit(0);
    }

    static {
        try {
            for (int i = 0; i < s_knobs.length; ++i) {
                s_map.put(s_knobs[i].getProperty(), s_knobs[i]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_traceLogger = new JMSTraceLogger(Knobs.class);
    }

    private static interface KnobValidator {
        public Object validate(Object var1);
    }
}

