/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import com.evermind.server.jms.Tset;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jms.JMSException;

public class JMSObject {
    private final Object m_sync = new Object();
    private final String m_id;
    private final JMSObject m_parent;
    private final Tset m_isOpen = new Tset(true);
    private final Tset m_isStarted = new Tset(false);
    private final Tset m_isDirty = new Tset(false);
    private final Tset m_closeDone = new Tset(false);
    private final Set m_children = new HashSet();
    private final Map m_users = new HashMap();
    private final Map m_receivers = new HashMap();
    private DummyStats m_jstats;
    private boolean m_inPhase = false;
    private final Stack m_phase = new Stack();
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(JMSObject.class);
    private final long m_startTime;
    private static final long WAIT_POLL = 1000L;
    private static final boolean DEBUG_WAIT = (Boolean)JMSObject.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.debugWait");
    static final String METRIC_PATH = "Metric Path";

    protected JMSObject(final String pfx, JMSObject parent) {
        this.m_id = JMSUtils.newID(pfx);
        this.m_parent = parent;
        final String statsParent = this.m_parent == null ? "/JMS" : this.m_parent.m_jstats.getName();
        final String self = this.m_id;
        this.m_jstats = (DummyStats)JMSObject.getProxy().doSecureOpNoException(new SecureOperation(){

            public Object executeNoException() {
                return JMSObject.getProxy().createStats(statsParent, self, "JMS" + pfx);
            }
        });
        this.m_startTime = System.currentTimeMillis();
        this.state("startTime", new Long(this.m_startTime), true);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("finalize", ex);
        }
        super.finalize();
    }

    final String getID() {
        return this.m_id;
    }

    final DummyStats getJMSStats() {
        return this.m_jstats;
    }

    protected final void state(String state, Object val) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.state(state, val);
        }
    }

    protected final void state(String state, Object val, boolean ctor) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.state(state, val, ctor);
        }
    }

    protected final Object getStateValue(String state) {
        return JMSObject.getProxy().getDebug() ? this.m_jstats.getStateValue(state) : null;
    }

    protected final void initPhase(String state) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.initPhase(state);
        }
    }

    protected final void addPhase(String state, long time) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.addPhase(state, time);
        }
    }

    protected final long phase(String state) {
        return JMSObject.getProxy().getDebug() ? this.m_jstats.phase(state) : 0L;
    }

    protected final void phase(String state, long tok) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.phase(state, tok);
        }
    }

    protected final void event(String event) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.event(event);
        }
    }

    protected final void initEvent(String event) {
        if (JMSObject.getProxy().getDebug()) {
            this.m_jstats.initEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attach(JMSObject child) {
        Object object = this.m_sync;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (!this.m_isOpen.test() || !this.m_users.containsKey(t)) {
                JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02200", this, t));
            }
            Set set = this.m_children;
            synchronized (set) {
                this.m_children.add(new WeakReference<JMSObject>(child));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int children() {
        int ret = 0;
        Set set = this.m_children;
        synchronized (set) {
            JMSUtils.sync(this.m_children);
            ret = this.m_children.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JMSObject anyChild() {
        JMSObject ret = null;
        Set set = this.m_children;
        synchronized (set) {
            JMSUtils.sync(this.m_children);
            if (this.m_children.size() > 0) {
                ret = JMSUtils.get(this.m_children.iterator());
            }
        }
        return ret;
    }

    final boolean isOpen() {
        return this.m_isOpen.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isClosed() {
        boolean ret = false;
        Object object = this.m_sync;
        synchronized (object) {
            ret = !this.m_isOpen.test() && this.m_users.size() == 0;
        }
        return ret;
    }

    final boolean isStarted() {
        return this.m_parent == null ? this.m_isStarted.test() : this.m_parent.isStarted();
    }

    final boolean isDirty() {
        return this.m_isDirty.test();
    }

    final void touch() throws JMSException {
        if (!this.m_isDirty.testAndSet(true)) {
            this.dirtyFunc();
        }
    }

    final boolean lock(String func) throws JMSException {
        return this.lock(func, true, false, false);
    }

    final boolean lock(String func, boolean doDirty) throws JMSException {
        return this.lock(func, doDirty, false, false);
    }

    final boolean lockReceive(String func) throws JMSException {
        return this.lock(func, true, true, false);
    }

    final boolean lockXA(String func) throws JMSException {
        return this.lock(func, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lock(String func, boolean doDirty, boolean isReceive, boolean isXA) throws JMSException {
        Object object = this.m_sync;
        synchronized (object) {
            boolean ok;
            if (!isXA && !this.m_isOpen.test()) {
                JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-01602", this));
            }
            Thread t = Thread.currentThread();
            if (this.m_parent != null && !(ok = this.m_parent.lock(null, doDirty, isReceive, isXA))) {
                return false;
            }
            if (doDirty) {
                this.touch();
            }
            if (this.m_parent == null && isReceive) {
                if (!this.m_isStarted.test()) {
                    return false;
                }
                this.add("receiver", this.m_receivers, t);
            }
            this.add("user", this.m_users, t);
        }
        if (JMSObject.getProxy().getDebug()) {
            this.m_inPhase = true;
            this.pushPhase(func);
        }
        return true;
    }

    protected void dirtyFunc() throws JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unlock() {
        if (this.m_inPhase) {
            this.popPhase();
            this.m_inPhase = false;
        }
        Object object = this.m_sync;
        synchronized (object) {
            Thread t = Thread.currentThread();
            this.remove("user", this.m_users, t);
            if (this.m_receivers.containsKey(t)) {
                this.remove("receiver", this.m_receivers, t);
            }
            if (this.m_parent != null) {
                this.m_parent.unlock();
            }
            this.m_sync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeWait() {
        Object object = this.m_sync;
        synchronized (object) {
            this.m_isOpen.set(false);
            while (this.m_users.size() > 0) {
                this.printWaiters("user", this.m_users);
                JMSUtils.wait(this.m_sync, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeAll() throws JMSException {
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        Set set = this.m_children;
        synchronized (set) {
            Iterator iter = this.m_children.iterator();
            while (iter.hasNext()) {
                JMSObject child = JMSUtils.get(iter);
                if (child == null) continue;
                try {
                    child.close();
                }
                catch (Throwable ex) {
                    exList.add(ex);
                }
            }
            this.m_children.clear();
        }
        if (exList.size() > 0) {
            JMSUtils.toJMSException("close", exList);
        }
    }

    protected void localClose() throws JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws JMSException {
        try {
            this.closeWait();
            JMSObject jMSObject = this;
            synchronized (jMSObject) {
                if (!this.m_closeDone.testAndSet(true)) {
                    this.closeAll();
                    this.localClose();
                }
            }
        }
        finally {
            this.close(this.m_jstats);
        }
    }

    final void startAll() {
        if (this.m_parent != null) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02201", this, "start"));
        }
        this.m_isStarted.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stopWait() {
        if (this.m_parent != null) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02201", this, "stop"));
        }
        this.m_isStarted.set(false);
        Object object = this.m_sync;
        synchronized (object) {
            while (this.m_receivers.size() > 0) {
                this.printWaiters("receivers", this.m_receivers);
                JMSUtils.wait(this.m_sync, 1000L);
            }
        }
    }

    protected void localNextTrans() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void nextTrans() {
        Set set = this.m_children;
        synchronized (set) {
            Iterator iter = this.m_children.iterator();
            while (iter.hasNext()) {
                JMSObject child = JMSUtils.get(iter);
                if (child == null) {
                    iter.remove();
                    continue;
                }
                try {
                    child.localNextTrans();
                }
                catch (Throwable ex) {
                    s_traceLogger.fine("nextTrans", ex);
                }
            }
        }
    }

    protected long getStartTime() {
        return this.m_startTime;
    }

    protected static JMSServerProxy getProxy() {
        return JMSServerProxy.getProxy();
    }

    private void add(String pfx, Map m, Thread t) {
        int count = 1;
        if (m.containsKey(t)) {
            Integer i = (Integer)m.get(t);
            count = i + 1;
        }
        m.put(t, new Integer(count));
    }

    private void remove(String pfx, Map m, Thread t) {
        int count = 0;
        if (m.containsKey(t)) {
            Integer i = (Integer)m.get(t);
            count = i - 1;
        } else {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02202", this, pfx, t));
        }
        if (count > 0) {
            m.put(t, new Integer(count));
        } else if (count == 0) {
            m.remove(t);
        } else if (count < 0) {
            JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02203", this, pfx, t, new Integer(count)));
        }
    }

    private void printWaiters(String pfx, Map m) {
        if (DEBUG_WAIT) {
            Thread t = Thread.currentThread();
            s_traceLogger.fine("{0}: {1} waiting for locks on {2}", new Object[]{this.m_id, t, pfx});
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Thread ut = (Thread)entry.getKey();
                Integer i = (Integer)entry.getValue();
                s_traceLogger.fine("    {0} -> {1}", new Object[]{ut, i});
            }
        }
    }

    private void pushPhase(String func) {
        try {
            this.m_phase.push(new ActivationRecord(func, JMSUtils.isNull(func) ? 0L : this.m_jstats.phase(func)));
        }
        catch (Throwable ex) {
            s_traceLogger.fine("pushPhase", ex);
        }
    }

    private void popPhase() {
        try {
            ActivationRecord rec = (ActivationRecord)this.m_phase.pop();
            if (!JMSUtils.isNull(rec.getFunc())) {
                this.m_jstats.phase(rec.getFunc(), rec.getTok());
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("popPhase", ex);
        }
    }

    public void close(final DummyStats stats) {
        JMSObject.getProxy().doSecureOpNoException(new SecureOperation(){

            public Object executeNoException() {
                stats.close();
                return null;
            }
        });
    }

    private static final class ActivationRecord {
        String m_func;
        long m_tok;

        public ActivationRecord(String func, long tok) {
            this.m_func = func;
            this.m_tok = tok;
        }

        public String getFunc() {
            return this.m_func;
        }

        public long getTok() {
            return this.m_tok;
        }
    }
}

