/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindQueueConnectionFactory;
import com.evermind.server.jms.EvermindXAConnection;
import com.evermind.server.jms.EvermindXAQueueConnection;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;

public final class EvermindXAQueueConnectionFactory
extends EvermindQueueConnectionFactory
implements XAQueueConnectionFactory {
    static final long serialVersionUID = -6210377483139904575L;

    EvermindXAQueueConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID) {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, true);
    }

    public synchronized XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(this.getUser(), this.getPass());
    }

    public synchronized XAConnection createXAConnection(final String user, final String pass) throws JMSException {
        XAConnection conn = null;
        try {
            conn = (XAConnection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindXAQueueConnectionFactory.this.unprivileged_createXAConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private XAConnection unprivileged_createXAConnection(String user, String pass) throws JMSException {
        return new EvermindXAConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID(), 2);
    }

    public synchronized XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(this.getUser(), this.getPass());
    }

    public synchronized XAQueueConnection createXAQueueConnection(final String user, final String pass) throws JMSException {
        XAQueueConnection conn = null;
        try {
            conn = (XAQueueConnection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindXAQueueConnectionFactory.this.unprivileged_createXAQueueConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private XAQueueConnection unprivileged_createXAQueueConnection(String user, String pass) throws JMSException {
        return new EvermindXAQueueConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID());
    }
}

