/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.EvermindConnectionConsumer;
import com.evermind.server.jms.EvermindConnectionMetaData;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.EvermindXASession;
import com.evermind.server.jms.HTTPJMSRemoteServer;
import com.evermind.server.jms.JMSCommands;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.TCPJMSRemoteServer;
import com.evermind.server.jms.Tset;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.j2ee.statistics.JMSConnectionStats;
import javax.management.j2ee.statistics.JMSSessionStats;

public class EvermindConnection
extends JMSObject
implements Connection,
JMSDomain {
    private final JMSConnectionStats m_stats;
    private final Tset m_regDone = new Tset(false);
    private ExceptionListener m_exListener = null;
    private Thread m_thr = null;
    private JMSException m_previousException = null;
    private final String m_user;
    private final String m_tunnel;
    private final String m_keystore;
    private final String m_keystorePassword;
    private final String m_truststore;
    private final String m_truststorePassword;
    private final String m_provider;
    private final boolean m_isXA;
    private final int m_domain;
    private String m_clientID = null;
    private final boolean m_preset;
    private final Map m_qs = new HashMap();
    private final Map m_ts = new HashMap();
    private JMSCommands m_svr = null;
    private final Tset m_isLocal = new Tset(false);
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindConnection.class);
    private static final boolean USE_SOCKETS = (Boolean)EvermindConnection.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.useSockets");
    private static long s_pollInterval = (Long)EvermindConnection.getProxy().getPropertiesController().listenToConfigProperty("oc4j.jms.serverPoll", new ConfigPropertyListener(){

        public void onConfigPropertyChange(ConfigPropertyEvent event) {
            EvermindConnection.setPollInterval((Long)event.getPropertyValue());
        }
    });

    EvermindConnection(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass) throws JMSException {
        this(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, null, false, 2);
    }

    EvermindConnection(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA, int domain) throws JMSException {
        super("Connection", null);
        this.m_user = user;
        this.m_tunnel = JMSUtils.fold(tunnel);
        this.m_keystore = keystore;
        this.m_keystorePassword = keystorePassword;
        this.m_truststore = truststore;
        this.m_truststorePassword = truststorePassword;
        this.m_provider = provider;
        this.m_isXA = isXA;
        this.m_domain = domain;
        this.m_clientID = clientID;
        this.m_preset = !JMSUtils.isNull(this.m_clientID);
        try {
            JMSUtils.gc();
            if (!USE_SOCKETS) {
                this.m_svr = EvermindConnection.getProxy().getJMSServer(addr, port, user, pass);
            }
            if (this.m_svr == null) {
                this.m_svr = this.m_tunnel.equals("") ? new TCPJMSRemoteServer(addr, port, user, pass) : new HTTPJMSRemoteServer(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass);
            } else {
                this.m_isLocal.set(true);
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01200", addr, new Integer(port), user), ex);
        }
        if (this.m_preset) {
            this.touch();
        }
        this.state("user", JMSUtils.fold(this.m_user), true);
        this.state("domain", JMSUtils.pp(this.m_domain), true);
        this.state("isLocal", new Boolean(this.m_isLocal.test()), true);
        this.state("isXA", new Boolean(this.m_isXA), true);
        if (!this.m_isLocal.test()) {
            this.state("address", addr, true);
            this.state("host", JMSUtils.normalize(addr), true);
            this.state("port", new Integer(port), true);
        }
        EvermindConnection.getProxy().setJMSConnectionMBean(this.getJMSStats(), this, this.getStartTime(), this.m_isLocal.test(), addr, port);
        this.m_stats = EvermindConnection.getProxy().getJMSConnectionStats(this.getJMSStats().getName());
        this.state("stats", this.m_stats, true);
        EvermindConnection.getProxy().addConnection(this.m_stats);
    }

    public String toString() {
        return JMSUtils.pp(this.m_isXA, this.m_domain) + "Connection[" + this.getID() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ConnectionConsumer createConnectionConsumer(Destination dest, String selector, ServerSessionPool pool, int maxMessages) throws JMSException {
        this.lock("createConnectionConsumer");
        try {
            this.checkMaxMessages(maxMessages);
            EvermindConnectionConsumer evermindConnectionConsumer = new EvermindConnectionConsumer(this, dest, null, selector, pool, maxMessages);
            return evermindConnectionConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ConnectionConsumer createDurableConnectionConsumer(Topic t, String name, String selector, ServerSessionPool pool, int maxMessages) throws JMSException {
        this.lock("createDurableConnectionConsumer");
        try {
            this.checkMaxMessages(maxMessages);
            JMSUtils.assertDomain(this, 1, this.m_domain);
            if (JMSUtils.isNull(name)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01201", this));
            }
            EvermindConnectionConsumer evermindConnectionConsumer = new EvermindConnectionConsumer(this, (Destination)t, name, selector, pool, maxMessages);
            return evermindConnectionConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Session createSession(boolean transacted, int ackMode) throws JMSException {
        this.lock("createSession");
        try {
            EvermindSession evermindSession = this.isXA() ? new EvermindXASession(this, 2) : new EvermindSession(this, transacted, ackMode, false, 2);
            return evermindSession;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String getClientID() throws JMSException {
        this.lock("getClientID", false);
        try {
            String string = this.m_clientID;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ExceptionListener getExceptionListener() throws JMSException {
        this.lock("getExceptionListener");
        try {
            ExceptionListener exceptionListener = this.m_exListener;
            return exceptionListener;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ConnectionMetaData getMetaData() throws JMSException {
        this.lock("getMetaData");
        try {
            EvermindConnectionMetaData evermindConnectionMetaData = new EvermindConnectionMetaData(this.m_svr.getJMSProviderName());
            return evermindConnectionMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setClientID(String id) throws JMSException {
        this.lock("setClientID", false);
        try {
            if (this.m_preset) {
                JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-01203", this, id, this.m_clientID));
            }
            if (this.isDirty()) {
                JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-01202", this, id));
            }
            JMSUtils.checkNull("setClientID", "clientID", id);
            this.m_clientID = id;
            this.touch();
            this.state("clientID", JMSUtils.fold(this.m_clientID), true);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setExceptionListener(ExceptionListener exListener) throws JMSException {
        this.lock("setExceptionListener");
        try {
            this.doListener(exListener);
            this.state("exceptionListener", exListener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws JMSException {
        this.lock("start");
        try {
            this.startAll();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() throws JMSException {
        this.lock("stop");
        try {
            this.stopWait();
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized List getDefinedQueueNames() {
        try {
            this.getDestinations(false);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getDefinedQueueNames", ex);
        }
        return new ArrayList(this.m_qs.keySet());
    }

    public final synchronized List getDefinedTopicNames() {
        try {
            this.getDestinations(false);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getDefinedTopicNames", ex);
        }
        return new ArrayList(this.m_ts.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String getKnobs() throws JMSException {
        this.lock("getKnobs");
        try {
            String string = this.getServer().getKnobs();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String getStats() throws JMSException {
        this.lock("getStats");
        try {
            String string = this.getServer().getStats();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List listDestinations() throws JMSException {
        this.lock("listDestinations");
        try {
            List list = this.getServer().getDestinations(false);
            return list;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List listDurables() throws JMSException {
        this.lock("listDurables");
        try {
            List list = this.getServer().getDurables();
            return list;
        }
        finally {
            this.unlock();
        }
    }

    public JMSConnectionStats getJMSConnectionStats() {
        return this.m_stats;
    }

    public final boolean isXA() {
        return this.m_isXA;
    }

    public final int getDomain() {
        return this.m_domain;
    }

    protected void localClose() throws JMSException {
        this.doListener(null);
        this.clearTemporaries();
        if (this.getServer() != null) {
            this.getServer().closeConnection();
        }
        EvermindConnection.getProxy().removeConnection(this.m_stats);
    }

    protected final void dirtyFunc() throws JMSException {
        this.registerConnection();
    }

    void add(JMSSessionStats s, boolean transacted) {
        EvermindConnection.getProxy().addSession(this.m_stats, s, transacted);
    }

    void remove(JMSSessionStats s) {
        EvermindConnection.getProxy().removeSession(this.m_stats, s);
    }

    JMSCommands getServer() throws JMSException {
        if (this.m_isLocal.test()) {
            EvermindConnection.getProxy().setState(this.m_clientID, this.getID(), true);
            EvermindConnection.getProxy().verifyJMSServer(this.m_svr);
        }
        return this.m_svr;
    }

    final String clientID() {
        return this.m_clientID;
    }

    final String getUser() {
        return this.m_user;
    }

    final synchronized Queue createQueue(String qName) throws JMSException {
        this.getDestinations(true);
        return (Queue)this.m_qs.get(qName);
    }

    synchronized Topic createTopic(String tName) throws JMSException {
        this.getDestinations(true);
        return (Topic)this.m_ts.get(tName);
    }

    private void registerConnection() throws JMSException {
        if (this.m_regDone.testAndSet(true)) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01206", this));
        }
        this.getServer().registerConnection(this.m_clientID, this.getID(), this.m_user);
    }

    private void checkMaxMessages(int maxMessages) throws JMSException {
        if (maxMessages <= 0) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01207", this, new Integer(maxMessages)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSException getException() throws JMSException {
        this.lock("onException");
        JMSException ret = null;
        try {
            ret = this.getServer().ping();
        }
        catch (Throwable ex) {
            ret = JMSUtils.makeJMSException("ping", ex);
        }
        finally {
            this.unlock();
        }
        return ret;
    }

    private void doListener(ExceptionListener exListener) throws JMSException {
        this.m_exListener = exListener;
        this.m_thr = null;
        this.m_previousException = null;
        if (this.m_exListener != null) {
            this.startExceptionListener();
        }
    }

    private void startExceptionListener() {
        final EvermindConnection me = this;
        this.m_thr = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    JMSUtils.sleep(EvermindConnection.getPollInterval());
                    EvermindConnection evermindConnection = me;
                    synchronized (evermindConnection) {
                        if (!me.isOpen() || me.m_exListener == null || me.m_thr != Thread.currentThread()) {
                            break;
                        }
                        try {
                            me.doExceptionListener();
                        }
                        catch (Throwable ex) {
                            s_traceLogger.fine("onException", ex);
                        }
                    }
                }
            }
        });
        this.m_thr.setName("ExceptionListener[" + this.getID() + "]");
        this.m_thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExceptionListener() throws JMSException {
        JMSException ex = this.getException();
        if (ex != null && ex != this.m_previousException) {
            try {
                this.m_exListener.onException(ex);
            }
            catch (Throwable lex) {
                s_traceLogger.fine("onException", (Throwable)ex);
            }
            finally {
                this.m_previousException = ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDestinations(boolean forAPI) throws JMSException {
        this.lock("getDestinations");
        try {
            this.m_qs.clear();
            this.m_ts.clear();
            List dest = this.getServer().getDestinations(forAPI);
            Iterator iter = dest.iterator();
            while (iter.hasNext()) {
                Destination d = (Destination)iter.next();
                if (JMSUtils.isQ(d)) {
                    this.m_qs.put(JMSUtils.getName(d), d);
                    continue;
                }
                if (!JMSUtils.isT(d)) continue;
                this.m_ts.put(JMSUtils.getName(d), d);
            }
        }
        finally {
            this.unlock();
        }
    }

    private void clearTemporaries() {
        EvermindTemporaryDestination.purgeConnection(this.getID());
    }

    private static void setPollInterval(long interval) {
        s_pollInterval = interval;
    }

    private static long getPollInterval() {
        return s_pollInterval;
    }
}

