/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public final class EvermindBytesMessage
extends EvermindMessage
implements BytesMessage {
    private byte[] m_data = new byte[0];
    private transient ByteArrayInputStream m_binp = null;
    private transient DataInputStream m_dinp = null;
    private transient ByteArrayOutputStream m_bout = null;
    private transient DataOutputStream m_dout = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindBytesMessage.class);
    static final long serialVersionUID = 2241585341353885286L;

    EvermindBytesMessage() throws JMSException {
    }

    protected final void xmlBody(PrintWriter out) {
        try {
            this.reset();
        }
        catch (Throwable ex) {
            s_traceLogger.fine("xmlBody", ex);
        }
        EvermindBytesMessage.xmlOctets(out, "bytesbody", this.m_data);
    }

    protected final void writeBodyTo(DataOutput dout) throws IOException {
        dout.writeInt(this.m_data.length);
        dout.write(this.m_data);
    }

    protected final void readBodyFrom(DataInput dinp) throws IOException {
        int size = dinp.readInt();
        if (size <= 0) {
            this.m_data = new byte[0];
        } else {
            this.m_data = new byte[size];
            dinp.readFully(this.m_data);
        }
    }

    public synchronized long getBodyLength() throws JMSException {
        this.assertReadable();
        return this.m_data.length;
    }

    public synchronized boolean readBoolean() throws JMSException {
        this.prepareForRead();
        boolean ret = false;
        try {
            ret = this.m_dinp.readBoolean();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readBoolean", ex);
        }
        return ret;
    }

    public synchronized byte readByte() throws JMSException {
        this.prepareForRead();
        byte ret = 0;
        try {
            ret = this.m_dinp.readByte();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readByte", ex);
        }
        return ret;
    }

    public synchronized int readBytes(byte[] buf) throws JMSException {
        return this.readBytes("readBytes(" + buf + ")", buf, buf == null ? -1 : buf.length);
    }

    public synchronized int readBytes(byte[] buf, int len) throws JMSException {
        return this.readBytes("readBytes(" + buf + "," + len + ")", buf, len);
    }

    public synchronized char readChar() throws JMSException {
        this.prepareForRead();
        char ret = '\u0000';
        try {
            ret = this.m_dinp.readChar();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readChar", ex);
        }
        return ret;
    }

    public synchronized double readDouble() throws JMSException {
        this.prepareForRead();
        double ret = 0.0;
        try {
            ret = this.m_dinp.readDouble();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readDouble", ex);
        }
        return ret;
    }

    public synchronized float readFloat() throws JMSException {
        this.prepareForRead();
        float ret = 0.0f;
        try {
            ret = this.m_dinp.readFloat();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readFloat", ex);
        }
        return ret;
    }

    public synchronized int readInt() throws JMSException {
        this.prepareForRead();
        int ret = 0;
        try {
            ret = this.m_dinp.readInt();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readInt", ex);
        }
        return ret;
    }

    public synchronized long readLong() throws JMSException {
        this.prepareForRead();
        long ret = 0L;
        try {
            ret = this.m_dinp.readLong();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readLong", ex);
        }
        return ret;
    }

    public synchronized short readShort() throws JMSException {
        this.prepareForRead();
        short ret = 0;
        try {
            ret = this.m_dinp.readShort();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readShort", ex);
        }
        return ret;
    }

    public synchronized String readUTF() throws JMSException {
        this.prepareForRead();
        String ret = null;
        try {
            ret = this.m_dinp.readUTF();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readUTF", ex);
        }
        return ret;
    }

    public synchronized int readUnsignedByte() throws JMSException {
        this.prepareForRead();
        int ret = 0;
        try {
            ret = this.m_dinp.readUnsignedByte();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readUnsignedByte", ex);
        }
        return ret;
    }

    public synchronized int readUnsignedShort() throws JMSException {
        this.prepareForRead();
        int ret = 0;
        try {
            ret = this.m_dinp.readUnsignedShort();
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("readUnsignedShort", ex);
        }
        return ret;
    }

    public synchronized void reset() throws JMSException {
        try {
            this.getData();
            this.resetStreams();
            this.setReadOnly(true);
        }
        catch (Exception ex) {
            JMSUtils.toJMSException("reset", ex);
        }
    }

    public synchronized void writeBoolean(boolean v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeBoolean(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeBoolean", ex);
        }
    }

    public synchronized void writeByte(byte v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeByte(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeByte", ex);
        }
    }

    public synchronized void writeBytes(byte[] buf) throws JMSException {
        this.writeBytes("writeBytes(" + buf + ")", buf, 0, buf == null ? -1 : buf.length);
    }

    public synchronized void writeBytes(byte[] buf, int off, int len) throws JMSException {
        this.writeBytes("writeBytes(" + buf + "," + off + "," + len + ")", buf, off, len);
    }

    public synchronized void writeChar(char v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeChar(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeChar", ex);
        }
    }

    public synchronized void writeDouble(double v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeDouble(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeDouble", ex);
        }
    }

    public synchronized void writeFloat(float v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeFloat(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeFloat", ex);
        }
    }

    public synchronized void writeInt(int v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeInt(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeInt", ex);
        }
    }

    public synchronized void writeLong(long v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeLong(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeLong", ex);
        }
    }

    public synchronized void writeObject(Object v) throws JMSException {
        this.prepareForWrite();
        JMSUtils.checkNull("writeObject", "java.lang.Object", v);
        if (v instanceof Boolean) {
            this.writeBoolean((Boolean)v);
        } else if (v instanceof Byte) {
            this.writeByte((Byte)v);
        } else if (v instanceof byte[]) {
            this.writeBytes((byte[])v, 0, ((byte[])v).length);
        } else if (v instanceof Character) {
            this.writeChar(((Character)v).charValue());
        } else if (v instanceof Double) {
            this.writeDouble((Double)v);
        } else if (v instanceof Float) {
            this.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Integer) {
            this.writeInt((Integer)v);
        } else if (v instanceof Long) {
            this.writeLong((Long)v);
        } else if (v instanceof Short) {
            this.writeShort((Short)v);
        } else if (v instanceof String) {
            this.writeUTF((String)v);
        } else {
            JMSUtils.badFormat("writeObject", v);
        }
    }

    public synchronized void writeShort(short v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeShort(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeShort", ex);
        }
    }

    public synchronized void writeUTF(String v) throws JMSException {
        this.prepareForWrite();
        try {
            this.m_dout.writeUTF(v);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("writeUTF", ex);
        }
    }

    public synchronized void clearBody() throws JMSException {
        super.clearBody();
        this.m_data = new byte[0];
        this.resetStreams();
    }

    public int getTypeID() {
        return 1;
    }

    protected synchronized void fixate() throws IOException {
        super.fixate();
        this.getData();
    }

    protected EvermindMessage makeSelf() throws JMSException {
        return new EvermindBytesMessage();
    }

    protected synchronized void cloneBody(EvermindMessage ret) throws JMSException {
        ((EvermindBytesMessage)ret).m_data = this.m_data;
    }

    private void getData() throws IOException {
        if (this.m_dout != null) {
            this.m_dout.flush();
            this.m_bout.flush();
            this.m_data = this.m_bout.toByteArray();
        }
    }

    private void resetStreams() {
        JMSUtils.closeIt(this.m_binp);
        this.m_binp = null;
        JMSUtils.closeIt(this.m_dinp);
        this.m_dinp = null;
        JMSUtils.closeIt(this.m_bout);
        this.m_bout = null;
        JMSUtils.closeIt(this.m_dout);
        this.m_dout = null;
    }

    private void prepareForRead() throws JMSException {
        this.assertReadable();
        if (this.m_dinp == null) {
            try {
                this.m_binp = new ByteArrayInputStream(this.m_data);
                this.m_dinp = new DataInputStream(this.m_binp);
            }
            catch (Exception ex) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01100", this), ex);
            }
        }
    }

    private int readBytes(String func, byte[] buf, int len) throws JMSException {
        this.prepareForRead();
        JMSUtils.checkNull(func, "byte[]", buf);
        if (len < 0 || len > buf.length) {
            throw new IndexOutOfBoundsException(JMSMessages.getMessage("J2EE JMS-01101", this, func, new Integer(buf.length)));
        }
        int ret = 0;
        try {
            ret = this.m_dinp.read(buf, 0, len);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException(func, ex);
        }
        return ret;
    }

    private void prepareForWrite() throws JMSException {
        this.assertWriteable();
        if (this.m_dout == null) {
            try {
                this.m_bout = new ByteArrayOutputStream();
                this.m_dout = new DataOutputStream(this.m_bout);
            }
            catch (Exception ex) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01102", this), ex);
            }
        }
    }

    private void writeBytes(String func, byte[] buf, int off, int len) throws JMSException {
        this.prepareForWrite();
        JMSUtils.checkNull(func, "byte[]", buf);
        try {
            this.m_dout.write(buf, off, len);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException(func, ex);
        }
    }
}

