/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.http.deployment.WebApp24Descriptor;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListenerDescriptor
implements XMLizable,
WebApp24Descriptor {
    private String className;
    private String displayName;
    private String description;
    private IconDescriptor icon;
    private Method postConstructMethod = null;
    private Method preDestroyMethod = null;

    public ListenerDescriptor(String className) {
        this.className = className;
    }

    public ListenerDescriptor(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("description")) {
                    this.description = XMLUtils.getStringValue(node);
                    continue;
                }
                if (name.equals("display-name")) {
                    this.displayName = XMLUtils.getStringValue(node);
                    continue;
                }
                if (name.equals("icon")) {
                    this.icon = new IconDescriptor(node);
                    continue;
                }
                if (!name.equals("listener-class")) continue;
                this.className = XMLUtils.getStringValue(node);
                if (this.className != null) continue;
                throw new InstantiationException("listener tag with missing listener-class subtag");
            }
        }
    }

    public void setPostConstructMethod(Method method) {
        this.postConstructMethod = method;
    }

    public Method getPostConstructMethod() {
        return this.postConstructMethod;
    }

    public void setPreDestroyMethod(Method method) {
        this.preDestroyMethod = method;
    }

    public Method getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IconDescriptor getIcon() {
        return this.icon;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<listener>");
        if (this.displayName != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.displayName) + "</display-name>");
        }
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.icon != null) {
            this.icon.writeXML(out, indention + "\t");
        }
        out.println(indention + "\t<listener-class>" + XMLUtils.encode(this.className) + "</listener-class>");
        out.println(indention + "</listener>");
    }

    public void writeWebApp24XML(PrintWriter out, String indention) {
        out.println(indention + "<listener>");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.displayName != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.displayName) + "</display-name>");
        }
        if (this.icon != null) {
            this.icon.writeXML(out, indention + "\t");
        }
        out.println(indention + "\t<listener-class>" + XMLUtils.encode(this.className) + "</listener-class>");
        out.println(indention + "</listener>");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.displayName != null) {
            buffer.append("display-name: " + this.displayName + "; ");
        }
        if (this.description != null) {
            buffer.append("description: " + this.description + "; ");
        }
        if (this.icon != null) {
            buffer.append("icon: " + this.icon.toString() + "; ");
        }
        buffer.append("listener-class: " + this.className);
        return buffer.toString();
    }
}

