/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;

public class ExpirationSetting
implements XMLizable,
Serializable {
    public String urlPattern;
    public int expirationTime;

    public ExpirationSetting() {
    }

    public ExpirationSetting(String expirationTime, String urlPattern) throws InstantiationException {
        this.expirationTime = this.convertExpirationSetting(expirationTime);
        this.urlPattern = urlPattern;
    }

    public ExpirationSetting(Node node) throws InstantiationException {
        this.urlPattern = XMLUtils.getNodeAttribute(node, "url-pattern");
        String expires = XMLUtils.getNodeAttribute(node, "expires");
        if (this.urlPattern != null && !this.urlPattern.startsWith("/") && !this.urlPattern.startsWith("*.")) {
            this.urlPattern = "/".concat(this.urlPattern);
        }
        this.expirationTime = this.convertExpirationSetting(expires);
    }

    /*
     * WARNING - void declaration
     */
    public int convertExpirationSetting(String expires) throws InstantiationException {
        void var2_2;
        int expirationTime;
        if (expires == null) {
            expirationTime = 0;
        } else if (expires.equalsIgnoreCase("never")) {
            expirationTime = -1;
        } else {
            try {
                expirationTime = Integer.parseInt(expires);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Invalid expires attribute value: " + expires);
            }
        }
        return (int)var2_2;
    }

    public void setExpires(String expires) throws InstantiationException {
        this.expirationTime = this.convertExpirationSetting(expires);
    }

    public String getExpires() {
        if (this.expirationTime == -1) {
            return "never";
        }
        return String.valueOf(this.expirationTime);
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String value) {
        this.urlPattern = value;
    }

    public int getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(int value) {
        this.expirationTime = value;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.write(indention + "<expiration-setting");
        if (this.urlPattern != null) {
            out.write(" url-pattern=\"" + XMLUtils.encode(this.urlPattern) + '\"');
        }
        if (this.expirationTime != 0) {
            if (this.expirationTime == -1) {
                out.write(" expires=\"never\"");
            } else {
                out.write(" expires=\"" + this.expirationTime + "\"");
            }
        }
        out.println(" />");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("expiration-setting: ");
        buf.append("  url-pattern: ");
        buf.append(this.getURLPattern());
        buf.append("  expires: ");
        buf.append(this.getExpires());
        buf.append("\n");
        return buf.toString();
    }
}

