/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.naming.ContextUtils;
import com.evermind.server.Application;
import com.evermind.server.http.TagLibraryArchive;
import com.evermind.util.HTTPProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class TagLibraryStorage {
    protected ClassLoader loader;
    protected Map libraries;
    protected Map tagLibraries = new HashMap();
    protected Map tagLibrariesByURN = new HashMap();
    protected Application application;

    public TagLibraryStorage(ClassLoader loader, Map libraries, Application application) {
        this.loader = loader;
        this.libraries = libraries;
        this.application = application;
    }

    public synchronized boolean isUpdated() {
        Iterator iterator = this.tagLibraries.values().iterator();
        while (iterator.hasNext()) {
            if (!((TagLibraryArchive)iterator.next()).isUpdated()) continue;
            return true;
        }
        return false;
    }

    public synchronized TagLibraryArchive getTagLibContext(String relativeURI, Context parentContext, String url, Object compilationContext) throws InstantiationException {
        try {
            String eitherURI;
            TagLibraryArchive archive = (TagLibraryArchive)this.tagLibraries.get(url);
            if (archive == null) {
                archive = (TagLibraryArchive)this.tagLibrariesByURN.get(url);
            }
            if (archive != null && archive.isUpdated()) {
                this.flush(url);
                archive = null;
            }
            if (archive != null) {
                return archive;
            }
            Context context = null;
            if (relativeURI != null && this.libraries != null && relativeURI.startsWith("/")) {
                context = (Context)this.libraries.get(relativeURI.substring(1));
            }
            String string = eitherURI = relativeURI == null ? url : relativeURI;
            if (relativeURI != null && relativeURI.startsWith("/") && url == null) {
                relativeURI = relativeURI.substring(1);
            }
            if (eitherURI.endsWith(".tld")) {
                if (url != null && url.startsWith("file:/")) {
                    File file = new File(new URL(url).getFile());
                    archive = TagLibraryArchive.getArchive(file.lastModified(), file, this.loader, null, null, url, new FileInputStream(file), this.loader);
                } else if (url != null) {
                    archive = TagLibraryArchive.getArchive(0L, null, this.loader, null, null, url, new URL(url).openStream(), this.loader);
                } else {
                    try {
                        archive = TagLibraryArchive.getArchive(0L, null, this.loader, null, null, "webApp://" + relativeURI, new ByteArrayInputStream((byte[])parentContext.lookup(relativeURI)), this.loader);
                    }
                    catch (ClassCastException e) {
                        throw new InstantiationException(relativeURI + " was a directory, not a file as expected");
                    }
                }
            } else {
                if (context == null) {
                    context = url != null ? ContextUtils.getContext(new URL(url), false) : ContextUtils.getContext(parentContext, relativeURI, false);
                }
                try {
                    context = url != null ? ContextUtils.getContext(new URL(url), false) : ContextUtils.getContext(parentContext, relativeURI, false);
                    File rootFile = ContextUtils.getFile(context, false);
                    File file = ContextUtils.getFile(context, "META-INF/taglib.tld", false);
                    if (rootFile != null && !rootFile.exists()) {
                        throw new InstantiationException("Unable to find taglib archive at file at " + rootFile.getPath());
                    }
                    if (file != null && !file.exists()) {
                        throw new InstantiationException("Unable find META-INF/taglib.tld (" + file.getPath() + ") descriptor file for taglib archive at file at " + rootFile.getPath());
                    }
                    throw new InstantiationException("Unsupported use of Orion JSP.");
                }
                catch (IllegalArgumentException e) {
                    throw new InstantiationException(e.getMessage());
                }
            }
            this.tagLibraries.put(url == null ? relativeURI : url, archive);
            if (archive.getReliableURN() != null) {
                this.tagLibrariesByURN.put(archive.getReliableURN(), archive);
            }
            return archive;
        }
        catch (IOException e) {
            if (HTTPProperties.getTagLibraryLoadingDebug()) {
                e.printStackTrace();
            }
            throw new InstantiationException("IO error while loading tag-library '" + relativeURI + "': " + e.getMessage());
        }
        catch (NameNotFoundException e) {
            throw new InstantiationException("Could not find tag-library at " + relativeURI);
        }
        catch (NamingException e) {
            throw new InstantiationException("IO error: " + e.getMessage());
        }
    }

    public synchronized void flush(String url) {
        TagLibraryArchive context = (TagLibraryArchive)this.tagLibraries.remove(url);
        if (context != null && context.getReliableURN() != null) {
            this.tagLibrariesByURN.remove(context.getReliableURN());
        }
    }
}

