/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.net.IONetworkConnection;
import com.evermind.net.NetworkConnection;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpTunnelServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest genericRequest, HttpServletResponse response) throws IOException {
        EvermindHttpServletRequest request = this.getThreadRequest();
        request.socket.setSoTimeout(0);
        request.getInputStream();
        request.servletIn.contentLength = Integer.MAX_VALUE;
        try {
            response.setHeader("Tunnel-Mode", "normal");
            response.setHeader("Dummy", "normal");
            response.flushBuffer();
            this.connect(new IONetworkConnection((InputStream)request.getInputStream(), new MyOutputStream(response), request.socket.getInetAddress(), request.socket.getPort()));
        }
        finally {
            request.servletIn.contentLength = 0L;
        }
        throw new HttpIOException("Tunnel session ended");
    }

    protected abstract void connect(NetworkConnection var1) throws IOException;

    protected EvermindHttpServletRequest getThreadRequest() {
        return ((ApplicationServerThread)Thread.currentThread()).httpHandler.request;
    }

    static class MyOutputStream
    extends OutputStream {
        HttpServletResponse resp;
        OutputStream os;

        MyOutputStream(HttpServletResponse resp) throws IOException {
            this.resp = resp;
            this.os = resp.getOutputStream();
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void write(byte[] b, int off, int length) throws IOException {
            this.os.write(b, off, length);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }

        public void flush() throws IOException {
            this.resp.flushBuffer();
        }
    }
}

