/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.persistence.AbstractEntityManagerProxy;
import com.evermind.server.ejb.persistence.ContainerEntityManager;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import com.evermind.server.ejb.persistence.XPCManager;
import java.util.Map;
import javax.persistence.EntityManager;

public class XPCEntityManagerProxy
extends AbstractEntityManagerProxy
implements ContainerEntityManager {
    private PersistenceUnit pu;
    private XPCManager xm;

    public XPCEntityManagerProxy(PersistenceUnit pu, XPCManager xm, Map properties) {
        super(properties);
        this.pu = pu;
        this.xm = xm;
    }

    protected EntityManager allocateEntityManager() {
        EntityManager em = (EntityManager)this.xm.getPersistenceContext(this.pu.getName());
        if (EJBTransactionManager.getTransaction() != null) {
            this.xm.associatePersistenceContexts();
        }
        return em;
    }

    protected void releaseEntityManager(EntityManager em) {
    }

    public String getType() {
        return "EXTENDED";
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.pu;
    }

    public Object getDelegate() {
        return this.xm.getPersistenceContext(this.pu.getName());
    }

    public void joinTransaction() {
        this.allocateEntityManager();
    }
}

