/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor;

import com.evermind.server.ApplicationServer;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerTransaction;
import com.evermind.server.ejb.interceptor.joinpoint.EJBJoinPoint;
import com.evermind.server.ejb.interceptor.system.DMSInterceptor;
import com.evermind.server.ejb.interceptor.system.JACCInterceptor;
import com.evermind.server.ejb.interceptor.system.SecurityRoleInterceptor;
import java.lang.reflect.Method;
import javax.security.jacc.EJBMethodPermission;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.oc4j.security.acc.JaccWrapper;

public class MethodState {
    public static final byte BUSINESS_METHOD = 1;
    public static final byte EJB_HOME = 2;
    public static final byte EJB_FINDER = 3;
    public static final byte SET_CONTEXT = 4;
    public static final byte UNSET_CONTEXT = 5;
    public static final byte EJB_CREATE = 6;
    public static final byte EJB_POST_CREATE = 7;
    public static final byte EJB_REMOVE = 8;
    public static final byte EJB_ACTIVATE = 9;
    public static final byte EJB_PASSIVATE = 10;
    public static final byte EJB_LOAD = 11;
    public static final byte EJB_STORE = 12;
    public static final byte ON_MESSAGE = 13;
    public static final byte EJB_TIMEOUT = 14;
    public static final byte AFTER_BEGIN = 15;
    public static final byte BEFORE_COMPLETION = 16;
    public static final byte AFTER_COMPLETION = 17;
    public static final byte WRAPPER_REMOVE = 18;
    public static final byte WRAPPER_CREATE = 19;
    public static final byte UNSPECIFIED = 20;
    private boolean initialized;
    private BeanDescriptor beanDescriptor;
    private byte methodType;
    private Method beanMethod;
    private EJBJoinPoint joinPoint;
    private PhaseEventIntf clientPhaseEvent;
    private Method interfaceMethod;
    private boolean local;
    private boolean home;
    private int transactionType;
    private PhaseEventIntf wrapperPhaseEvent;
    private RuntimeSecurityRole securityRole;
    private EJBMethodPermission methodPermission;

    public MethodState(byte methodType, BeanDescriptor beanDescriptor, Method beanMethod) {
        this.setMethodType(methodType);
        this.setBeanMethod(beanMethod);
        this.setBeanDescriptor(beanDescriptor);
    }

    public MethodState(BeanDescriptor beanDescriptor, byte methodType, Method interfaceMethod, Method beanMethod, boolean isLocal, boolean isHome) {
        this.setMethodType(methodType);
        this.setInterfaceMethod(interfaceMethod);
        this.setBeanMethod(beanMethod);
        this.setBeanDescriptor(beanDescriptor);
        this.setLocal(isLocal);
        this.setHome(isHome);
        this.setTransactionType(beanDescriptor.getTransactionType(interfaceMethod, isHome, isLocal));
    }

    public final synchronized MethodState initialize() {
        if (!this.initialized) {
            this.doInitialize();
            this.initialized = true;
        }
        return this;
    }

    protected void doInitialize() {
        this.initializeDMS();
        if (this.getInterfaceMethod() != null) {
            if (JaccWrapper.isJaccEnabled()) {
                this.methodPermission = JACCInterceptor.getMethodPermission(this);
            } else {
                this.securityRole = SecurityRoleInterceptor.getSecurityRole(this);
            }
        }
        this.setJoinPoint(this.getBeanDescriptor().getInterceptorManager().createJoinPoint(this));
    }

    public final synchronized void destroy() {
        if (this.initialized) {
            this.doDestroy();
            this.initialized = false;
        }
    }

    protected void doDestroy() {
        this.beanDescriptor = null;
        this.beanMethod = null;
        this.clientPhaseEvent = null;
        this.interfaceMethod = null;
        this.joinPoint = null;
        this.methodPermission = null;
        this.securityRole = null;
        this.wrapperPhaseEvent = null;
    }

    protected void initializeDMS() {
        String methodName;
        if (!ApplicationServer.DMS_GATE) {
            return;
        }
        if (this.getInterfaceMethod() != null) {
            methodName = this.getDmsMethodName();
            this.wrapperPhaseEvent = DMSInterceptor.createDMSBeanMethodPE(this.getBeanDescriptor().getBeanNoun(), ContainerTransaction.getTransactionName(this.getTransactionType()), methodName, "oc4j_ejb_method", "wrapper");
        }
        methodName = null;
        String nounCategory = "oc4j_ejb_method";
        String phaseCategory = "client";
        if (this.getBeanMethod() != null) {
            if (this.getMethodType() == 7) {
                methodName = "ejbPostCreate";
                nounCategory = "oc4j_ejb_method_postCreate";
                phaseCategory = "ejbPostCreate";
            } else {
                methodName = DMSInterceptor.getDMSMethodName(this.getBeanMethod());
            }
        } else if (this.getMethodType() == 6) {
            methodName = "postConstruct";
        } else if (this.getMethodType() == 8) {
            methodName = "preDestroy";
        } else if (this.getMethodType() == 9) {
            methodName = "postActivate";
        } else if (this.getMethodType() == 10) {
            methodName = "prePassivate";
        }
        if (methodName != null) {
            this.clientPhaseEvent = DMSInterceptor.createDMSBeanMethodPE(this.getBeanDescriptor().getBeanNoun(), null, methodName, nounCategory, phaseCategory);
        }
    }

    private String getDmsMethodName() {
        if (this.getMethodType() == 6 && this.getBeanMethod() != null && this.getBeanMethod().getParameterTypes().length == 0) {
            return "create()";
        }
        if (this.getMethodType() == 8 || this.getMethodType() == 18) {
            return "remove()";
        }
        return DMSInterceptor.getDMSMethodName(this.getInterfaceMethod());
    }

    public final boolean isLocal() {
        return this.local;
    }

    public final boolean isHome() {
        return this.home;
    }

    public final int getTransactionType() {
        return this.transactionType;
    }

    public final PhaseEventIntf getClientPhaseEvent() {
        return this.clientPhaseEvent;
    }

    public final PhaseEventIntf getWrapperPhaseEvent() {
        return this.wrapperPhaseEvent;
    }

    public final RuntimeSecurityRole getSecurityRole() {
        return this.securityRole;
    }

    public final EJBMethodPermission getMethodPermission() {
        return this.methodPermission;
    }

    public final Method getBeanMethod() {
        return this.beanMethod;
    }

    private void setBeanMethod(Method beanMethod) {
        this.beanMethod = beanMethod;
    }

    public final Method getInterfaceMethod() {
        return this.interfaceMethod;
    }

    public void setInterfaceMethod(Method interfaceMethod) {
        this.interfaceMethod = interfaceMethod;
    }

    public final EJBJoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public final byte getMethodType() {
        return this.methodType;
    }

    public void setJoinPoint(EJBJoinPoint joinPoint) {
        this.joinPoint = joinPoint;
    }

    private void setHome(boolean home) {
        this.home = home;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    protected void setMethodType(byte methodType) {
        this.methodType = methodType;
    }

    private void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }

    public final BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    private void setBeanDescriptor(BeanDescriptor beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
    }

    public Method getInvocationContextMethod() {
        if (this.getMethodType() == 6 || this.getMethodType() == 8 || this.getMethodType() == 9 || this.getMethodType() == 10) {
            return null;
        }
        return this.getJoinPoint().getMethod();
    }
}

