/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.exception;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.exception.EJBExceptionsHelper;
import com.evermind.server.ejb.exception.i18n.ValidationExceptionsMessageBundle;
import java.util.Locale;
import java.util.ResourceBundle;

public class ValidationExceptions {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle(ValidationExceptionsMessageBundle.class.getName(), Locale.getDefault());

    public static InvalidEJBAssemblyException missingEJBName(BeanDescriptor desc) {
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, null, "0001", "23.2"));
    }

    public static InvalidEJBAssemblyException missingEJBClass(BeanDescriptor desc) {
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, null, "0002", "23.2"));
    }

    public static InvalidEJBAssemblyException unableToLoadEJBClass(BeanDescriptor desc, Throwable root) {
        Object[] args = new Object[]{desc.getEJBClassName()};
        return (InvalidEJBAssemblyException)new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0003", "23.2") + root, null).initCause(root);
    }

    public static InstantiationException unableToResolveEJBAnnot(BeanDescriptor desc, String refName) {
        Object[] args = new Object[]{refName};
        return new InstantiationException(ValidationExceptions.buildMessage(desc, args, "0004"));
    }

    public static InstantiationException ejbAnnotResolvesToMultipleBeans(BeanDescriptor desc, String refName) {
        Object[] args = new Object[]{refName};
        return new InstantiationException(ValidationExceptions.buildMessage(desc, args, "0005"));
    }

    public static IllegalArgumentException minInstancesExceedsMaxInstances(BeanDescriptor desc, int min, int max) {
        Object[] args = new Object[]{String.valueOf(min), String.valueOf(max)};
        return new IllegalArgumentException(ValidationExceptions.buildMessage(desc, args, "0006"));
    }

    public static InvalidEJBAssemblyException unknownJARInMessageDestinationLink(BeanDescriptor desc, String linkName, String refName) {
        Object[] args = new Object[]{linkName, refName};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0007", "20.7.2"));
    }

    public static InvalidEJBAssemblyException destinationLinkTargetMismatch(BeanDescriptor desc, String refName, String refType, String targetType) {
        Object[] args = new Object[]{refName, refType, targetType};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0008", "20.7.2"));
    }

    public static InvalidEJBAssemblyException unknownDestinationLink(BeanDescriptor desc, String destLink, String refName) {
        Object[] args = new Object[]{destLink, refName};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0009", "20.7.2"));
    }

    public static InvalidEJBAssemblyException unknownSecurityIdentity(BeanDescriptor desc, String roleName) {
        Object[] args = new Object[]{roleName};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0010", "21.3.4"));
    }

    public static InvalidEJBAssemblyException sessionUnexpectedHomeMethod(BeanDescriptor desc, String method, boolean local) {
        Object[] args = new Object[]{method};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0018", local ? "7.11.8" : "7.11.6"));
    }

    public static InvalidEJBAssemblyException sessionInvalidCreateMethod(BeanDescriptor desc, String method, boolean local) {
        Object[] args = new Object[]{method};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0019", local ? "7.11.8" : "7.11.6"));
    }

    public static InvalidEJBAssemblyException sessionCreateMustThrowRemoteException(BeanDescriptor desc, String method) {
        Object[] args = new Object[]{method};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0020", "7.11.6"));
    }

    public static InvalidEJBAssemblyException sessionCreateMustThrowCreateException(BeanDescriptor desc, String method, boolean local) {
        Object[] args = new Object[]{method};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0021", local ? "7.11.8" : "7.11.6"));
    }

    public static InvalidEJBAssemblyException sessionCreateMustReturnIntf(BeanDescriptor desc, String method, String type, boolean local) {
        Object[] args = new Object[]{method, type};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0022", local ? "7.11.8" : "7.11.6"));
    }

    public static InvalidEJBAssemblyException sessionCreateMustHaveInitMethod(BeanDescriptor desc, String method) {
        Object[] args = new Object[]{method};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0023", null));
    }

    public static InvalidEJBAssemblyException sessionCreateCanOnlyHaveOneInitMethod(BeanDescriptor desc, String method, String names) {
        Object[] args = new Object[]{method, names};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0024", null));
    }

    public static InvalidEJBAssemblyException sessionRemoteMethodMustThrowRemoteException(BeanDescriptor desc, String method) {
        Object[] args = new Object[]{method};
        return new InvalidEJBAssemblyException(ValidationExceptions.buildMessage(desc, args, "0020", "7.11.5"));
    }

    private static String buildMessage(BeanDescriptor desc, Object[] args, String exceptionKey) {
        return EJBExceptionsHelper.buildMessage(resourceBundle, ValidationExceptions.prefixArgs(EJBExceptionsHelper.buildMessagePrefix(desc), args), exceptionKey);
    }

    private static String buildMessage(BeanDescriptor desc, Object[] args, String exceptionKey, String specSection) {
        return EJBExceptionsHelper.buildMessage(resourceBundle, ValidationExceptions.prefixArgs(EJBExceptionsHelper.buildMessagePrefix(desc), args), exceptionKey, specSection);
    }

    private static Object[] prefixArgs(String prefix, Object[] args) {
        if (args == null || args.length == 0) {
            return new Object[]{prefix};
        }
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = prefix;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return newArgs;
    }
}

