/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.exception;

import com.evermind.server.ejb.exception.EJBExceptionsHelper;
import com.evermind.server.ejb.exception.i18n.DeploymentExceptionsMessageBundle;
import com.evermind.server.ejb.logging.DiagnosticContext;
import java.util.Locale;
import java.util.ResourceBundle;

public class DeploymentException
extends RuntimeException {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle(DeploymentExceptionsMessageBundle.class.getName(), Locale.getDefault());

    public DeploymentException(String message) {
        super(message);
    }

    public DeploymentException(String message, Throwable cause) {
        super(message, cause);
    }

    public static DeploymentException exceptionParsingXml(String scope, String xmlFile, Exception e) {
        Object[] args = new Object[]{scope, xmlFile};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1000")).initCause(e);
    }

    public static DeploymentException multiplePersistenceUnitsWithSameName(DiagnosticContext ctx, String unitName) {
        Object[] args = new Object[]{ctx.getContextId(), unitName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1005"));
    }

    public static DeploymentException unknownPersistenceUnit(DiagnosticContext ctx, String unitName) {
        Object[] args = new Object[]{ctx.getContextId(), unitName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1006"));
    }

    public static DeploymentException missingPersistenceUnitName(DiagnosticContext ctx) {
        Object[] args = new Object[]{ctx.getContextId()};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1007"));
    }

    public static DeploymentException unknownXmlSubtag(DiagnosticContext ctx, String parentTag, String unknownTag) {
        Object[] args = new Object[]{ctx.getContextId(), parentTag, unknownTag};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1001"));
    }

    public static DeploymentException unknownXmlSubtag(DiagnosticContext ctx, String parentTag, String unknownTag, String allowedTags) {
        Object[] args = new Object[]{ctx.getContextId(), parentTag, unknownTag, allowedTags};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1002"));
    }

    public static DeploymentException unknownXmlSubtag(String ctx, String parentTag, String unknownTag) {
        Object[] args = new Object[]{ctx, parentTag, unknownTag};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1001"));
    }

    public static DeploymentException unknownXmlSubtag(String ctx, String parentTag, String unknownTag, String allowedTags) {
        Object[] args = new Object[]{ctx, parentTag, unknownTag, allowedTags};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1002"));
    }

    public static DeploymentException unknownXmlAttribute(String scope, String parentTag, String unknownAttr) {
        Object[] args = new Object[]{scope, parentTag, unknownAttr};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1004"));
    }

    public static DeploymentException unknownXmlValue(String scope, String tag, String unknownValue, String allowedValues) {
        Object[] args = new Object[]{scope, tag, unknownValue, allowedValues};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1003"));
    }

    public static DeploymentException exceptionCreatingPersistenceUnitRoot(DiagnosticContext ctx, String rootName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), rootName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1008")).initCause(e);
    }

    public static DeploymentException exceptionCreatingJarFileUrl(DiagnosticContext ctx, String jarName, String rootName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), jarName, rootName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1009")).initCause(e);
    }

    public static DeploymentException unableToResolveDataSource(DiagnosticContext ctx, String dsName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), dsName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1010")).initCause(e);
    }

    public static DeploymentException exceptionBindingPersistenceUnit(DiagnosticContext ctx, String unitName, String refName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), unitName, refName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1011")).initCause(e);
    }

    public static DeploymentException exceptionCreatingEntityManagerFactory(DiagnosticContext ctx, String providerName, String unitName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), providerName, unitName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1012")).initCause(e);
    }

    public static DeploymentException exceptionBindingEMF(DiagnosticContext ctx, String jndiName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), jndiName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1013")).initCause(e);
    }

    public static DeploymentException exceptionTransformingEntityClass(String className, ClassLoader loader, Exception e) {
        Object[] args = new Object[]{className, loader};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1014")).initCause(e);
    }

    public static DeploymentException duplicateInterceptorDefinition(DiagnosticContext ctx, String className) {
        Object[] args = new Object[]{ctx.getContextId(), className};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1015"));
    }

    public static DeploymentException missingAroundInvokeOrCallback(DiagnosticContext ctx, String interceptorClassName) {
        Object[] args = new Object[]{ctx.getContextId(), interceptorClassName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1016"));
    }

    public static DeploymentException duplicateTag(DiagnosticContext ctx, String parentTag, String duplicateTag) {
        Object[] args = new Object[]{ctx, parentTag, duplicateTag};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1017"));
    }

    public static DeploymentException missingOrNullTag(DiagnosticContext ctx, String parentTag, String missingTag) {
        Object[] args = new Object[]{ctx.getContextId(), parentTag, missingTag};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1018"));
    }

    public static DeploymentException missingInterceptorBindingEjbName(DiagnosticContext ctx) {
        Object[] args = new Object[]{ctx.getContextId()};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1019"));
    }

    public static DeploymentException multipleDefaultInterceptorBindings(DiagnosticContext ctx) {
        Object[] args = new Object[]{ctx.getContextId()};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1020"));
    }

    public static DeploymentException multipleClassInterceptorBindings(DiagnosticContext ctx, String ejbName) {
        Object[] args = new Object[]{ctx.getContextId(), ejbName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1021"));
    }

    public static DeploymentException missingInterceptorClass(DiagnosticContext ctx, String interceptorName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), interceptorName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1022")).initCause(e);
    }

    public static DeploymentException errorInstantiatingInterceptor(DiagnosticContext ctx, String interceptorName, Exception e) {
        Object[] args = new Object[]{ctx.getContextId(), interceptorName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1023")).initCause(e);
    }

    public static DeploymentException missingInterceptorMethod(DiagnosticContext ctx, String interceptorName, String methodName, boolean bean) {
        Object[] args = new Object[]{ctx.getContextId(), interceptorName, methodName, bean ? "null" : "javax.interceptor.InvocationContext"};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1024"));
    }

    public static DeploymentException invalidInterceptorBindingEjbName(DiagnosticContext ctx, String ejbName) {
        Object[] args = new Object[]{ctx.getContextId(), ejbName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1025"));
    }

    public static DeploymentException defaultBindingWithMethod(DiagnosticContext ctx) {
        Object[] args = new Object[]{ctx.getContextId()};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1026"));
    }

    public static DeploymentException invalidLifecycleCallbackName(DiagnosticContext ctx, String eventName, String ejb21CallbackName) {
        Object[] args = new Object[]{ctx.getContextId(), eventName, ejb21CallbackName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1027"));
    }

    public static DeploymentException missingInterceptorDef(DiagnosticContext ctx, String interceptorName) {
        Object[] args = new Object[]{ctx.getContextId(), interceptorName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1028"));
    }

    public static DeploymentException interceptorClassNotDefined(DiagnosticContext ctx) {
        Object[] args = new Object[]{ctx.getContextId()};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1030"));
    }

    public static DeploymentException duplicateInterceptorCallback(DiagnosticContext ctx, String callbackName, String oldCallback, String newCallback, String declaringClass) {
        Object[] args = new Object[]{ctx.getContextId(), callbackName, oldCallback, newCallback, declaringClass};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1029"));
    }

    public static DeploymentException unableToResolveDocumentRoot(String scope, String moduleName, Exception e) {
        Object[] args = new Object[]{scope, moduleName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1031"));
    }

    public static DeploymentException illegalInterceptorType(DiagnosticContext ctx, String type) {
        Object[] args = new Object[]{ctx, type};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1032"));
    }

    public static DeploymentException errorStaticOrFinalInterceptorMethod(DiagnosticContext ctx, String interceptorName, String methodName) {
        Object[] args = new Object[]{ctx.getContextId(), methodName, interceptorName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1036"));
    }

    public static DeploymentException illegalTagUsedWithInterceptorOrder(DiagnosticContext ctx, String tag) {
        Object[] args = new Object[]{ctx, tag};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1033"));
    }

    public static DeploymentException exceptionInstantiatingDependencyManager(DiagnosticContext ctx, String interceptorClassName, Exception e) {
        Object[] args = new Object[]{ctx, interceptorClassName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1034")).initCause(e);
    }

    public static DeploymentException exceptionGettingPersistenceUnitRoots(String scope, String moduleName, Exception e) {
        Object[] args = new Object[]{scope, moduleName};
        return (DeploymentException)new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1035")).initCause(e);
    }

    public static DeploymentException invalidCallbackClass(DiagnosticContext ctx, String interceptorClass, String callbackClass, String methodName) {
        Object[] args = new Object[]{ctx, interceptorClass, callbackClass, methodName};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1037"));
    }

    public static DeploymentException overriddenCallbackMethod(DiagnosticContext ctx, String methodName, String overriddenClass, String callbackClass) {
        Object[] args = new Object[]{ctx, methodName, overriddenClass, callbackClass};
        return new DeploymentException(EJBExceptionsHelper.buildMessage(resourceBundle, args, "1038"));
    }
}

