/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.InjectableReference;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistenceUnitReference
extends InjectableReference
implements XMLizable,
Serializable {
    public static final String PERSISTENCE_UNIT_CLASS_NAME = "javax.persistence.EntityManagerFactory";
    public static final String PERSISTENCE_UNIT_REF_TAG = "persistence-unit-ref";
    private static final String DESCRIPTION_TAG = "description";
    public static final String PERSISTENCE_UNIT_REF_NAME_TAG = "persistence-unit-ref-name";
    private static final String PERSISTENCE_UNIT_NAME_TAG = "persistence-unit-name";
    private String unitName = "";

    public PersistenceUnitReference(String name) {
        super(name);
        this.setReferenceClass(PERSISTENCE_UNIT_CLASS_NAME);
    }

    public PersistenceUnitReference(Node node) throws InstantiationException {
        this.setReferenceClass(PERSISTENCE_UNIT_CLASS_NAME);
        this.parseXML(node);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String name) {
        this.unitName = name;
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName)) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals(PERSISTENCE_UNIT_REF_NAME_TAG)) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals(DESCRIPTION_TAG)) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals(PERSISTENCE_UNIT_NAME_TAG)) {
                    this.setUnitName(value);
                    continue;
                }
                if (this.parseInjectionTarget(node)) continue;
                throw new InstantiationException("Unknown <persistence-unit-ref> subtag: " + nodeName);
            }
        }
        if (this.getName() == null || this.getName().equals("")) {
            throw new InstantiationException("<persistence-unit-ref> tag with missing <persistence-unit-ref-name> subtag");
        }
    }

    public void writeXML(PrintWriter out, String indentation) {
        out.println(indentation + "<" + PERSISTENCE_UNIT_REF_TAG + ">");
        this.writeTag(DESCRIPTION_TAG, this.getDescription(), out, indentation);
        this.writeTag(PERSISTENCE_UNIT_REF_NAME_TAG, this.getName(), out, indentation);
        this.writeTag(PERSISTENCE_UNIT_NAME_TAG, this.getUnitName(), out, indentation);
        this.writeInjectableXML(out, indentation + "\t");
        out.println(indentation + "</" + PERSISTENCE_UNIT_REF_TAG + ">");
    }

    protected void writeTag(String tagName, String tagValue, PrintWriter out, String indentation) {
        if (tagValue != null) {
            out.println(indentation + "\t<" + tagName + ">" + XMLUtils.encode(tagValue) + "</" + tagName + ">");
        }
    }

    public String toString() {
        return "PersistenceUnit: " + this.getUnitName();
    }
}

