/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.MessageDestination;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.BeanPool;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.MessageDrivenBeanPool;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.deployment.ActivationConfig;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.BeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptorXMLFactory;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.MessageDrivenBean;
import oracle.oc4j.admin.management.shared.MDBConfigInfo;

public class MessageDrivenBeanDescriptor
extends BeanDescriptor {
    private static final int DEFAULT_ACKNOWLEDGE_MODE = 1;
    private static final String DEFAULT_MESSAGING_TYPE = "javax.jms.MessageListener";
    private String messageSelector;
    private int acknowledgeMode;
    private boolean durable;
    private String messagingType;
    private String destinationType;
    private String destinationLink;
    private List activationConfigs;
    private List oracleActivationConfigs;
    protected static final int DEFAULT_LISTENER_THREADS = 1;
    protected static final int DEFAULT_TX_TIMEOUT = 86400;
    protected static final int DEFAULT_DEQUEUE_RETRY_COUNT = 0;
    protected static final int DEFAULT_DEQUEUE_RETRY_INTERVAL = 60;
    protected static final int DEFAULT_MAX_DELIVERY_COUNT = 5;
    public static final String JMS_QUEUE_TYPE = "javax.jms.Queue";
    public static final String JMS_TOPIC_TYPE = "javax.jms.Topic";
    private int listenerThreads;
    private int transactionTimeout;
    private int dequeueRetryCount;
    private int dequeueRetryInterval;
    private int maxDeliveryCount;
    private String destinationLocation;
    private String connectionFactoryLocation;
    private String resUser = null;
    private String resPassword = null;
    private String subscriptionName;
    private String wrapperClassName;
    private String resourceAdapter;
    private boolean enabled = true;
    private Class endpointWrapper;
    private Class messageListener;
    private MessageDrivenBeanPool beanPool;
    private static Logger m_logger = EJBTraceLogger.getLogger(MessageDrivenBeanDescriptor.class);

    public MessageDrivenBeanDescriptor(EJBPackage ejbPackage, String ejbName) {
        this(ejbPackage);
        this.setName(ejbName);
    }

    private MessageDrivenBeanDescriptor(EJBPackage ejbPackage) {
        super(ejbPackage);
        this.setDurable(false);
        this.setBeanType(3);
        this.setAcknowledgeMode(1);
        this.setMessagingType(DEFAULT_MESSAGING_TYPE);
        this.setListenerThreads(1);
        this.setTransactionTimeout(86400);
        this.setDequeueRetryCount(0);
        this.setDequeueRetryInterval(60);
        this.setMaxDeliveryCount(5);
    }

    public void initialize() throws InstantiationException {
        super.initialize();
        this.validateCredentials();
        if (this.getResourceAdapter() == null && this.getOracleActivationConfigs().size() > 0) {
            ActivationConfig config = this.getConfigProperty("acknowledgeMode");
            if (config != null) {
                if (config.getStringValue().equals("Auto-acknowledge")) {
                    this.setAcknowledgeMode(1);
                } else if (config.getStringValue().equals("Dups-ok-acknowledge")) {
                    this.setAcknowledgeMode(3);
                } else {
                    throw new InstantiationException("Unexpected acknowledgeMode value: " + config.getStringValue());
                }
            }
            if ((config = this.getConfigProperty("connectionFactoryJndiName")) != null) {
                this.setConnectionFactoryLocation(config.getStringValue());
            }
            if ((config = this.getConfigProperty("destinationName")) != null) {
                this.setDestinationLocation(config.getStringValue());
            }
            if ((config = this.getConfigProperty("destinationType")) != null) {
                if (config.getStringValue().equals(JMS_QUEUE_TYPE) || config.getStringValue().equals(JMS_TOPIC_TYPE)) {
                    this.setDestinationType(config.getStringValue());
                } else {
                    throw new InstantiationException("Unexpected destinationType value: " + config.getStringValue());
                }
            }
            if ((config = this.getConfigProperty("messageSelector")) != null) {
                this.setMessageSelector(config.getStringValue());
            }
            if ((config = this.getConfigProperty("subscriptionName")) != null) {
                this.setSubscriptionName(config.getStringValue());
            }
            if ((config = this.getConfigProperty("subscriptionDurability")) != null) {
                if (config.getStringValue().equals("Durable")) {
                    this.setDurable(true);
                } else if (config.getStringValue().equals("NonDurable")) {
                    this.setDurable(false);
                } else {
                    throw new InstantiationException("Unexpected subscriptionDurability value: " + config.getStringValue());
                }
            }
            if ((config = this.getConfigProperty("receiverThreads")) != null) {
                this.setListenerThreads(Integer.parseInt(config.getStringValue()));
            }
            if ((config = this.getConfigProperty("transactionTimeout")) != null) {
                this.setTransactionTimeout(Integer.parseInt(config.getStringValue()));
            }
            if ((config = this.getConfigProperty("maxDeliveryCnt")) != null) {
                this.setMaxDeliveryCount(Integer.parseInt(config.getStringValue()));
            }
        }
        if (this.getDestinationLocation() == null && this.getDestinationLink() != null) {
            String destLinkName = this.getDestinationLink();
            String destLinkJar = null;
            if (destLinkName != null && destLinkName.indexOf(35) >= 0) {
                destLinkJar = destLinkName.substring(0, destLinkName.indexOf(35));
                destLinkName = destLinkName.substring(destLinkName.indexOf(35) + 1);
            }
            EJBPackage destinationPackage = null;
            if (destLinkJar != null) {
                EJBPackageDeployment deployment = this.getEJBPackage().getContainer().getEJBPackage(destLinkJar);
                if (deployment == null) {
                    throw new InvalidEJBAssemblyException("Unknown ejb-jar referenced in message-destination-link for '" + this.getName() + "':  '" + destLinkName, "20.7.2");
                }
                destinationPackage = deployment.getPackage();
            } else {
                destinationPackage = this.getEJBPackage();
            }
            MessageDestination dest = destinationPackage.getMessageDestination(destLinkName);
            if (dest != null) {
                if (dest.getType() != null) {
                    if (this.getDestinationType() == null) {
                        this.setDestinationType(dest.getType());
                    }
                    if (!this.getDestinationType().equals(dest.getType())) {
                        throw new InstantiationException("destination-link target mismatch for MessageDrivenBean " + this.getName() + ": The target object must be type-compatible with the type declared in assembly descriptor, ie. they must either both be javax.jms.Topic or both be javax.jms.Queue");
                    }
                    if (!dest.getType().equals(JMS_QUEUE_TYPE) && !dest.getType().equals(JMS_TOPIC_TYPE)) {
                        throw new InstantiationException("Invalid destination type " + dest.getType() + " for destination-link " + destLinkName + ". It must be javax.jms.Topic or javax.jms.Queue or ");
                    }
                }
                if (dest.getLocation() != null) {
                    this.setDestinationLocation(dest.getLocation());
                } else {
                    this.setDestinationLocation(dest.getName());
                }
            } else {
                throw new InvalidEJBAssemblyException("message-destination-link of message-driven bean '" + this.getName() + "' must match the name of a destination defined by <message-destination> element in the assembly descriptor", "20.7.2");
            }
        }
        if (this.getResourceAdapter() == null) {
            if (this.getDestinationLocation() == null) {
                throw new InstantiationException("No destination location set for message-driven bean " + this.getName());
            }
            if (this.getDestinationType() != null && !this.getDestinationType().equals(JMS_QUEUE_TYPE) && !this.getDestinationType().equals(JMS_TOPIC_TYPE)) {
                throw new InstantiationException("Invalid destination type " + this.getDestinationType() + " for bean " + this.getName() + ". It must be defined in the assembley descriptor as javax.jms.Topic or javax.jms.Queue.");
            }
            if (this.isDurable() && this.getSubscriptionName() == null) {
                throw new InstantiationException("MessageDrivenBean '" + this.getName() + "' has empty subscription name");
            }
        }
    }

    public void initialize(EJBDeploymentContext container) throws InstantiationException {
        super.initialize(container);
        if (this.getPackage().getCompatibility() < 3 && !MessageDrivenBean.class.isAssignableFrom(this.getEJBClass())) {
            throw new InvalidEJBAssemblyException(this.getEJBClass().getName() + " does not implement javax.ejb.MessageDrivenBean", "15.7.2");
        }
        Class lsntr = this.getMessageListener();
        if (this.getPackage().getCompatibility() < 3 && !lsntr.isAssignableFrom(this.getEJBClass())) {
            throw new InvalidEJBAssemblyException("ejb-class of message-driven bean '" + this.getName() + "' does not implement '" + this.getMessagingType(), "15.7.2");
        }
        if (!Modifier.isPublic(this.getEJBClass().getModifiers())) {
            throw new InvalidEJBAssemblyException("ejb-class of message-driven bean '" + this.getName() + "' must be declared public", "15.7.2");
        }
        if (Modifier.isAbstract(this.getEJBClass().getModifiers())) {
            throw new InvalidEJBAssemblyException("ejb-class of message-driven bean '" + this.getName() + "' must not be declared abstract", "15.7.2");
        }
        if (Modifier.isFinal(this.getEJBClass().getModifiers())) {
            throw new InvalidEJBAssemblyException("ejb-class of message-driven bean '" + this.getName() + "' must not be declared final", "15.7.2");
        }
    }

    public boolean isMessageDriven() {
        return true;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getDestinationLink() {
        return this.destinationLink;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public String getConnectionFactoryLocation() {
        return this.connectionFactoryLocation;
    }

    public String getResUser() {
        return this.resUser;
    }

    public String getResPassword() {
        return this.resPassword;
    }

    public int getDequeueRetryCount() {
        return this.dequeueRetryCount;
    }

    public int getDequeueRetryInterval() {
        return this.dequeueRetryInterval;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public String getDestinationLocation() {
        return this.destinationLocation;
    }

    public int getListenerThreads() {
        return this.listenerThreads;
    }

    public String getResourceAdapter() {
        return this.resourceAdapter;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public String getWrapperClassName() {
        return this.wrapperClassName;
    }

    public List getActivationConfigs() {
        if (this.activationConfigs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.activationConfigs;
    }

    public void addActivationConfigProperty(ActivationConfig newConfig) {
        if (this.activationConfigs == null) {
            this.activationConfigs = new ArrayList();
        }
        this.activationConfigs.add(newConfig);
    }

    protected ActivationConfig getConfigProperty(String configName) {
        if (this.oracleActivationConfigs == null) {
            return null;
        }
        Iterator i = this.oracleActivationConfigs.iterator();
        while (i.hasNext()) {
            ActivationConfig currentProperty = (ActivationConfig)i.next();
            if (!configName.equalsIgnoreCase(currentProperty.getName())) continue;
            return currentProperty;
        }
        return null;
    }

    public ActivationConfig findOracleActivationConfig(ActivationConfig configToFind) {
        if (this.oracleActivationConfigs == null) {
            return null;
        }
        for (int i = 0; i < this.oracleActivationConfigs.size(); ++i) {
            ActivationConfig currentConfig = (ActivationConfig)this.oracleActivationConfigs.get(i);
            if (!currentConfig.getName().equals(configToFind.getName())) continue;
            return currentConfig;
        }
        return null;
    }

    public List getOracleActivationConfigs() {
        if (this.oracleActivationConfigs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.oracleActivationConfigs;
    }

    public void addOracleActivationConfig(ActivationConfig property) {
        if (this.oracleActivationConfigs == null) {
            this.oracleActivationConfigs = new ArrayList();
        }
        this.oracleActivationConfigs.add(property);
    }

    public void setMinInstances(int instances) {
        super.setMinInstances(instances);
        if (this.getMaxInstances() < instances && this.getMaxInstances() > 0) {
            this.setMaxInstances(instances);
        }
    }

    public void setMaxInstances(int instances) {
        super.setMaxInstances(instances);
        if (instances > 0 && this.getMinInstances() > instances) {
            this.setMinInstances(instances);
        }
    }

    public void setDestinationLink(String destinationLink) {
        this.destinationLink = destinationLink;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public void setMessagingType(String messagingType) {
        this.messagingType = messagingType;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    protected void setConnectionFactoryLocation(String connectionFactoryLocation) {
        this.connectionFactoryLocation = connectionFactoryLocation;
    }

    protected void setResUser(String resUser) {
        this.resUser = resUser;
    }

    protected void setResPassword(String resPassword) {
        this.resPassword = resPassword;
    }

    protected void setDequeueRetryCount(int dequeueRetryCount) {
        this.dequeueRetryCount = dequeueRetryCount;
    }

    protected void setDequeueRetryInterval(int dequeueRetryInterval) {
        this.dequeueRetryInterval = dequeueRetryInterval;
    }

    public void setMaxDeliveryCount(int maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
    }

    protected void setDestinationLocation(String destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    protected void setListenerThreads(int listenerThreads) {
        this.listenerThreads = listenerThreads;
    }

    public void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    protected void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    protected void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setEndpointWrapperName(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
    }

    public void setEndpointWrapper(Class wrapper) {
        this.endpointWrapper = wrapper;
    }

    public Class getEndpointWrapper() {
        return this.endpointWrapper;
    }

    private void setMessageListener(String value) {
        try {
            this.setMessageListener(Class.forName(value, true, this.getEJBPackage().getEJBClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Unable to load class for messaging-type : " + value);
        }
    }

    public void setMessageListener(Class messageListener) {
        this.messageListener = messageListener;
    }

    public Class getMessageListener() {
        if (this.messageListener == null) {
            this.setMessageListener(this.getMessagingType());
        }
        return this.messageListener;
    }

    public AbstractEJBHome createHomeInstance(EJBContainer container, ClassLoader loader) {
        return null;
    }

    public List getMDBActivationConfigProperties() {
        int i = 0;
        ArrayList<MDBConfigInfo> msgProps = new ArrayList<MDBConfigInfo>();
        if (this.getResourceAdapter() != null) {
            List a_list = this.getActivationConfigs();
            for (i = 0; i < a_list.size(); ++i) {
                ActivationConfig currentConfig = (ActivationConfig)a_list.get(i);
                if (!currentConfig.isElementActivationConfigProperty()) continue;
                String name = currentConfig.getName();
                String value = currentConfig.getStringValue();
                String deployedValue = ((ActivationConfig)this.getOracleActivationConfigs().get(i)).getStringValue();
                msgProps.add(new MDBConfigInfo(name, value, deployedValue));
            }
        }
        return msgProps;
    }

    public String isDeployed() {
        return null;
    }

    public BeanDescriptorXMLFactory getBeanDescriptorXMLFactory() {
        return MessageDrivenBeanDescriptorXMLFactory.getInstance();
    }

    private void validateCredentials() throws InstantiationException {
        if (this.resUser == null) {
            if (this.resPassword != null) {
                throw new InstantiationException("no res-user supplied with non-null res-password");
            }
        } else {
            if (this.resUser.equals("") || this.resUser.equals("null")) {
                throw new InstantiationException("res-user cannot be set to empty or \"null\" string");
            }
            if (this.resPassword == null) {
                throw new InstantiationException("res-user supplied with null res-password. If you do want to set a null password, set its value to \"null\" string");
            }
        }
        if (this.resPassword != null && this.resPassword.equals("null")) {
            this.resPassword = null;
        }
    }

    protected BeanPool createBeanPool(Object home) {
        return new MessageDrivenBeanPool(this, (MessageDrivenHome)home);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

