/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExcludeList
extends AbstractDescribable
implements XMLizable {
    private List methods;

    public ExcludeList() throws InstantiationException {
    }

    public ExcludeList(EJBPackage jar, Node parent) throws InstantiationException {
        this.parseExcludeListNode(parent);
    }

    public void parseExcludeListNode(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (XMLUtils.isCommentOrID(name)) continue;
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("method")) {
                    this.addMethod(new MethodDescriptor(node));
                    continue;
                }
                throw new InstantiationException("Unknown exclude-list subtag: '" + name + "'");
            }
        }
    }

    public void addMethod(MethodDescriptor method) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.add(method);
    }

    public List getMethods() {
        return this.methods == null ? Collections.EMPTY_LIST : this.methods;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<exclude-list>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.methods != null) {
            XMLUtils.writeAll(this.methods, out, indention + "\t");
        }
        out.println(indention + "</exclude-list>");
    }
}

