/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.InjectableReference;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.http.deployment.WebApp24Descriptor;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBReference
extends InjectableReference
implements XMLizable,
Comparable,
Cloneable,
Serializable,
WebApp24Descriptor {
    private static final long serialVersionUID = -8563304147979290465L;
    private String home;
    private String type;
    private String componentInterface;
    private String link;
    private String location;
    private boolean local;
    private boolean endpoint;
    private boolean createdByAnnotation;
    private boolean remoteServerRef;
    private String jndiPropertiesFile;

    public EJBReference(String name, boolean local, boolean createdByAnnotation) {
        this.local = local;
        this.setName(name);
        this.createdByAnnotation = createdByAnnotation;
    }

    public EJBReference(Node parent, boolean local) throws InstantiationException {
        this.parseXML(parent, local);
    }

    public void parseXML(Node parent, boolean local) throws InstantiationException {
        this.local = local;
        this.createdByAnnotation = false;
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            this.parseNode(name, node);
        }
        if (this.home == null && this.componentInterface == null) {
            throw new InvalidEJBAssemblyException("No home or interface specified for ejb-ref: " + this, null);
        }
        if (this.getName() == null) {
            throw new InvalidEJBAssemblyException("ejb-ref tag is missing ejb-ref-name tag", null);
        }
        if (this.home != null && this.home.equals(this.componentInterface)) {
            throw new InvalidEJBAssemblyException("ejb-ref tag '" + this.getName() + "' had equal home and remote tag values (is impossible)", null);
        }
        if (this.link != null && this.link.equals("")) {
            throw new InvalidEJBAssemblyException("ejb-link defined with missing (empty) value for ejb-ref '" + this.getName() + "'", null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseNode(String name, Node node) throws InstantiationException {
        if (name.equals("description")) {
            this.setDescription(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("ejb-ref-name")) {
            this.setName(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("ejb-ref-type")) {
            String typeName = XMLUtils.getStringValue(node);
            if (!typeName.equals("Entity") && !typeName.equals("Session")) throw new InvalidEJBAssemblyException("Illegal ejb-ref-type value, (" + typeName + ") legal values are Entity and Session", null);
            this.type = typeName.intern();
            return;
        } else if (name.equals("home")) {
            if (this.local) {
                throw new InvalidEJBAssemblyException("'home' is not a valid subtag for an ejb-local-ref, use 'local-home' instead", null);
            }
            this.home = XMLUtils.getStringValue(node);
            return;
        } else if (name.equals("remote")) {
            if (this.local) {
                throw new InvalidEJBAssemblyException("'remote' is not a valid subtag for an ejb-local-ref, use 'local' instead", null);
            }
            this.componentInterface = XMLUtils.getStringValue(node);
            return;
        } else if (name.equals("local-home")) {
            if (!this.local) {
                throw new InvalidEJBAssemblyException("'local-home' is not a valid subtag for an ejb-ref, use 'home' instead or switch to using an ejb-local-ref if you want a local reference", null);
            }
            this.home = XMLUtils.getStringValue(node);
            return;
        } else if (name.equals("local")) {
            if (!this.local) {
                throw new InvalidEJBAssemblyException("'local' is not a valid subtag for an ejb-ref, use 'remote' instead or switch to using an ejb-local-ref if you want a local reference", null);
            }
            this.componentInterface = XMLUtils.getStringValue(node);
            return;
        } else if (name.equals("ejb-link")) {
            this.link = XMLUtils.getStringValue(node);
            return;
        } else if (name.equals("mapped-name")) {
            String mappedName = XMLUtils.getStringValue(node);
            if (mappedName.length() <= 0) return;
            this.setLocation(mappedName);
            return;
        } else {
            if (this.parseInjectionTarget(node)) return;
            throw new InvalidEJBAssemblyException("Unknown ejb-reference subtag: " + name, null);
        }
    }

    public void setRemoteName(String name) {
        this.componentInterface = name;
        this.firePropertyChangeEvent("remoteName", this.componentInterface, name);
    }

    public void setHomeName(String name) {
        this.home = name;
        this.firePropertyChangeEvent("homeName", this.home, name);
    }

    public String getLink() {
        return this.link;
    }

    public void setType(String type) {
        this.type = type;
        this.firePropertyChangeEvent("type", null, type);
    }

    public void setEJBLink(String link) {
        this.link = link;
        this.firePropertyChangeEvent("link", this.link, link);
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.print(indention + "<ejb-ref-mapping");
        if (this.getName() != null) {
            out.print(" name=\"" + XMLUtils.encode(this.getName()) + "\"");
        }
        if (this.location != null) {
            out.print(" location=\"" + XMLUtils.encode(this.location) + "\"");
        }
        if (this.isRemoteServerRef()) {
            out.print(" remote-server-ref=\"" + XMLUtils.encode(Boolean.toString(this.isRemoteServerRef())) + "\"");
        }
        if (this.jndiPropertiesFile != null) {
            out.print(" jndi-properties-file=\"" + XMLUtils.encode(this.jndiPropertiesFile) + "\"");
        }
        out.println(" />");
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        this.remoteServerRef = XMLUtils.getBooleanNodeAttribute(parent, "remote-server-ref") == 1;
        this.jndiPropertiesFile = XMLUtils.getNodeAttribute(parent, "jndi-properties-file");
        if (this.jndiPropertiesFile == null) {
            this.jndiPropertiesFile = "jndi.properties";
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        if (this.local) {
            out.println(indention + "<ejb-local-ref>");
        } else {
            out.println(indention + "<ejb-ref>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<ejb-ref-name>" + XMLUtils.encode(this.getName()) + "</ejb-ref-name>");
        }
        out.println(indention + "\t<ejb-ref-type>" + this.type + "</ejb-ref-type>");
        if (this.home != null) {
            if (this.local) {
                out.println(indention + "\t<local-home>" + XMLUtils.encode(this.home) + "</local-home>");
            } else {
                out.println(indention + "\t<home>" + XMLUtils.encode(this.home) + "</home>");
            }
        }
        if (this.componentInterface != null) {
            if (this.local) {
                out.println(indention + "\t<local>" + XMLUtils.encode(this.componentInterface) + "</local>");
            } else {
                out.println(indention + "\t<remote>" + XMLUtils.encode(this.componentInterface) + "</remote>");
            }
        }
        if (this.link != null) {
            out.println(indention + "\t<ejb-link>" + XMLUtils.encode(this.link) + "</ejb-link>");
        }
        this.writeMappedName(out, indention + "\t", this.location);
        this.writeInjectableXML(out, indention + "\t");
        if (this.local) {
            out.println(indention + "</ejb-local-ref>");
        } else {
            out.println(indention + "</ejb-ref>");
        }
    }

    public void writeWebApp24XML(PrintWriter out, String indention) {
        if (this.local) {
            out.println(indention + "<ejb-local-ref>");
        } else {
            out.println(indention + "<ejb-ref>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<ejb-ref-name>" + XMLUtils.encode(this.getName()) + "</ejb-ref-name>");
        }
        out.println(indention + "\t<ejb-ref-type>" + this.type + "</ejb-ref-type>");
        if (this.home != null) {
            if (this.local) {
                out.println(indention + "\t<local-home>" + XMLUtils.encode(this.home) + "</local-home>");
            } else {
                out.println(indention + "\t<home>" + XMLUtils.encode(this.home) + "</home>");
            }
        }
        if (this.componentInterface != null) {
            if (this.local) {
                out.println(indention + "\t<local>" + XMLUtils.encode(this.componentInterface) + "</local>");
            } else {
                out.println(indention + "\t<remote>" + XMLUtils.encode(this.componentInterface) + "</remote>");
            }
        }
        if (this.link != null) {
            out.println(indention + "\t<ejb-link>" + XMLUtils.encode(this.link) + "</ejb-link>");
        }
        if (this.local) {
            out.println(indention + "</ejb-local-ref>");
        } else {
            out.println(indention + "</ejb-ref>");
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getRemoteName() {
        return this.componentInterface;
    }

    public String getHomeName() {
        return this.home;
    }

    public String getEJBLink() {
        return this.link;
    }

    public String getType() {
        return this.type;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(boolean endpoint) {
        this.endpoint = endpoint;
    }

    public int compareTo(Object other) {
        if (!(other instanceof EJBReference)) {
            return -1;
        }
        EJBReference reference = (EJBReference)other;
        if (reference.local && !this.local) {
            return -1;
        }
        if (!reference.local && this.local) {
            return 1;
        }
        return this.getName().compareTo(reference.getName());
    }

    public Object clone() {
        EJBReference other = new EJBReference(this.getName(), this.isLocal(), this.createdByAnnotation);
        other.home = this.home;
        other.componentInterface = this.componentInterface;
        other.setReferenceClass(this.getReferenceClass());
        other.type = this.type;
        other.link = this.link;
        other.location = this.location;
        other.remoteServerRef = this.remoteServerRef;
        other.jndiPropertiesFile = this.jndiPropertiesFile;
        return other;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String value) {
        this.home = value;
    }

    public String getRemote() {
        return this.componentInterface;
    }

    public void setRemote(String value) {
        this.componentInterface = value;
    }

    public String getReferenceClass() {
        if (this.home != null) {
            return this.home;
        }
        return this.componentInterface;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.local) {
            buf.append("ejb-local-ref: ");
            buf.append("\n");
            buf.append("  description: ");
            buf.append(this.getDescription());
            buf.append("\n");
            buf.append("  ejb-ref-name: ");
            buf.append(this.getName());
            buf.append("\n");
            buf.append("  ejb-ref-type: ");
            buf.append(this.getType());
            buf.append("\n");
            buf.append("  local-home: ");
            buf.append(this.getHome());
            buf.append("\n");
            buf.append("  local: ");
            buf.append(this.getRemoteName());
            buf.append("\n");
            buf.append("  ejb-link: ");
            buf.append(this.getLink());
            buf.append("\n");
            buf.append("  ejb-ref-mapping: ");
            buf.append(this.location);
            buf.append("\n");
        } else {
            buf.append("ejb-ref: ");
            buf.append("\n");
            buf.append("  description: ");
            buf.append(this.getDescription());
            buf.append("\n");
            buf.append("  ejb-ref-name: ");
            buf.append(this.getName());
            buf.append("\n");
            buf.append("  ejb-ref-type: ");
            buf.append(this.getType());
            buf.append("\n");
            buf.append("  home: ");
            buf.append(this.getHome());
            buf.append("\n");
            buf.append("  remote: ");
            buf.append(this.getRemoteName());
            buf.append("\n");
            buf.append("  ejb-link: ");
            buf.append(this.getLink());
            buf.append("\n");
            buf.append("  ejb-ref-mapping: ");
            buf.append(this.location);
            buf.append("\n");
            buf.append("  remote-server-ref: ");
            buf.append(this.remoteServerRef);
            buf.append("\n");
            buf.append("  jndi-properties-file: ");
            buf.append(this.jndiPropertiesFile);
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean isCreatedByAnnotation() {
        return this.createdByAnnotation;
    }

    public boolean isRemoteServerRef() {
        return this.remoteServerRef;
    }

    public String getJndiPropertiesFile() {
        return this.jndiPropertiesFile;
    }
}

