/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompilerUtils;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.QueryMethodDescriptor;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBQuery
implements XMLizable {
    protected String description;
    protected MethodDescriptor method;
    protected String query = "";
    protected String querySpecification = "";
    protected boolean resultTypeRemotes;
    protected String selectClause;
    protected String fromClause;
    protected String whereClause;

    public EJBQuery(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("query")) {
                this.query = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("query-method") || name.equals("method")) {
                this.method = new QueryMethodDescriptor(node);
                continue;
            }
            if (name.equals("description")) {
                this.description = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("ejb-ql")) {
                this.query = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("query-spec")) {
                this.querySpecification = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("result-type-mapping")) {
                this.setResultTypeMapping(XMLUtils.getStringValue(node));
                continue;
            }
            throw new InvalidEJBAssemblyException("Unknown query subtag: " + name, "22.5");
        }
        if (this.method == null) {
            throw new InvalidEJBAssemblyException("query tag with missing query-method subtag", "22.5");
        }
    }

    public EJBQuery(String query, Method method) {
        this.query = query;
        this.method = new QueryMethodDescriptor(method);
    }

    public void setResultTypeMapping(String value) throws InstantiationException {
        if (value.equals("Local")) {
            this.resultTypeRemotes = false;
        } else if (value.equals("Remote")) {
            this.resultTypeRemotes = true;
        } else {
            throw new InvalidEJBAssemblyException("Invalid result-type-mapping value, '" + value + "', legal values are 'Local' and 'Remote'", "11.2.5");
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<query>");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.method != null) {
            this.method.writeXML(out, indention + "\t");
        }
        if (this.resultTypeRemotes) {
            out.println(indention + "\t<result-type-mapping>Remote</result-type-mapping>");
        }
        if (this.query != null) {
            out.println(indention + "\t<ejb-ql>" + XMLUtils.encode(this.query) + "</ejb-ql>");
        }
        if (this.querySpecification != null) {
            out.println(indention + "\t<query-spec>" + XMLUtils.encode(this.querySpecification) + "</query-spec>");
        }
        out.println(indention + "</query>");
    }

    public boolean getResultTypeRemotes() {
        return this.resultTypeRemotes;
    }

    public void parseQuery() throws CompilationException {
        String queryLowercase = this.query.toLowerCase().trim();
        if (queryLowercase.startsWith("select")) {
            this.parseSelect(queryLowercase, "select".length());
        } else if (queryLowercase.startsWith("from")) {
            this.parseFrom(queryLowercase, "from".length());
        } else if (queryLowercase.startsWith("where")) {
            this.parseWhere(queryLowercase, "where".length());
        } else {
            throw new CompilationException("Query must start with select, from or where");
        }
    }

    public void parseSelect(String queryLowercase, int pos) throws CompilationException {
        int fromIndex = CompilerUtils.getTokenPosition(queryLowercase, pos, "from");
        if (fromIndex >= queryLowercase.length()) {
            int whereIndex = CompilerUtils.getTokenPosition(queryLowercase, pos, "from");
            if (whereIndex >= queryLowercase.length()) {
                this.selectClause = this.query.substring(pos);
            } else {
                this.selectClause = this.query.substring(pos, whereIndex + "where".length()).trim();
                this.parseWhere(queryLowercase, whereIndex + "where".length());
            }
        } else {
            this.selectClause = this.query.substring(pos, fromIndex).trim();
            this.parseFrom(queryLowercase, fromIndex + "from".length());
        }
    }

    public void parseFrom(String queryLowercase, int pos) throws CompilationException {
        int whereIndex = CompilerUtils.getTokenPosition(queryLowercase, pos, "where");
        if (whereIndex >= queryLowercase.length()) {
            this.fromClause = this.query.substring(pos);
        } else {
            this.fromClause = this.query.substring(pos, whereIndex).trim();
            this.parseWhere(queryLowercase, whereIndex + "where".length());
        }
    }

    public void parseWhere(String queryLowercase, int pos) throws CompilationException {
        this.whereClause = this.query.substring(pos);
    }

    public String getFrom() {
        return this.fromClause;
    }

    public String getSelect() {
        return this.selectClause;
    }

    public String getWhere() {
        return this.whereClause;
    }

    public MethodDescriptor getMethod() {
        return this.method;
    }

    public String getQuery() {
        return this.query;
    }

    public String getSpecification() {
        return this.querySpecification;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSpecification(String specification) {
        this.querySpecification = specification;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

