/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.NameValueProperty;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivationConfig
extends AbstractDescribable
implements XMLizable,
NameValueProperty {
    private String value;
    private String xmlElementName = "activation-config-property";

    public ActivationConfig(String name, String description, String value) {
        this.setName(name);
        this.setDescription(description);
        this.value = value;
    }

    public ActivationConfig(String name, String description, String value, String _xmlElementName) {
        this.xmlElementName = _xmlElementName;
        this.setName(name);
        this.value = value;
    }

    public ActivationConfig(Node parent, String _xmlElementName) throws InstantiationException {
        this.xmlElementName = _xmlElementName;
        this.parseNameValueNode(parent);
    }

    public ActivationConfig(Node parent) throws InstantiationException {
        this.parseNameValueNode(parent);
    }

    private void parseNameValueNode(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (this.xmlElementName.equals("config-property")) {
                    if (nodeName.equals("description")) {
                        this.setDescription(value);
                        continue;
                    }
                    if (nodeName.equals("config-property-name")) {
                        this.setName(value);
                        continue;
                    }
                    if (nodeName.equals("config-property-value")) {
                        this.value = value;
                        continue;
                    }
                    throw new InstantiationException("Unknown config-property subtag: " + nodeName);
                }
                if (nodeName.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals("activation-config-property-name")) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals("activation-config-property-value")) {
                    this.value = value;
                    continue;
                }
                throw new InstantiationException("Unknown activation-config-property subtag: " + nodeName);
            }
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<" + this.xmlElementName + ">");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.xmlElementName.equals("config-property")) {
            if (this.getName() != null) {
                out.println(indention + "\t<config-property-name>" + XMLUtils.encode(this.getName()) + "</config-property-name>");
            }
            if (this.value != null) {
                out.println(indention + "\t<config-property-value>" + XMLUtils.encode(this.value) + "</config-property-value>");
            }
        } else {
            if (this.getName() != null) {
                out.println(indention + "\t<activation-config-property-name>" + XMLUtils.encode(this.getName()) + "</activation-config-property-name>");
            }
            if (this.value != null) {
                out.println(indention + "\t<activation-config-property-value>" + XMLUtils.encode(this.value) + "</activation-config-property-value>");
            }
        }
        out.println(indention + "</" + this.xmlElementName + ">");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        if (this.isElementConfigProperty() || this.isElementActivationConfigProperty()) {
            out.println(indention + "\t<config-property>");
            if (this.getName() != null) {
                out.println(indention + "\t<config-property-name>" + XMLUtils.encode(this.getName()) + "</config-property-name>");
            }
            if (this.value != null) {
                out.println(indention + "\t<config-property-value>" + XMLUtils.encode(this.value) + "</config-property-value>");
            }
            out.println(indention + "\t</config-property>");
        }
    }

    public String getStringValue() {
        return this.value;
    }

    public void setStringValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "<name: " + this.getName() + ", value: " + this.getStringValue() + ">";
    }

    public Object clone() {
        return new ActivationConfig(this.getName(), this.getDescription(), this.getStringValue());
    }

    public boolean isElementConfigProperty() {
        return this.xmlElementName.equals("config-property");
    }

    public boolean isElementActivationConfigProperty() {
        return this.xmlElementName.equals("activation-config-property");
    }
}

